@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDeployGroups.
 * @property appId The ID of the application that you want to deploy.
 * @property groups A list of consumer group ids.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property names A list of deploy group names.
 * @property outputFile
 */
public data class GetDeployGroupsResult(
    public val appId: String,
    public val groups: List<GetDeployGroupsGroup>,
    public val id: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetDeployGroupsResult): GetDeployGroupsResult = GetDeployGroupsResult(
            appId = javaType.appId(),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.edas.kotlin.outputs.GetDeployGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
