@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property belongRegion The ID of the physical region to which the namespace belongs.
 * @property debugEnable Indicates whether remote debugging is allowed in this region.
 * @property description The description of the namespace.
 * @property id The ID of the resource.
 * @property namespaceId The unique ID of the namespace generated by Enterprise Distributed Application Service (EDAS).
 * @property namespaceLogicalId The ID of the namespace. **Note:** The ID cannot be changed after the namespace is created. The ID is in the format of `Physical region ID:Logical region identifier`.
 * @property namespaceName The name of the namespace.
 * @property userId The ID of the Alibaba Cloud account to which the namespace belongs.
 */
public data class GetNamespacesNamespace(
    public val belongRegion: String,
    public val debugEnable: Boolean,
    public val description: String,
    public val id: String,
    public val namespaceId: String,
    public val namespaceLogicalId: String,
    public val namespaceName: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.GetNamespacesNamespace): GetNamespacesNamespace = GetNamespacesNamespace(
            belongRegion = javaType.belongRegion(),
            debugEnable = javaType.debugEnable(),
            description = javaType.description(),
            id = javaType.id(),
            namespaceId = javaType.namespaceId(),
            namespaceLogicalId = javaType.namespaceLogicalId(),
            namespaceName = javaType.namespaceName(),
            userId = javaType.userId(),
        )
    }
}
