@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name The name of this SLB configuration, empty for auto-generated by EDAS server.
 * @property portMappings The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
 * @property scheduler The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
 * @property slbId The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
 * @property specification The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
 * @property type The type of SLB instance, values can be 'internet' or 'intranet'.
 */
public data class K8sSlbAttachmentSlbConfig(
    public val name: String? = null,
    public val portMappings: List<K8sSlbAttachmentSlbConfigPortMapping>,
    public val scheduler: String,
    public val slbId: String? = null,
    public val specification: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.K8sSlbAttachmentSlbConfig): K8sSlbAttachmentSlbConfig = K8sSlbAttachmentSlbConfig(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            portMappings = javaType.portMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.edas.kotlin.outputs.K8sSlbAttachmentSlbConfigPortMapping.Companion.toKotlin(args0)
                })
            }),
            scheduler = javaType.scheduler(),
            slbId = javaType.slbId().map({ args0 -> args0 }).orElse(null),
            specification = javaType.specification().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
