@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certId The ID of your tls certification, this is used for 'HTTPS' protocol only.
 * @property loadbalancerProtocol The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
 * @property servicePort The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
 */
public data class K8sSlbAttachmentSlbConfigPortMapping(
    public val certId: String? = null,
    public val loadbalancerProtocol: String,
    public val servicePort: K8sSlbAttachmentSlbConfigPortMappingServicePort,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.K8sSlbAttachmentSlbConfigPortMapping): K8sSlbAttachmentSlbConfigPortMapping = K8sSlbAttachmentSlbConfigPortMapping(
            certId = javaType.certId().map({ args0 -> args0 }).orElse(null),
            loadbalancerProtocol = javaType.loadbalancerProtocol(),
            servicePort = javaType.servicePort().let({ args0 ->
                com.pulumi.alicloud.edas.kotlin.outputs.K8sSlbAttachmentSlbConfigPortMappingServicePort.Companion.toKotlin(args0)
            }),
        )
    }
}
