@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.edas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property port The port of k8s service, values should be within range [1, 65535].
 * @property protocol The protocol of k8s service, values can be 'TCP' or 'UDP'.
 * @property targetPort The port of k8s pod, values should be within range [1, 65535].
 */
public data class K8sSlbAttachmentSlbConfigPortMappingServicePort(
    public val port: Int,
    public val protocol: String,
    public val targetPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.edas.outputs.K8sSlbAttachmentSlbConfigPortMappingServicePort): K8sSlbAttachmentSlbConfigPortMappingServicePort =
            K8sSlbAttachmentSlbConfigPortMappingServicePort(
                port = javaType.port(),
                protocol = javaType.protocol(),
                targetPort = javaType.targetPort(),
            )
    }
}
