@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.AdConnectorDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECD Ad Connector Directory resource.
 * For information about ECD Ad Connector Directory and how to use it, see [What is Ad Connector Directory](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectordirectory).
 * > **NOTE:** Available since v1.174.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.eds.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     vswitchName: name,
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultAdConnectorDirectory = new alicloud.eds.AdConnectorDirectory("default", {
 *     directoryName: `${name}-${defaultInteger.result}`,
 *     desktopAccessType: "INTERNET",
 *     dnsAddresses: ["127&#46;0&#46;0&#46;2"],
 *     domainName: "corp.example.com",
 *     domainPassword: "Example1234",
 *     domainUserName: "sAMAccountName",
 *     enableAdminAccess: false,
 *     mfaEnabled: false,
 *     specification: 1,
 *     subDomainDnsAddresses: ["127&#46;0&#46;0&#46;3"],
 *     subDomainName: "child.example.com",
 *     vswitchIds: [defaultSwitch&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eds.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.ids[0],
 *     vswitch_name=name)
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_ad_connector_directory = alicloud.eds.AdConnectorDirectory("default",
 *     directory_name=f"{name}-{default_integer['result']}",
 *     desktop_access_type="INTERNET",
 *     dns_addresses=["127&#46;0&#46;0&#46;2"],
 *     domain_name="corp.example.com",
 *     domain_password="Example1234",
 *     domain_user_name="sAMAccountName",
 *     enable_admin_access=False,
 *     mfa_enabled=False,
 *     specification=1,
 *     sub_domain_dns_addresses=["127&#46;0&#46;0&#46;3"],
 *     sub_domain_name="child.example.com",
 *     vswitch_ids=[default_switch&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Eds.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         VswitchName = name,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultAdConnectorDirectory = new AliCloud.Eds.AdConnectorDirectory("default", new()
 *     {
 *         DirectoryName = $"{name}-{defaultInteger.Result}",
 *         DesktopAccessType = "INTERNET",
 *         DnsAddresses = new[]
 *         {
 *             "127.0.0.2",
 *         },
 *         DomainName = "corp.example.com",
 *         DomainPassword = "Example1234",
 *         DomainUserName = "sAMAccountName",
 *         EnableAdminAccess = false,
 *         MfaEnabled = false,
 *         Specification = 1,
 *         SubDomainDnsAddresses = new[]
 *         {
 *             "127.0.0.3",
 *         },
 *         SubDomainName = "child.example.com",
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eds.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Ids[0]),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewAdConnectorDirectory(ctx, "default", &eds.AdConnectorDirectoryArgs{
 * 			DirectoryName:     pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			DesktopAccessType: pulumi.String("INTERNET"),
 * 			DnsAddresses: pulumi.StringArray{
 * 				pulumi.String("127.0.0.2"),
 * 			},
 * 			DomainName:        pulumi.String("corp.example.com"),
 * 			DomainPassword:    pulumi.String("Example1234"),
 * 			DomainUserName:    pulumi.String("sAMAccountName"),
 * 			EnableAdminAccess: pulumi.Bool(false),
 * 			MfaEnabled:        pulumi.Bool(false),
 * 			Specification:     pulumi.Int(1),
 * 			SubDomainDnsAddresses: pulumi.StringArray{
 * 				pulumi.String("127.0.0.3"),
 * 			},
 * 			SubDomainName: pulumi.String("child.example.com"),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.AdConnectorDirectory;
 * import com.pulumi.alicloud.eds.AdConnectorDirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = EdsFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.ids()[0])
 *             .vswitchName(name)
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultAdConnectorDirectory = new AdConnectorDirectory("defaultAdConnectorDirectory", AdConnectorDirectoryArgs.builder()
 *             .directoryName(String.format("%s-%s", name,defaultInteger.result()))
 *             .desktopAccessType("INTERNET")
 *             .dnsAddresses("127.0.0.2")
 *             .domainName("corp.example.com")
 *             .domainPassword("Example1234")
 *             .domainUserName("sAMAccountName")
 *             .enableAdminAccess(false)
 *             .mfaEnabled(false)
 *             .specification(1)
 *             .subDomainDnsAddresses("127.0.0.3")
 *             .subDomainName("child.example.com")
 *             .vswitchIds(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.ids[0]}
 *       vswitchName: ${name}
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultAdConnectorDirectory:
 *     type: alicloud:eds:AdConnectorDirectory
 *     name: default
 *     properties:
 *       directoryName: ${name}-${defaultInteger.result}
 *       desktopAccessType: INTERNET
 *       dnsAddresses:
 *         - 127.0.0.2
 *       domainName: corp.example.com
 *       domainPassword: Example1234
 *       domainUserName: sAMAccountName
 *       enableAdminAccess: false
 *       mfaEnabled: false
 *       specification: 1
 *       subDomainDnsAddresses:
 *         - 127.0.0.3
 *       subDomainName: child.example.com
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Ad Connector Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/adConnectorDirectory:AdConnectorDirectory example <id>
 * ```
 * @property desktopAccessType The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
 * @property directoryName The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
 * @property dnsAddresses The DNS address list.
 * @property domainName The name of the domain.
 * @property domainPassword The user password of the domain administrator. The maximum number of English characters is 64.
 * @property domainUserName The username of the domain administrator. The maximum number of English characters is 64.
 * @property enableAdminAccess Whether to grant local administrator rights to users who use cloud desktops.
 * @property mfaEnabled Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
 * @property specification The AD Connector specifications. Valid values: `1`, `2`.
 * @property subDomainDnsAddresses The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
 * @property subDomainName The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
 * @property vswitchIds List of VSwitch IDs in the directory.
 */
public data class AdConnectorDirectoryArgs(
    public val desktopAccessType: Output<String>? = null,
    public val directoryName: Output<String>? = null,
    public val dnsAddresses: Output<List<String>>? = null,
    public val domainName: Output<String>? = null,
    public val domainPassword: Output<String>? = null,
    public val domainUserName: Output<String>? = null,
    public val enableAdminAccess: Output<Boolean>? = null,
    public val mfaEnabled: Output<Boolean>? = null,
    public val specification: Output<Int>? = null,
    public val subDomainDnsAddresses: Output<List<String>>? = null,
    public val subDomainName: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.AdConnectorDirectoryArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.AdConnectorDirectoryArgs =
        com.pulumi.alicloud.eds.AdConnectorDirectoryArgs.builder()
            .desktopAccessType(desktopAccessType?.applyValue({ args0 -> args0 }))
            .directoryName(directoryName?.applyValue({ args0 -> args0 }))
            .dnsAddresses(dnsAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainPassword(domainPassword?.applyValue({ args0 -> args0 }))
            .domainUserName(domainUserName?.applyValue({ args0 -> args0 }))
            .enableAdminAccess(enableAdminAccess?.applyValue({ args0 -> args0 }))
            .mfaEnabled(mfaEnabled?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .subDomainDnsAddresses(subDomainDnsAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subDomainName(subDomainName?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AdConnectorDirectoryArgs].
 */
@PulumiTagMarker
public class AdConnectorDirectoryArgsBuilder internal constructor() {
    private var desktopAccessType: Output<String>? = null

    private var directoryName: Output<String>? = null

    private var dnsAddresses: Output<List<String>>? = null

    private var domainName: Output<String>? = null

    private var domainPassword: Output<String>? = null

    private var domainUserName: Output<String>? = null

    private var enableAdminAccess: Output<Boolean>? = null

    private var mfaEnabled: Output<Boolean>? = null

    private var specification: Output<Int>? = null

    private var subDomainDnsAddresses: Output<List<String>>? = null

    private var subDomainName: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
     */
    @JvmName("qxvepvssoakwopuh")
    public suspend fun desktopAccessType(`value`: Output<String>) {
        this.desktopAccessType = value
    }

    /**
     * @param value The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("qjemqqnvdsnquvhq")
    public suspend fun directoryName(`value`: Output<String>) {
        this.directoryName = value
    }

    /**
     * @param value The DNS address list.
     */
    @JvmName("ihhrrbntxkicdmhe")
    public suspend fun dnsAddresses(`value`: Output<List<String>>) {
        this.dnsAddresses = value
    }

    @JvmName("mnprobfxiiexoypg")
    public suspend fun dnsAddresses(vararg values: Output<String>) {
        this.dnsAddresses = Output.all(values.asList())
    }

    /**
     * @param values The DNS address list.
     */
    @JvmName("unyqvknkvsyjpbpp")
    public suspend fun dnsAddresses(values: List<Output<String>>) {
        this.dnsAddresses = Output.all(values)
    }

    /**
     * @param value The name of the domain.
     */
    @JvmName("femewhilnmlofajw")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The user password of the domain administrator. The maximum number of English characters is 64.
     */
    @JvmName("yssohqwjwoduysdw")
    public suspend fun domainPassword(`value`: Output<String>) {
        this.domainPassword = value
    }

    /**
     * @param value The username of the domain administrator. The maximum number of English characters is 64.
     */
    @JvmName("qwjiqxusbvesgtyu")
    public suspend fun domainUserName(`value`: Output<String>) {
        this.domainUserName = value
    }

    /**
     * @param value Whether to grant local administrator rights to users who use cloud desktops.
     */
    @JvmName("ixmfulxbryigdjsw")
    public suspend fun enableAdminAccess(`value`: Output<Boolean>) {
        this.enableAdminAccess = value
    }

    /**
     * @param value Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
     */
    @JvmName("jvpvcrqimhetgncp")
    public suspend fun mfaEnabled(`value`: Output<Boolean>) {
        this.mfaEnabled = value
    }

    /**
     * @param value The AD Connector specifications. Valid values: `1`, `2`.
     */
    @JvmName("uunlpijbnhjbsssg")
    public suspend fun specification(`value`: Output<Int>) {
        this.specification = value
    }

    /**
     * @param value The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
     */
    @JvmName("iavdifqrgtqkokgw")
    public suspend fun subDomainDnsAddresses(`value`: Output<List<String>>) {
        this.subDomainDnsAddresses = value
    }

    @JvmName("nipupmrolwkxfwhg")
    public suspend fun subDomainDnsAddresses(vararg values: Output<String>) {
        this.subDomainDnsAddresses = Output.all(values.asList())
    }

    /**
     * @param values The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
     */
    @JvmName("oscoijyorkgxyllw")
    public suspend fun subDomainDnsAddresses(values: List<Output<String>>) {
        this.subDomainDnsAddresses = Output.all(values)
    }

    /**
     * @param value The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
     */
    @JvmName("dvidaiciddmalfss")
    public suspend fun subDomainName(`value`: Output<String>) {
        this.subDomainName = value
    }

    /**
     * @param value List of VSwitch IDs in the directory.
     */
    @JvmName("bluovajtxupldwme")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("rqpuiqenfxebrurt")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values List of VSwitch IDs in the directory.
     */
    @JvmName("fvwfkdyerjfhdjwj")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
     */
    @JvmName("vwehxkbrnhniidlr")
    public suspend fun desktopAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopAccessType = mapped
    }

    /**
     * @param value The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("fagywnlfnhsaqfgf")
    public suspend fun directoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryName = mapped
    }

    /**
     * @param value The DNS address list.
     */
    @JvmName("bdtldgfgjljvmpaq")
    public suspend fun dnsAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param values The DNS address list.
     */
    @JvmName("yrrmpubdpyifskpd")
    public suspend fun dnsAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param value The name of the domain.
     */
    @JvmName("rchigtysnhkvfrhh")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The user password of the domain administrator. The maximum number of English characters is 64.
     */
    @JvmName("oqynvrhinvyimovt")
    public suspend fun domainPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainPassword = mapped
    }

    /**
     * @param value The username of the domain administrator. The maximum number of English characters is 64.
     */
    @JvmName("yodlinusjoaqvhut")
    public suspend fun domainUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUserName = mapped
    }

    /**
     * @param value Whether to grant local administrator rights to users who use cloud desktops.
     */
    @JvmName("etisswaffqodmctx")
    public suspend fun enableAdminAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdminAccess = mapped
    }

    /**
     * @param value Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
     */
    @JvmName("dtdljdnljeqqpbii")
    public suspend fun mfaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaEnabled = mapped
    }

    /**
     * @param value The AD Connector specifications. Valid values: `1`, `2`.
     */
    @JvmName("fmluawjskblifjyn")
    public suspend fun specification(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
     */
    @JvmName("pcywuebihbbekqro")
    public suspend fun subDomainDnsAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomainDnsAddresses = mapped
    }

    /**
     * @param values The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
     */
    @JvmName("sifrnwodwfmpatbp")
    public suspend fun subDomainDnsAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subDomainDnsAddresses = mapped
    }

    /**
     * @param value The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
     */
    @JvmName("gvyjpqymarwpwbcn")
    public suspend fun subDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomainName = mapped
    }

    /**
     * @param value List of VSwitch IDs in the directory.
     */
    @JvmName("iagugxlgwptqdlkl")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values List of VSwitch IDs in the directory.
     */
    @JvmName("eisbmkcvebhrafgm")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): AdConnectorDirectoryArgs = AdConnectorDirectoryArgs(
        desktopAccessType = desktopAccessType,
        directoryName = directoryName,
        dnsAddresses = dnsAddresses,
        domainName = domainName,
        domainPassword = domainPassword,
        domainUserName = domainUserName,
        enableAdminAccess = enableAdminAccess,
        mfaEnabled = mfaEnabled,
        specification = specification,
        subDomainDnsAddresses = subDomainDnsAddresses,
        subDomainName = subDomainName,
        vswitchIds = vswitchIds,
    )
}
