@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.AdConnectorOfficeSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECD Ad Connector Office Site resource.
 * For information about ECD Ad Connector Office Site and how to use it, see [What is Ad Connector Office Site](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectorofficesite).
 * > **NOTE:** Available since v1.176.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cen.Instance("default", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const defaultAdConnectorOfficeSite = new alicloud.eds.AdConnectorOfficeSite("default", {
 *     adConnectorOfficeSiteName: name,
 *     bandwidth: 100,
 *     cenId: _default.id,
 *     cidrBlock: "10.0.0.0/12",
 *     desktopAccessType: "INTERNET",
 *     dnsAddresses: ["127&#46;0&#46;0&#46;2"],
 *     domainName: "corp.example.com",
 *     domainPassword: "Example1234",
 *     domainUserName: "sAMAccountName",
 *     enableAdminAccess: false,
 *     enableInternetAccess: false,
 *     mfaEnabled: false,
 *     subDomainDnsAddresses: ["127&#46;0&#46;0&#46;3"],
 *     subDomainName: "child.example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cen.Instance("default",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * default_ad_connector_office_site = alicloud.eds.AdConnectorOfficeSite("default",
 *     ad_connector_office_site_name=name,
 *     bandwidth=100,
 *     cen_id=default.id,
 *     cidr_block="10.0.0.0/12",
 *     desktop_access_type="INTERNET",
 *     dns_addresses=["127&#46;0&#46;0&#46;2"],
 *     domain_name="corp.example.com",
 *     domain_password="Example1234",
 *     domain_user_name="sAMAccountName",
 *     enable_admin_access=False,
 *     enable_internet_access=False,
 *     mfa_enabled=False,
 *     sub_domain_dns_addresses=["127&#46;0&#46;0&#46;3"],
 *     sub_domain_name="child.example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var defaultAdConnectorOfficeSite = new AliCloud.Eds.AdConnectorOfficeSite("default", new()
 *     {
 *         AdConnectorOfficeSiteName = name,
 *         Bandwidth = 100,
 *         CenId = @default.Id,
 *         CidrBlock = "10.0.0.0/12",
 *         DesktopAccessType = "INTERNET",
 *         DnsAddresses = new[]
 *         {
 *             "127.0.0.2",
 *         },
 *         DomainName = "corp.example.com",
 *         DomainPassword = "Example1234",
 *         DomainUserName = "sAMAccountName",
 *         EnableAdminAccess = false,
 *         EnableInternetAccess = false,
 *         MfaEnabled = false,
 *         SubDomainDnsAddresses = new[]
 *         {
 *             "127.0.0.3",
 *         },
 *         SubDomainName = "child.example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewAdConnectorOfficeSite(ctx, "default", &eds.AdConnectorOfficeSiteArgs{
 * 			AdConnectorOfficeSiteName: pulumi.String(name),
 * 			Bandwidth:                 pulumi.Int(100),
 * 			CenId:                     _default.ID(),
 * 			CidrBlock:                 pulumi.String("10.0.0.0/12"),
 * 			DesktopAccessType:         pulumi.String("INTERNET"),
 * 			DnsAddresses: pulumi.StringArray{
 * 				pulumi.String("127.0.0.2"),
 * 			},
 * 			DomainName:           pulumi.String("corp.example.com"),
 * 			DomainPassword:       pulumi.String("Example1234"),
 * 			DomainUserName:       pulumi.String("sAMAccountName"),
 * 			EnableAdminAccess:    pulumi.Bool(false),
 * 			EnableInternetAccess: pulumi.Bool(false),
 * 			MfaEnabled:           pulumi.Bool(false),
 * 			SubDomainDnsAddresses: pulumi.StringArray{
 * 				pulumi.String("127.0.0.3"),
 * 			},
 * 			SubDomainName: pulumi.String("child.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.eds.AdConnectorOfficeSite;
 * import com.pulumi.alicloud.eds.AdConnectorOfficeSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var defaultAdConnectorOfficeSite = new AdConnectorOfficeSite("defaultAdConnectorOfficeSite", AdConnectorOfficeSiteArgs.builder()
 *             .adConnectorOfficeSiteName(name)
 *             .bandwidth(100)
 *             .cenId(default_.id())
 *             .cidrBlock("10.0.0.0/12")
 *             .desktopAccessType("INTERNET")
 *             .dnsAddresses("127.0.0.2")
 *             .domainName("corp.example.com")
 *             .domainPassword("Example1234")
 *             .domainUserName("sAMAccountName")
 *             .enableAdminAccess(false)
 *             .enableInternetAccess(false)
 *             .mfaEnabled(false)
 *             .subDomainDnsAddresses("127.0.0.3")
 *             .subDomainName("child.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   defaultAdConnectorOfficeSite:
 *     type: alicloud:eds:AdConnectorOfficeSite
 *     name: default
 *     properties:
 *       adConnectorOfficeSiteName: ${name}
 *       bandwidth: 100
 *       cenId: ${default.id}
 *       cidrBlock: 10.0.0.0/12
 *       desktopAccessType: INTERNET
 *       dnsAddresses:
 *         - 127.0.0.2
 *       domainName: corp.example.com
 *       domainPassword: Example1234
 *       domainUserName: sAMAccountName
 *       enableAdminAccess: false
 *       enableInternetAccess: false
 *       mfaEnabled: false
 *       subDomainDnsAddresses:
 *         - 127.0.0.3
 *       subDomainName: child.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Ad Connector Office Site can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/adConnectorOfficeSite:AdConnectorOfficeSite example <id>
 * ```
 * @property adConnectorOfficeSiteName The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
 * @property adHostname The ad hostname.
 * @property bandwidth The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
 * @property cenId The ID of the CEN instance.
 * @property cenOwnerId The cen owner id.
 * @property cidrBlock Workspace Corresponds to the Security Office Network of IPv4 Segment.
 * @property desktopAccessType The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
 * - `INTERNET`: connects clients to cloud desktops only over the Internet.
 * - `VPC`: connects clients to cloud desktops only over a VPC.
 * - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
 * @property dnsAddresses The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
 * @property domainName The domain name of the enterprise AD system. You can register each domain name only once.
 * @property domainPassword The password of the domain administrator. The password can be up to 64 characters in length.
 * @property domainUserName The username of the domain administrator. The username can be up to 64 characters in length.
 * @property enableAdminAccess Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
 * @property enableInternetAccess Specifies whether to enable Internet access.
 * @property mfaEnabled Specifies whether to enable multi-factor authentication (MFA).
 * @property protocolType The protocol type. Valid values: `ASP`, `HDX`.
 * @property specification The AD Connector specifications. Valid values: `1`, `2`.
 * @property subDomainDnsAddresses The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
 * @property subDomainName The domain name of the enterprise AD subdomain.
 * @property verifyCode The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
 */
public data class AdConnectorOfficeSiteArgs(
    public val adConnectorOfficeSiteName: Output<String>? = null,
    public val adHostname: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val cenId: Output<String>? = null,
    public val cenOwnerId: Output<String>? = null,
    public val cidrBlock: Output<String>? = null,
    public val desktopAccessType: Output<String>? = null,
    public val dnsAddresses: Output<List<String>>? = null,
    public val domainName: Output<String>? = null,
    public val domainPassword: Output<String>? = null,
    public val domainUserName: Output<String>? = null,
    public val enableAdminAccess: Output<Boolean>? = null,
    public val enableInternetAccess: Output<Boolean>? = null,
    public val mfaEnabled: Output<Boolean>? = null,
    public val protocolType: Output<String>? = null,
    public val specification: Output<Int>? = null,
    public val subDomainDnsAddresses: Output<List<String>>? = null,
    public val subDomainName: Output<String>? = null,
    public val verifyCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.AdConnectorOfficeSiteArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.AdConnectorOfficeSiteArgs =
        com.pulumi.alicloud.eds.AdConnectorOfficeSiteArgs.builder()
            .adConnectorOfficeSiteName(adConnectorOfficeSiteName?.applyValue({ args0 -> args0 }))
            .adHostname(adHostname?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .cenOwnerId(cenOwnerId?.applyValue({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .desktopAccessType(desktopAccessType?.applyValue({ args0 -> args0 }))
            .dnsAddresses(dnsAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainPassword(domainPassword?.applyValue({ args0 -> args0 }))
            .domainUserName(domainUserName?.applyValue({ args0 -> args0 }))
            .enableAdminAccess(enableAdminAccess?.applyValue({ args0 -> args0 }))
            .enableInternetAccess(enableInternetAccess?.applyValue({ args0 -> args0 }))
            .mfaEnabled(mfaEnabled?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .subDomainDnsAddresses(subDomainDnsAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subDomainName(subDomainName?.applyValue({ args0 -> args0 }))
            .verifyCode(verifyCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdConnectorOfficeSiteArgs].
 */
@PulumiTagMarker
public class AdConnectorOfficeSiteArgsBuilder internal constructor() {
    private var adConnectorOfficeSiteName: Output<String>? = null

    private var adHostname: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var cenId: Output<String>? = null

    private var cenOwnerId: Output<String>? = null

    private var cidrBlock: Output<String>? = null

    private var desktopAccessType: Output<String>? = null

    private var dnsAddresses: Output<List<String>>? = null

    private var domainName: Output<String>? = null

    private var domainPassword: Output<String>? = null

    private var domainUserName: Output<String>? = null

    private var enableAdminAccess: Output<Boolean>? = null

    private var enableInternetAccess: Output<Boolean>? = null

    private var mfaEnabled: Output<Boolean>? = null

    private var protocolType: Output<String>? = null

    private var specification: Output<Int>? = null

    private var subDomainDnsAddresses: Output<List<String>>? = null

    private var subDomainName: Output<String>? = null

    private var verifyCode: Output<String>? = null

    /**
     * @param value The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("qoufdtpenkeutits")
    public suspend fun adConnectorOfficeSiteName(`value`: Output<String>) {
        this.adConnectorOfficeSiteName = value
    }

    /**
     * @param value The ad hostname.
     */
    @JvmName("hijjwociafytqgsp")
    public suspend fun adHostname(`value`: Output<String>) {
        this.adHostname = value
    }

    /**
     * @param value The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
     */
    @JvmName("skhkuqmvhhcwfisf")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("vequxulsglmjpraj")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The cen owner id.
     */
    @JvmName("haktjpemmwheguqb")
    public suspend fun cenOwnerId(`value`: Output<String>) {
        this.cenOwnerId = value
    }

    /**
     * @param value Workspace Corresponds to the Security Office Network of IPv4 Segment.
     */
    @JvmName("huqsmqembdigwghl")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
     * - `INTERNET`: connects clients to cloud desktops only over the Internet.
     * - `VPC`: connects clients to cloud desktops only over a VPC.
     * - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
     */
    @JvmName("eblqydxcircirjyv")
    public suspend fun desktopAccessType(`value`: Output<String>) {
        this.desktopAccessType = value
    }

    /**
     * @param value The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
     */
    @JvmName("bcvmujjbkjpyxchp")
    public suspend fun dnsAddresses(`value`: Output<List<String>>) {
        this.dnsAddresses = value
    }

    @JvmName("rowcnjkrrjowryxv")
    public suspend fun dnsAddresses(vararg values: Output<String>) {
        this.dnsAddresses = Output.all(values.asList())
    }

    /**
     * @param values The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
     */
    @JvmName("uiehlwosgggrahin")
    public suspend fun dnsAddresses(values: List<Output<String>>) {
        this.dnsAddresses = Output.all(values)
    }

    /**
     * @param value The domain name of the enterprise AD system. You can register each domain name only once.
     */
    @JvmName("rrbgfrlafdihuhqt")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The password of the domain administrator. The password can be up to 64 characters in length.
     */
    @JvmName("nssbmrwemcmxsssx")
    public suspend fun domainPassword(`value`: Output<String>) {
        this.domainPassword = value
    }

    /**
     * @param value The username of the domain administrator. The username can be up to 64 characters in length.
     */
    @JvmName("wxylupuphocgnaby")
    public suspend fun domainUserName(`value`: Output<String>) {
        this.domainUserName = value
    }

    /**
     * @param value Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
     */
    @JvmName("cvilgkdnldyirxww")
    public suspend fun enableAdminAccess(`value`: Output<Boolean>) {
        this.enableAdminAccess = value
    }

    /**
     * @param value Specifies whether to enable Internet access.
     */
    @JvmName("kdrmfytuesuwyavq")
    public suspend fun enableInternetAccess(`value`: Output<Boolean>) {
        this.enableInternetAccess = value
    }

    /**
     * @param value Specifies whether to enable multi-factor authentication (MFA).
     */
    @JvmName("ryjfjlfchgcmckpk")
    public suspend fun mfaEnabled(`value`: Output<Boolean>) {
        this.mfaEnabled = value
    }

    /**
     * @param value The protocol type. Valid values: `ASP`, `HDX`.
     */
    @JvmName("eqplbhnegimiyive")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value The AD Connector specifications. Valid values: `1`, `2`.
     */
    @JvmName("lwmidlyosiuwebkd")
    public suspend fun specification(`value`: Output<Int>) {
        this.specification = value
    }

    /**
     * @param value The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
     */
    @JvmName("tvpqmwnwmqurayno")
    public suspend fun subDomainDnsAddresses(`value`: Output<List<String>>) {
        this.subDomainDnsAddresses = value
    }

    @JvmName("gaupulipnspfqqha")
    public suspend fun subDomainDnsAddresses(vararg values: Output<String>) {
        this.subDomainDnsAddresses = Output.all(values.asList())
    }

    /**
     * @param values The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
     */
    @JvmName("nvqfuhfsnoxesuvy")
    public suspend fun subDomainDnsAddresses(values: List<Output<String>>) {
        this.subDomainDnsAddresses = Output.all(values)
    }

    /**
     * @param value The domain name of the enterprise AD subdomain.
     */
    @JvmName("bkewgbommjmvhtxk")
    public suspend fun subDomainName(`value`: Output<String>) {
        this.subDomainName = value
    }

    /**
     * @param value The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
     */
    @JvmName("psrgtkfebddtyyhm")
    public suspend fun verifyCode(`value`: Output<String>) {
        this.verifyCode = value
    }

    /**
     * @param value The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("ydrxiqiqlsueaxjj")
    public suspend fun adConnectorOfficeSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adConnectorOfficeSiteName = mapped
    }

    /**
     * @param value The ad hostname.
     */
    @JvmName("khmrkuvatgurgpol")
    public suspend fun adHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adHostname = mapped
    }

    /**
     * @param value The maximum public bandwidth value. Valid values: 0 to 200. If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
     */
    @JvmName("ropbnxvdkhbwnxuo")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("oehqouudewfttcpr")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The cen owner id.
     */
    @JvmName("cpscpttbcnkwjgbk")
    public suspend fun cenOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenOwnerId = mapped
    }

    /**
     * @param value Workspace Corresponds to the Security Office Network of IPv4 Segment.
     */
    @JvmName("bygeoovvorwgtwaj")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The method that you use to connect to cloud desktops. **Note:** The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. When you set this parameter to VPC or Any, PrivateLink is automatically activated. Default value: `INTERNET`. Valid values:
     * - `INTERNET`: connects clients to cloud desktops only over the Internet.
     * - `VPC`: connects clients to cloud desktops only over a VPC.
     * - `ANY`: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you use a client to connect to the cloud desktop.
     */
    @JvmName("thoihghfdbtsqpke")
    public suspend fun desktopAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopAccessType = mapped
    }

    /**
     * @param value The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
     */
    @JvmName("lvivrkdkdslawwha")
    public suspend fun dnsAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param values The IP address N of the DNS server of the enterprise AD system. You can specify only one IP address.
     */
    @JvmName("acuugtxpewwtfprm")
    public suspend fun dnsAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsAddresses = mapped
    }

    /**
     * @param value The domain name of the enterprise AD system. You can register each domain name only once.
     */
    @JvmName("dcbeubdrtfalidlx")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The password of the domain administrator. The password can be up to 64 characters in length.
     */
    @JvmName("yhdouuvoeuhcpixu")
    public suspend fun domainPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainPassword = mapped
    }

    /**
     * @param value The username of the domain administrator. The username can be up to 64 characters in length.
     */
    @JvmName("tlyhyjriqwjardkd")
    public suspend fun domainUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUserName = mapped
    }

    /**
     * @param value Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
     */
    @JvmName("fsvalfytteswuflb")
    public suspend fun enableAdminAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdminAccess = mapped
    }

    /**
     * @param value Specifies whether to enable Internet access.
     */
    @JvmName("myivnfxiwcrqqwyy")
    public suspend fun enableInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetAccess = mapped
    }

    /**
     * @param value Specifies whether to enable multi-factor authentication (MFA).
     */
    @JvmName("cmabqqpiobgaujme")
    public suspend fun mfaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaEnabled = mapped
    }

    /**
     * @param value The protocol type. Valid values: `ASP`, `HDX`.
     */
    @JvmName("laaanctevdpjbycs")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value The AD Connector specifications. Valid values: `1`, `2`.
     */
    @JvmName("errvacqswpostbmx")
    public suspend fun specification(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
     */
    @JvmName("gblhwsuaehrplrcd")
    public suspend fun subDomainDnsAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomainDnsAddresses = mapped
    }

    /**
     * @param values The DNS address N of the enterprise AD subdomain. If you specify a value for the `sub_domain_name` parameter but you do not specify a value for this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
     */
    @JvmName("dddvobadtuiioqen")
    public suspend fun subDomainDnsAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subDomainDnsAddresses = mapped
    }

    /**
     * @param value The domain name of the enterprise AD subdomain.
     */
    @JvmName("hwuqglqluiaxnkpo")
    public suspend fun subDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomainName = mapped
    }

    /**
     * @param value The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
     */
    @JvmName("xnwpmtasbioaphdy")
    public suspend fun verifyCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyCode = mapped
    }

    internal fun build(): AdConnectorOfficeSiteArgs = AdConnectorOfficeSiteArgs(
        adConnectorOfficeSiteName = adConnectorOfficeSiteName,
        adHostname = adHostname,
        bandwidth = bandwidth,
        cenId = cenId,
        cenOwnerId = cenOwnerId,
        cidrBlock = cidrBlock,
        desktopAccessType = desktopAccessType,
        dnsAddresses = dnsAddresses,
        domainName = domainName,
        domainPassword = domainPassword,
        domainUserName = domainUserName,
        enableAdminAccess = enableAdminAccess,
        enableInternetAccess = enableInternetAccess,
        mfaEnabled = mfaEnabled,
        protocolType = protocolType,
        specification = specification,
        subDomainDnsAddresses = subDomainDnsAddresses,
        subDomainName = subDomainName,
        verifyCode = verifyCode,
    )
}
