@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Bundle].
 */
@PulumiTagMarker
public class BundleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BundleArgs = BundleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BundleArgsBuilder.() -> Unit) {
        val builder = BundleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Bundle {
        val builtJavaResource = com.pulumi.alicloud.eds.Bundle(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bundle(builtJavaResource)
    }
}

/**
 * Provides a ECD Bundle resource.
 * For information about ECD Bundle and how to use it, see [What is Bundle](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createbundle).
 * > **NOTE:** Available since v1.170.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.eds.getImages({
 *     imageType: "SYSTEM",
 *     osType: "Windows",
 *     desktopInstanceType: "eds.hf.4c8g",
 * });
 * const defaultGetDesktopTypes = alicloud.eds.getDesktopTypes({
 *     instanceTypeFamily: "eds.hf",
 *     cpuCount: 4,
 *     memorySize: 8192,
 * });
 * const defaultBundle = new alicloud.eds.Bundle("default", {
 *     description: name,
 *     desktopType: defaultGetDesktopTypes.then(defaultGetDesktopTypes => defaultGetDesktopTypes.ids?.[0]),
 *     bundleName: name,
 *     imageId: _default.then(_default => _default.ids?.[0]),
 *     userDiskSizeGibs: [70],
 *     rootDiskSizeGib: 80,
 *     rootDiskPerformanceLevel: "PL1",
 *     userDiskPerformanceLevel: "PL1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eds.get_images(image_type="SYSTEM",
 *     os_type="Windows",
 *     desktop_instance_type="eds.hf.4c8g")
 * default_get_desktop_types = alicloud.eds.get_desktop_types(instance_type_family="eds.hf",
 *     cpu_count=4,
 *     memory_size=8192)
 * default_bundle = alicloud.eds.Bundle("default",
 *     description=name,
 *     desktop_type=default_get_desktop_types.ids[0],
 *     bundle_name=name,
 *     image_id=default.ids[0],
 *     user_disk_size_gibs=[70],
 *     root_disk_size_gib=80,
 *     root_disk_performance_level="PL1",
 *     user_disk_performance_level="PL1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Eds.GetImages.Invoke(new()
 *     {
 *         ImageType = "SYSTEM",
 *         OsType = "Windows",
 *         DesktopInstanceType = "eds.hf.4c8g",
 *     });
 *     var defaultGetDesktopTypes = AliCloud.Eds.GetDesktopTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "eds.hf",
 *         CpuCount = 4,
 *         MemorySize = 8192,
 *     });
 *     var defaultBundle = new AliCloud.Eds.Bundle("default", new()
 *     {
 *         Description = name,
 *         DesktopType = defaultGetDesktopTypes.Apply(getDesktopTypesResult => getDesktopTypesResult.Ids[0]),
 *         BundleName = name,
 *         ImageId = @default.Apply(@default => @default.Apply(getImagesResult => getImagesResult.Ids[0])),
 *         UserDiskSizeGibs = new[]
 *         {
 *             70,
 *         },
 *         RootDiskSizeGib = 80,
 *         RootDiskPerformanceLevel = "PL1",
 *         UserDiskPerformanceLevel = "PL1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eds.GetImages(ctx, &eds.GetImagesArgs{
 * 			ImageType:           pulumi.StringRef("SYSTEM"),
 * 			OsType:              pulumi.StringRef("Windows"),
 * 			DesktopInstanceType: pulumi.StringRef("eds.hf.4c8g"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetDesktopTypes, err := eds.GetDesktopTypes(ctx, &eds.GetDesktopTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("eds.hf"),
 * 			CpuCount:           pulumi.IntRef(4),
 * 			MemorySize:         pulumi.IntRef(8192),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewBundle(ctx, "default", &eds.BundleArgs{
 * 			Description: pulumi.String(name),
 * 			DesktopType: pulumi.String(defaultGetDesktopTypes.Ids[0]),
 * 			BundleName:  pulumi.String(name),
 * 			ImageId:     pulumi.String(_default.Ids[0]),
 * 			UserDiskSizeGibs: pulumi.IntArray{
 * 				pulumi.Int(70),
 * 			},
 * 			RootDiskSizeGib:          pulumi.Int(80),
 * 			RootDiskPerformanceLevel: pulumi.String("PL1"),
 * 			UserDiskPerformanceLevel: pulumi.String("PL1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.eds.inputs.GetDesktopTypesArgs;
 * import com.pulumi.alicloud.eds.Bundle;
 * import com.pulumi.alicloud.eds.BundleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = EdsFunctions.getImages(GetImagesArgs.builder()
 *             .imageType("SYSTEM")
 *             .osType("Windows")
 *             .desktopInstanceType("eds.hf.4c8g")
 *             .build());
 *         final var defaultGetDesktopTypes = EdsFunctions.getDesktopTypes(GetDesktopTypesArgs.builder()
 *             .instanceTypeFamily("eds.hf")
 *             .cpuCount(4)
 *             .memorySize(8192)
 *             .build());
 *         var defaultBundle = new Bundle("defaultBundle", BundleArgs.builder()
 *             .description(name)
 *             .desktopType(defaultGetDesktopTypes.applyValue(getDesktopTypesResult -> getDesktopTypesResult.ids()[0]))
 *             .bundleName(name)
 *             .imageId(default_.ids()[0])
 *             .userDiskSizeGibs(70)
 *             .rootDiskSizeGib(80)
 *             .rootDiskPerformanceLevel("PL1")
 *             .userDiskPerformanceLevel("PL1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultBundle:
 *     type: alicloud:eds:Bundle
 *     name: default
 *     properties:
 *       description: ${name}
 *       desktopType: ${defaultGetDesktopTypes.ids[0]}
 *       bundleName: ${name}
 *       imageId: ${default.ids[0]}
 *       userDiskSizeGibs:
 *         - 70
 *       rootDiskSizeGib: 80
 *       rootDiskPerformanceLevel: PL1
 *       userDiskPerformanceLevel: PL1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getImages
 *       Arguments:
 *         imageType: SYSTEM
 *         osType: Windows
 *         desktopInstanceType: eds.hf.4c8g
 *   defaultGetDesktopTypes:
 *     fn::invoke:
 *       Function: alicloud:eds:getDesktopTypes
 *       Arguments:
 *         instanceTypeFamily: eds.hf
 *         cpuCount: 4
 *         memorySize: 8192
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Bundle can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/bundle:Bundle example <id>
 * ```
 */
public class Bundle internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.Bundle,
) : KotlinCustomResource(javaResource, BundleMapper) {
    /**
     * The name of the bundle.
     */
    public val bundleName: Output<String>?
        get() = javaResource.bundleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the bundle.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The desktop type. You can call `alicloud.eds.getDesktopTypes` to query desktop type.
     */
    public val desktopType: Output<String>
        get() = javaResource.desktopType().applyValue({ args0 -> args0 })

    /**
     * The ID of the image.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The language. Valid values: `zh-CN`, `zh-HK`, `en-US`, `ja-JP`.
     */
    public val language: Output<String>?
        get() = javaResource.language().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The root disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    public val rootDiskPerformanceLevel: Output<String>
        get() = javaResource.rootDiskPerformanceLevel().applyValue({ args0 -> args0 })

    /**
     * The root disk size gib.
     */
    public val rootDiskSizeGib: Output<Int>
        get() = javaResource.rootDiskSizeGib().applyValue({ args0 -> args0 })

    /**
     * The user disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    public val userDiskPerformanceLevel: Output<String>
        get() = javaResource.userDiskPerformanceLevel().applyValue({ args0 -> args0 })

    /**
     * The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
     * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
     * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
     */
    public val userDiskSizeGibs: Output<List<Int>>
        get() = javaResource.userDiskSizeGibs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object BundleMapper : ResourceMapper<Bundle> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.Bundle::class == javaResource::class

    override fun map(javaResource: Resource): Bundle = Bundle(
        javaResource as
            com.pulumi.alicloud.eds.Bundle,
    )
}

/**
 * @see [Bundle].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bundle].
 */
public suspend fun bundle(name: String, block: suspend BundleResourceBuilder.() -> Unit): Bundle {
    val builder = BundleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bundle].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bundle(name: String): Bundle {
    val builder = BundleResourceBuilder()
    builder.name(name)
    return builder.build()
}
