@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.BundleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECD Bundle resource.
 * For information about ECD Bundle and how to use it, see [What is Bundle](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createbundle).
 * > **NOTE:** Available since v1.170.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.eds.getImages({
 *     imageType: "SYSTEM",
 *     osType: "Windows",
 *     desktopInstanceType: "eds.hf.4c8g",
 * });
 * const defaultGetDesktopTypes = alicloud.eds.getDesktopTypes({
 *     instanceTypeFamily: "eds.hf",
 *     cpuCount: 4,
 *     memorySize: 8192,
 * });
 * const defaultBundle = new alicloud.eds.Bundle("default", {
 *     description: name,
 *     desktopType: defaultGetDesktopTypes.then(defaultGetDesktopTypes => defaultGetDesktopTypes.ids?.[0]),
 *     bundleName: name,
 *     imageId: _default.then(_default => _default.ids?.[0]),
 *     userDiskSizeGibs: [70],
 *     rootDiskSizeGib: 80,
 *     rootDiskPerformanceLevel: "PL1",
 *     userDiskPerformanceLevel: "PL1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eds.get_images(image_type="SYSTEM",
 *     os_type="Windows",
 *     desktop_instance_type="eds.hf.4c8g")
 * default_get_desktop_types = alicloud.eds.get_desktop_types(instance_type_family="eds.hf",
 *     cpu_count=4,
 *     memory_size=8192)
 * default_bundle = alicloud.eds.Bundle("default",
 *     description=name,
 *     desktop_type=default_get_desktop_types.ids[0],
 *     bundle_name=name,
 *     image_id=default.ids[0],
 *     user_disk_size_gibs=[70],
 *     root_disk_size_gib=80,
 *     root_disk_performance_level="PL1",
 *     user_disk_performance_level="PL1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Eds.GetImages.Invoke(new()
 *     {
 *         ImageType = "SYSTEM",
 *         OsType = "Windows",
 *         DesktopInstanceType = "eds.hf.4c8g",
 *     });
 *     var defaultGetDesktopTypes = AliCloud.Eds.GetDesktopTypes.Invoke(new()
 *     {
 *         InstanceTypeFamily = "eds.hf",
 *         CpuCount = 4,
 *         MemorySize = 8192,
 *     });
 *     var defaultBundle = new AliCloud.Eds.Bundle("default", new()
 *     {
 *         Description = name,
 *         DesktopType = defaultGetDesktopTypes.Apply(getDesktopTypesResult => getDesktopTypesResult.Ids[0]),
 *         BundleName = name,
 *         ImageId = @default.Apply(@default => @default.Apply(getImagesResult => getImagesResult.Ids[0])),
 *         UserDiskSizeGibs = new[]
 *         {
 *             70,
 *         },
 *         RootDiskSizeGib = 80,
 *         RootDiskPerformanceLevel = "PL1",
 *         UserDiskPerformanceLevel = "PL1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eds.GetImages(ctx, &eds.GetImagesArgs{
 * 			ImageType:           pulumi.StringRef("SYSTEM"),
 * 			OsType:              pulumi.StringRef("Windows"),
 * 			DesktopInstanceType: pulumi.StringRef("eds.hf.4c8g"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetDesktopTypes, err := eds.GetDesktopTypes(ctx, &eds.GetDesktopTypesArgs{
 * 			InstanceTypeFamily: pulumi.StringRef("eds.hf"),
 * 			CpuCount:           pulumi.IntRef(4),
 * 			MemorySize:         pulumi.IntRef(8192),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewBundle(ctx, "default", &eds.BundleArgs{
 * 			Description: pulumi.String(name),
 * 			DesktopType: pulumi.String(defaultGetDesktopTypes.Ids[0]),
 * 			BundleName:  pulumi.String(name),
 * 			ImageId:     pulumi.String(_default.Ids[0]),
 * 			UserDiskSizeGibs: pulumi.IntArray{
 * 				pulumi.Int(70),
 * 			},
 * 			RootDiskSizeGib:          pulumi.Int(80),
 * 			RootDiskPerformanceLevel: pulumi.String("PL1"),
 * 			UserDiskPerformanceLevel: pulumi.String("PL1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.eds.inputs.GetDesktopTypesArgs;
 * import com.pulumi.alicloud.eds.Bundle;
 * import com.pulumi.alicloud.eds.BundleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = EdsFunctions.getImages(GetImagesArgs.builder()
 *             .imageType("SYSTEM")
 *             .osType("Windows")
 *             .desktopInstanceType("eds.hf.4c8g")
 *             .build());
 *         final var defaultGetDesktopTypes = EdsFunctions.getDesktopTypes(GetDesktopTypesArgs.builder()
 *             .instanceTypeFamily("eds.hf")
 *             .cpuCount(4)
 *             .memorySize(8192)
 *             .build());
 *         var defaultBundle = new Bundle("defaultBundle", BundleArgs.builder()
 *             .description(name)
 *             .desktopType(defaultGetDesktopTypes.applyValue(getDesktopTypesResult -> getDesktopTypesResult.ids()[0]))
 *             .bundleName(name)
 *             .imageId(default_.ids()[0])
 *             .userDiskSizeGibs(70)
 *             .rootDiskSizeGib(80)
 *             .rootDiskPerformanceLevel("PL1")
 *             .userDiskPerformanceLevel("PL1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultBundle:
 *     type: alicloud:eds:Bundle
 *     name: default
 *     properties:
 *       description: ${name}
 *       desktopType: ${defaultGetDesktopTypes.ids[0]}
 *       bundleName: ${name}
 *       imageId: ${default.ids[0]}
 *       userDiskSizeGibs:
 *         - 70
 *       rootDiskSizeGib: 80
 *       rootDiskPerformanceLevel: PL1
 *       userDiskPerformanceLevel: PL1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getImages
 *       Arguments:
 *         imageType: SYSTEM
 *         osType: Windows
 *         desktopInstanceType: eds.hf.4c8g
 *   defaultGetDesktopTypes:
 *     fn::invoke:
 *       Function: alicloud:eds:getDesktopTypes
 *       Arguments:
 *         instanceTypeFamily: eds.hf
 *         cpuCount: 4
 *         memorySize: 8192
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Bundle can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/bundle:Bundle example <id>
 * ```
 * @property bundleName The name of the bundle.
 * @property description The description of the bundle.
 * @property desktopType The desktop type. You can call `alicloud.eds.getDesktopTypes` to query desktop type.
 * @property imageId The ID of the image.
 * @property language The language. Valid values: `zh-CN`, `zh-HK`, `en-US`, `ja-JP`.
 * @property rootDiskPerformanceLevel The root disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property rootDiskSizeGib The root disk size gib.
 * @property userDiskPerformanceLevel The user disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property userDiskSizeGibs The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
 * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
 * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
 */
public data class BundleArgs(
    public val bundleName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val desktopType: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val language: Output<String>? = null,
    public val rootDiskPerformanceLevel: Output<String>? = null,
    public val rootDiskSizeGib: Output<Int>? = null,
    public val userDiskPerformanceLevel: Output<String>? = null,
    public val userDiskSizeGibs: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.BundleArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.BundleArgs =
        com.pulumi.alicloud.eds.BundleArgs.builder()
            .bundleName(bundleName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .desktopType(desktopType?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .language(language?.applyValue({ args0 -> args0 }))
            .rootDiskPerformanceLevel(rootDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .rootDiskSizeGib(rootDiskSizeGib?.applyValue({ args0 -> args0 }))
            .userDiskPerformanceLevel(userDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .userDiskSizeGibs(userDiskSizeGibs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BundleArgs].
 */
@PulumiTagMarker
public class BundleArgsBuilder internal constructor() {
    private var bundleName: Output<String>? = null

    private var description: Output<String>? = null

    private var desktopType: Output<String>? = null

    private var imageId: Output<String>? = null

    private var language: Output<String>? = null

    private var rootDiskPerformanceLevel: Output<String>? = null

    private var rootDiskSizeGib: Output<Int>? = null

    private var userDiskPerformanceLevel: Output<String>? = null

    private var userDiskSizeGibs: Output<List<Int>>? = null

    /**
     * @param value The name of the bundle.
     */
    @JvmName("ekoxqqianmtwvfji")
    public suspend fun bundleName(`value`: Output<String>) {
        this.bundleName = value
    }

    /**
     * @param value The description of the bundle.
     */
    @JvmName("ogbasmvkbtfquhvu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The desktop type. You can call `alicloud.eds.getDesktopTypes` to query desktop type.
     */
    @JvmName("nxpcsfubfypjuipd")
    public suspend fun desktopType(`value`: Output<String>) {
        this.desktopType = value
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("cclmdwmiutamwarp")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The language. Valid values: `zh-CN`, `zh-HK`, `en-US`, `ja-JP`.
     */
    @JvmName("lkbgawarawfokqdk")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value The root disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("ecxpoqjittflsnaq")
    public suspend fun rootDiskPerformanceLevel(`value`: Output<String>) {
        this.rootDiskPerformanceLevel = value
    }

    /**
     * @param value The root disk size gib.
     */
    @JvmName("emajreyqbarfgfit")
    public suspend fun rootDiskSizeGib(`value`: Output<Int>) {
        this.rootDiskSizeGib = value
    }

    /**
     * @param value The user disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("jqrnuftldtxeqkfh")
    public suspend fun userDiskPerformanceLevel(`value`: Output<String>) {
        this.userDiskPerformanceLevel = value
    }

    /**
     * @param value The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
     * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
     * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
     */
    @JvmName("pclqvkbgmpxebuat")
    public suspend fun userDiskSizeGibs(`value`: Output<List<Int>>) {
        this.userDiskSizeGibs = value
    }

    @JvmName("aprhvyhlfixvdykm")
    public suspend fun userDiskSizeGibs(vararg values: Output<Int>) {
        this.userDiskSizeGibs = Output.all(values.asList())
    }

    /**
     * @param values The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
     * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
     * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
     */
    @JvmName("obvhehfsagsuddec")
    public suspend fun userDiskSizeGibs(values: List<Output<Int>>) {
        this.userDiskSizeGibs = Output.all(values)
    }

    /**
     * @param value The name of the bundle.
     */
    @JvmName("sqnusttoqgtagcei")
    public suspend fun bundleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleName = mapped
    }

    /**
     * @param value The description of the bundle.
     */
    @JvmName("wbdskiukjyugsdju")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The desktop type. You can call `alicloud.eds.getDesktopTypes` to query desktop type.
     */
    @JvmName("rhsddkhsqfqepcjl")
    public suspend fun desktopType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopType = mapped
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("tlcgxuwnqxswhaee")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The language. Valid values: `zh-CN`, `zh-HK`, `en-US`, `ja-JP`.
     */
    @JvmName("srvmqmfmpoipdchq")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The root disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("xwqoskfwgogujvxj")
    public suspend fun rootDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDiskPerformanceLevel = mapped
    }

    /**
     * @param value The root disk size gib.
     */
    @JvmName("hvbymporhwfrrywb")
    public suspend fun rootDiskSizeGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDiskSizeGib = mapped
    }

    /**
     * @param value The user disk performance level. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("loykpnogofdsqcnp")
    public suspend fun userDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDiskPerformanceLevel = mapped
    }

    /**
     * @param value The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
     * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
     * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
     */
    @JvmName("owjqtpiepsafsjck")
    public suspend fun userDiskSizeGibs(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDiskSizeGibs = mapped
    }

    /**
     * @param values The size of the data disk. Currently, only one data disk can be set. Unit: GiB.
     * - The size of the data disk that supports the setting corresponds to the specification. For more information, see [Overview of Desktop Specifications](https://help.aliyun.com/document_detail/188609.htm?spm=a2c4g.11186623.0.0.6406297bE0U5DG).
     * - The data disk size (user_disk_size_gib) set in the template must be greater than the data disk size (data_disk_size) in the mirror.
     */
    @JvmName("lxmaaugddtqymwkc")
    public suspend fun userDiskSizeGibs(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userDiskSizeGibs = mapped
    }

    internal fun build(): BundleArgs = BundleArgs(
        bundleName = bundleName,
        description = description,
        desktopType = desktopType,
        imageId = imageId,
        language = language,
        rootDiskPerformanceLevel = rootDiskPerformanceLevel,
        rootDiskSizeGib = rootDiskSizeGib,
        userDiskPerformanceLevel = userDiskPerformanceLevel,
        userDiskSizeGibs = userDiskSizeGibs,
    )
}
