@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.kotlin.outputs.CustomPropertyPropertyValue
import com.pulumi.alicloud.eds.kotlin.outputs.CustomPropertyPropertyValue.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CustomProperty].
 */
@PulumiTagMarker
public class CustomPropertyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomPropertyArgs = CustomPropertyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomPropertyArgsBuilder.() -> Unit) {
        val builder = CustomPropertyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomProperty {
        val builtJavaResource = com.pulumi.alicloud.eds.CustomProperty(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomProperty(builtJavaResource)
    }
}

/**
 * Provides a ECD Custom Property resource.
 * For information about ECD Custom Property and how to use it, see [What is Custom Property](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-eds-user-2021-03-08-createproperty-desktop).
 * > **NOTE:** Available since v1.176.0.
 * > **NOTE:** Up to 10 different attributes can be created under an alibaba cloud account. Up to 50 different attribute values can be added under an attribute.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.eds.CustomProperty("example", {
 *     propertyKey: "example_key",
 *     propertyValues: [{
 *         propertyValue: "example_value",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.eds.CustomProperty("example",
 *     property_key="example_key",
 *     property_values=[{
 *         "property_value": "example_value",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Eds.CustomProperty("example", new()
 *     {
 *         PropertyKey = "example_key",
 *         PropertyValues = new[]
 *         {
 *             new AliCloud.Eds.Inputs.CustomPropertyPropertyValueArgs
 *             {
 *                 PropertyValue = "example_value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eds.NewCustomProperty(ctx, "example", &eds.CustomPropertyArgs{
 * 			PropertyKey: pulumi.String("example_key"),
 * 			PropertyValues: eds.CustomPropertyPropertyValueArray{
 * 				&eds.CustomPropertyPropertyValueArgs{
 * 					PropertyValue: pulumi.String("example_value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.CustomProperty;
 * import com.pulumi.alicloud.eds.CustomPropertyArgs;
 * import com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomProperty("example", CustomPropertyArgs.builder()
 *             .propertyKey("example_key")
 *             .propertyValues(CustomPropertyPropertyValueArgs.builder()
 *                 .propertyValue("example_value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:eds:CustomProperty
 *     properties:
 *       propertyKey: example_key
 *       propertyValues:
 *         - propertyValue: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Custom Property can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/customProperty:CustomProperty example <id>
 * ```
 */
public class CustomProperty internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.CustomProperty,
) : KotlinCustomResource(javaResource, CustomPropertyMapper) {
    /**
     * The Custom attribute key.
     */
    public val propertyKey: Output<String>
        get() = javaResource.propertyKey().applyValue({ args0 -> args0 })

    /**
     * Custom attribute sets the value of. See `property_values` below.
     */
    public val propertyValues: Output<List<CustomPropertyPropertyValue>>?
        get() = javaResource.propertyValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object CustomPropertyMapper : ResourceMapper<CustomProperty> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.CustomProperty::class == javaResource::class

    override fun map(javaResource: Resource): CustomProperty = CustomProperty(
        javaResource as
            com.pulumi.alicloud.eds.CustomProperty,
    )
}

/**
 * @see [CustomProperty].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomProperty].
 */
public suspend fun customProperty(
    name: String,
    block: suspend CustomPropertyResourceBuilder.() -> Unit,
): CustomProperty {
    val builder = CustomPropertyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomProperty].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customProperty(name: String): CustomProperty {
    val builder = CustomPropertyResourceBuilder()
    builder.name(name)
    return builder.build()
}
