@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.CustomPropertyArgs.builder
import com.pulumi.alicloud.eds.kotlin.inputs.CustomPropertyPropertyValueArgs
import com.pulumi.alicloud.eds.kotlin.inputs.CustomPropertyPropertyValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECD Custom Property resource.
 * For information about ECD Custom Property and how to use it, see [What is Custom Property](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-eds-user-2021-03-08-createproperty-desktop).
 * > **NOTE:** Available since v1.176.0.
 * > **NOTE:** Up to 10 different attributes can be created under an alibaba cloud account. Up to 50 different attribute values can be added under an attribute.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.eds.CustomProperty("example", {
 *     propertyKey: "example_key",
 *     propertyValues: [{
 *         propertyValue: "example_value",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.eds.CustomProperty("example",
 *     property_key="example_key",
 *     property_values=[{
 *         "property_value": "example_value",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Eds.CustomProperty("example", new()
 *     {
 *         PropertyKey = "example_key",
 *         PropertyValues = new[]
 *         {
 *             new AliCloud.Eds.Inputs.CustomPropertyPropertyValueArgs
 *             {
 *                 PropertyValue = "example_value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eds.NewCustomProperty(ctx, "example", &eds.CustomPropertyArgs{
 * 			PropertyKey: pulumi.String("example_key"),
 * 			PropertyValues: eds.CustomPropertyPropertyValueArray{
 * 				&eds.CustomPropertyPropertyValueArgs{
 * 					PropertyValue: pulumi.String("example_value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.CustomProperty;
 * import com.pulumi.alicloud.eds.CustomPropertyArgs;
 * import com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomProperty("example", CustomPropertyArgs.builder()
 *             .propertyKey("example_key")
 *             .propertyValues(CustomPropertyPropertyValueArgs.builder()
 *                 .propertyValue("example_value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:eds:CustomProperty
 *     properties:
 *       propertyKey: example_key
 *       propertyValues:
 *         - propertyValue: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Custom Property can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/customProperty:CustomProperty example <id>
 * ```
 * @property propertyKey The Custom attribute key.
 * @property propertyValues Custom attribute sets the value of. See `property_values` below.
 */
public data class CustomPropertyArgs(
    public val propertyKey: Output<String>? = null,
    public val propertyValues: Output<List<CustomPropertyPropertyValueArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.CustomPropertyArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.CustomPropertyArgs =
        com.pulumi.alicloud.eds.CustomPropertyArgs.builder()
            .propertyKey(propertyKey?.applyValue({ args0 -> args0 }))
            .propertyValues(
                propertyValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomPropertyArgs].
 */
@PulumiTagMarker
public class CustomPropertyArgsBuilder internal constructor() {
    private var propertyKey: Output<String>? = null

    private var propertyValues: Output<List<CustomPropertyPropertyValueArgs>>? = null

    /**
     * @param value The Custom attribute key.
     */
    @JvmName("rsdkjddkvjqkwsov")
    public suspend fun propertyKey(`value`: Output<String>) {
        this.propertyKey = value
    }

    /**
     * @param value Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("isonvcmckmvxawsn")
    public suspend fun propertyValues(`value`: Output<List<CustomPropertyPropertyValueArgs>>) {
        this.propertyValues = value
    }

    @JvmName("gqjiqdoqmutrolrm")
    public suspend fun propertyValues(vararg values: Output<CustomPropertyPropertyValueArgs>) {
        this.propertyValues = Output.all(values.asList())
    }

    /**
     * @param values Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("qfcxdjdasfxvnmkc")
    public suspend fun propertyValues(values: List<Output<CustomPropertyPropertyValueArgs>>) {
        this.propertyValues = Output.all(values)
    }

    /**
     * @param value The Custom attribute key.
     */
    @JvmName("lgqdeeikigjovhmx")
    public suspend fun propertyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyKey = mapped
    }

    /**
     * @param value Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("oboqoutyylgusyui")
    public suspend fun propertyValues(`value`: List<CustomPropertyPropertyValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    /**
     * @param argument Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("ypebcjssoogpvnst")
    public suspend fun propertyValues(argument: List<suspend CustomPropertyPropertyValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomPropertyPropertyValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.propertyValues = mapped
    }

    /**
     * @param argument Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("ofdpwisektiqgpws")
    public suspend fun propertyValues(vararg argument: suspend CustomPropertyPropertyValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomPropertyPropertyValueArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.propertyValues = mapped
    }

    /**
     * @param argument Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("ltjhthqygjwcgodh")
    public suspend fun propertyValues(argument: suspend CustomPropertyPropertyValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomPropertyPropertyValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.propertyValues = mapped
    }

    /**
     * @param values Custom attribute sets the value of. See `property_values` below.
     */
    @JvmName("epbxtseyddbwvmtk")
    public suspend fun propertyValues(vararg values: CustomPropertyPropertyValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyValues = mapped
    }

    internal fun build(): CustomPropertyArgs = CustomPropertyArgs(
        propertyKey = propertyKey,
        propertyValues = propertyValues,
    )
}
