@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.DesktopArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECD Desktop resource.
 * For information about ECD Desktop and how to use it, see [What is Desktop](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createdesktops)
 * > **NOTE:** Available since v1.144.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
 *     cidrBlock: "172.16.0.0/12",
 *     enableAdminAccess: true,
 *     desktopAccessType: "Internet",
 *     officeSiteName: `${name}-${defaultInteger.result}`,
 * });
 * const defaultEcdPolicyGroup = new alicloud.eds.EcdPolicyGroup("default", {
 *     policyGroupName: name,
 *     clipboard: "read",
 *     localDrive: "read",
 *     usbRedirect: "off",
 *     watermark: "off",
 *     authorizeAccessPolicyRules: [{
 *         description: name,
 *         cidrIp: "1.2.3.45/24",
 *     }],
 *     authorizeSecurityPolicyRules: [{
 *         type: "inflow",
 *         policy: "accept",
 *         description: name,
 *         portRange: "80/80",
 *         ipProtocol: "TCP",
 *         priority: "1",
 *         cidrIp: "1.2.3.4/24",
 *     }],
 * });
 * const default = alicloud.eds.getBundles({
 *     bundleType: "SYSTEM",
 * });
 * const defaultDesktop = new alicloud.eds.Desktop("default", {
 *     officeSiteId: defaultSimpleOfficeSite.id,
 *     policyGroupId: defaultEcdPolicyGroup.id,
 *     bundleId: _default.then(_default => _default.bundles?.[1]?.id),
 *     desktopName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
 *     cidr_block="172.16.0.0/12",
 *     enable_admin_access=True,
 *     desktop_access_type="Internet",
 *     office_site_name=f"{name}-{default_integer['result']}")
 * default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("default",
 *     policy_group_name=name,
 *     clipboard="read",
 *     local_drive="read",
 *     usb_redirect="off",
 *     watermark="off",
 *     authorize_access_policy_rules=[{
 *         "description": name,
 *         "cidr_ip": "1.2.3.45/24",
 *     }],
 *     authorize_security_policy_rules=[{
 *         "type": "inflow",
 *         "policy": "accept",
 *         "description": name,
 *         "port_range": "80/80",
 *         "ip_protocol": "TCP",
 *         "priority": "1",
 *         "cidr_ip": "1.2.3.4/24",
 *     }])
 * default = alicloud.eds.get_bundles(bundle_type="SYSTEM")
 * default_desktop = alicloud.eds.Desktop("default",
 *     office_site_id=default_simple_office_site.id,
 *     policy_group_id=default_ecd_policy_group.id,
 *     bundle_id=default.bundles[1].id,
 *     desktop_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         EnableAdminAccess = true,
 *         DesktopAccessType = "Internet",
 *         OfficeSiteName = $"{name}-{defaultInteger.Result}",
 *     });
 *     var defaultEcdPolicyGroup = new AliCloud.Eds.EcdPolicyGroup("default", new()
 *     {
 *         PolicyGroupName = name,
 *         Clipboard = "read",
 *         LocalDrive = "read",
 *         UsbRedirect = "off",
 *         Watermark = "off",
 *         AuthorizeAccessPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
 *             {
 *                 Description = name,
 *                 CidrIp = "1.2.3.45/24",
 *             },
 *         },
 *         AuthorizeSecurityPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
 *             {
 *                 Type = "inflow",
 *                 Policy = "accept",
 *                 Description = name,
 *                 PortRange = "80/80",
 *                 IpProtocol = "TCP",
 *                 Priority = "1",
 *                 CidrIp = "1.2.3.4/24",
 *             },
 *         },
 *     });
 *     var @default = AliCloud.Eds.GetBundles.Invoke(new()
 *     {
 *         BundleType = "SYSTEM",
 *     });
 *     var defaultDesktop = new AliCloud.Eds.Desktop("default", new()
 *     {
 *         OfficeSiteId = defaultSimpleOfficeSite.Id,
 *         PolicyGroupId = defaultEcdPolicyGroup.Id,
 *         BundleId = @default.Apply(@default => @default.Apply(getBundlesResult => getBundlesResult.Bundles[1]?.Id)),
 *         DesktopName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
 * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			DesktopAccessType: pulumi.String("Internet"),
 * 			OfficeSiteName:    pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcdPolicyGroup, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
 * 			PolicyGroupName: pulumi.String(name),
 * 			Clipboard:       pulumi.String("read"),
 * 			LocalDrive:      pulumi.String("read"),
 * 			UsbRedirect:     pulumi.String("off"),
 * 			Watermark:       pulumi.String("off"),
 * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
 * 					Description: pulumi.String(name),
 * 					CidrIp:      pulumi.String("1.2.3.45/24"),
 * 				},
 * 			},
 * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
 * 					Type:        pulumi.String("inflow"),
 * 					Policy:      pulumi.String("accept"),
 * 					Description: pulumi.String(name),
 * 					PortRange:   pulumi.String("80/80"),
 * 					IpProtocol:  pulumi.String("TCP"),
 * 					Priority:    pulumi.String("1"),
 * 					CidrIp:      pulumi.String("1.2.3.4/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := eds.GetBundles(ctx, &eds.GetBundlesArgs{
 * 			BundleType: pulumi.StringRef("SYSTEM"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewDesktop(ctx, "default", &eds.DesktopArgs{
 * 			OfficeSiteId:  defaultSimpleOfficeSite.ID(),
 * 			PolicyGroupId: defaultEcdPolicyGroup.ID(),
 * 			BundleId:      pulumi.String(_default.Bundles[1].Id),
 * 			DesktopName:   pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.SimpleOfficeSite;
 * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
 * import com.pulumi.alicloud.eds.EcdPolicyGroup;
 * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetBundlesArgs;
 * import com.pulumi.alicloud.eds.Desktop;
 * import com.pulumi.alicloud.eds.DesktopArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .enableAdminAccess(true)
 *             .desktopAccessType("Internet")
 *             .officeSiteName(String.format("%s-%s", name,defaultInteger.result()))
 *             .build());
 *         var defaultEcdPolicyGroup = new EcdPolicyGroup("defaultEcdPolicyGroup", EcdPolicyGroupArgs.builder()
 *             .policyGroupName(name)
 *             .clipboard("read")
 *             .localDrive("read")
 *             .usbRedirect("off")
 *             .watermark("off")
 *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
 *                 .description(name)
 *                 .cidrIp("1.2.3.45/24")
 *                 .build())
 *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
 *                 .type("inflow")
 *                 .policy("accept")
 *                 .description(name)
 *                 .portRange("80/80")
 *                 .ipProtocol("TCP")
 *                 .priority("1")
 *                 .cidrIp("1.2.3.4/24")
 *                 .build())
 *             .build());
 *         final var default = EdsFunctions.getBundles(GetBundlesArgs.builder()
 *             .bundleType("SYSTEM")
 *             .build());
 *         var defaultDesktop = new Desktop("defaultDesktop", DesktopArgs.builder()
 *             .officeSiteId(defaultSimpleOfficeSite.id())
 *             .policyGroupId(defaultEcdPolicyGroup.id())
 *             .bundleId(default_.bundles()[1].id())
 *             .desktopName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSimpleOfficeSite:
 *     type: alicloud:eds:SimpleOfficeSite
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       enableAdminAccess: true
 *       desktopAccessType: Internet
 *       officeSiteName: ${name}-${defaultInteger.result}
 *   defaultEcdPolicyGroup:
 *     type: alicloud:eds:EcdPolicyGroup
 *     name: default
 *     properties:
 *       policyGroupName: ${name}
 *       clipboard: read
 *       localDrive: read
 *       usbRedirect: off
 *       watermark: off
 *       authorizeAccessPolicyRules:
 *         - description: ${name}
 *           cidrIp: 1.2.3.45/24
 *       authorizeSecurityPolicyRules:
 *         - type: inflow
 *           policy: accept
 *           description: ${name}
 *           portRange: 80/80
 *           ipProtocol: TCP
 *           priority: '1'
 *           cidrIp: 1.2.3.4/24
 *   defaultDesktop:
 *     type: alicloud:eds:Desktop
 *     name: default
 *     properties:
 *       officeSiteId: ${defaultSimpleOfficeSite.id}
 *       policyGroupId: ${defaultEcdPolicyGroup.id}
 *       bundleId: ${default.bundles[1].id}
 *       desktopName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getBundles
 *       Arguments:
 *         bundleType: SYSTEM
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Desktop can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/desktop:Desktop example <id>
 * ```
 * @property amount The amount of the Desktop.
 * @property autoPay The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
 * @property autoRenew The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
 * @property bundleId The bundle id of the Desktop.
 * @property desktopName The desktop name of the Desktop.
 * @property desktopType The desktop type of the Desktop.
 * @property endUserIds The desktop end user id of the Desktop.
 * @property hostName The hostname of the Desktop.
 * @property officeSiteId The ID of the Simple Office Site.
 * @property paymentType The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
 * @property period The period of the Desktop.
 * @property periodUnit The period unit of the Desktop.
 * @property policyGroupId The policy group id of the Desktop.
 * @property rootDiskSizeGib The root disk size gib of the Desktop.
 * @property status The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
 * @property stoppedMode The stopped mode of the Desktop.
 * @property tags A mapping of tags to assign to the resource.
 * @property userAssignMode The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
 * @property userDiskSizeGib The user disk size gib of the Desktop.
 */
public data class DesktopArgs(
    public val amount: Output<Int>? = null,
    public val autoPay: Output<Boolean>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val bundleId: Output<String>? = null,
    public val desktopName: Output<String>? = null,
    public val desktopType: Output<String>? = null,
    public val endUserIds: Output<List<String>>? = null,
    public val hostName: Output<String>? = null,
    public val officeSiteId: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val policyGroupId: Output<String>? = null,
    public val rootDiskSizeGib: Output<Int>? = null,
    public val status: Output<String>? = null,
    public val stoppedMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userAssignMode: Output<String>? = null,
    public val userDiskSizeGib: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.DesktopArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.DesktopArgs =
        com.pulumi.alicloud.eds.DesktopArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .desktopName(desktopName?.applyValue({ args0 -> args0 }))
            .desktopType(desktopType?.applyValue({ args0 -> args0 }))
            .endUserIds(endUserIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .officeSiteId(officeSiteId?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .policyGroupId(policyGroupId?.applyValue({ args0 -> args0 }))
            .rootDiskSizeGib(rootDiskSizeGib?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .stoppedMode(stoppedMode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userAssignMode(userAssignMode?.applyValue({ args0 -> args0 }))
            .userDiskSizeGib(userDiskSizeGib?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DesktopArgs].
 */
@PulumiTagMarker
public class DesktopArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var autoPay: Output<Boolean>? = null

    private var autoRenew: Output<Boolean>? = null

    private var bundleId: Output<String>? = null

    private var desktopName: Output<String>? = null

    private var desktopType: Output<String>? = null

    private var endUserIds: Output<List<String>>? = null

    private var hostName: Output<String>? = null

    private var officeSiteId: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var policyGroupId: Output<String>? = null

    private var rootDiskSizeGib: Output<Int>? = null

    private var status: Output<String>? = null

    private var stoppedMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userAssignMode: Output<String>? = null

    private var userDiskSizeGib: Output<Int>? = null

    /**
     * @param value The amount of the Desktop.
     */
    @JvmName("ptcditsxiokltchl")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
     */
    @JvmName("jogvhcbggdjflgae")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
     */
    @JvmName("sgycmxyyxbwbbhee")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The bundle id of the Desktop.
     */
    @JvmName("nlnevexruulfsfrh")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The desktop name of the Desktop.
     */
    @JvmName("ikkyhqcvkjjrjcbm")
    public suspend fun desktopName(`value`: Output<String>) {
        this.desktopName = value
    }

    /**
     * @param value The desktop type of the Desktop.
     */
    @JvmName("yksnhcplrfakxcsg")
    public suspend fun desktopType(`value`: Output<String>) {
        this.desktopType = value
    }

    /**
     * @param value The desktop end user id of the Desktop.
     */
    @JvmName("ydmkguojlvmatukd")
    public suspend fun endUserIds(`value`: Output<List<String>>) {
        this.endUserIds = value
    }

    @JvmName("daanpkwbowyoluxl")
    public suspend fun endUserIds(vararg values: Output<String>) {
        this.endUserIds = Output.all(values.asList())
    }

    /**
     * @param values The desktop end user id of the Desktop.
     */
    @JvmName("vuocqbdmirdwiosa")
    public suspend fun endUserIds(values: List<Output<String>>) {
        this.endUserIds = Output.all(values)
    }

    /**
     * @param value The hostname of the Desktop.
     */
    @JvmName("kokppbeacwigybvh")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The ID of the Simple Office Site.
     */
    @JvmName("rgmncgjtxatgtvqf")
    public suspend fun officeSiteId(`value`: Output<String>) {
        this.officeSiteId = value
    }

    /**
     * @param value The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("ahuiasqiqylswiya")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The period of the Desktop.
     */
    @JvmName("hdohpoprrwfkxeis")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The period unit of the Desktop.
     */
    @JvmName("ewvnopmaktpgidau")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The policy group id of the Desktop.
     */
    @JvmName("kangjonjjfuccbvn")
    public suspend fun policyGroupId(`value`: Output<String>) {
        this.policyGroupId = value
    }

    /**
     * @param value The root disk size gib of the Desktop.
     */
    @JvmName("rriaqufbkeoefodb")
    public suspend fun rootDiskSizeGib(`value`: Output<Int>) {
        this.rootDiskSizeGib = value
    }

    /**
     * @param value The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
     */
    @JvmName("igimkoseeftqfbxp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The stopped mode of the Desktop.
     */
    @JvmName("wsidsgjksjxmvphx")
    public suspend fun stoppedMode(`value`: Output<String>) {
        this.stoppedMode = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rqapefmysjgmqxly")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
     */
    @JvmName("qbndamasyseorqas")
    public suspend fun userAssignMode(`value`: Output<String>) {
        this.userAssignMode = value
    }

    /**
     * @param value The user disk size gib of the Desktop.
     */
    @JvmName("raogaxivxvhcsfsa")
    public suspend fun userDiskSizeGib(`value`: Output<Int>) {
        this.userDiskSizeGib = value
    }

    /**
     * @param value The amount of the Desktop.
     */
    @JvmName("htfshsfpjqitbqkn")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
     */
    @JvmName("xnovfqybkwywhsei")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
     */
    @JvmName("qywtxtbyjiinjuce")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The bundle id of the Desktop.
     */
    @JvmName("typreyklnisohlys")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The desktop name of the Desktop.
     */
    @JvmName("pwrjhnfwgwutrcwe")
    public suspend fun desktopName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopName = mapped
    }

    /**
     * @param value The desktop type of the Desktop.
     */
    @JvmName("grrmmwooqlgmosog")
    public suspend fun desktopType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopType = mapped
    }

    /**
     * @param value The desktop end user id of the Desktop.
     */
    @JvmName("bkxgempmjmglaikp")
    public suspend fun endUserIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endUserIds = mapped
    }

    /**
     * @param values The desktop end user id of the Desktop.
     */
    @JvmName("jwnkgqlytcqdgyhy")
    public suspend fun endUserIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endUserIds = mapped
    }

    /**
     * @param value The hostname of the Desktop.
     */
    @JvmName("noqischbcftmdpga")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The ID of the Simple Office Site.
     */
    @JvmName("qnmtyvhublbwgyow")
    public suspend fun officeSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.officeSiteId = mapped
    }

    /**
     * @param value The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("xgtljlcapxwbdmvj")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The period of the Desktop.
     */
    @JvmName("nnbhfodchthbwlvh")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The period unit of the Desktop.
     */
    @JvmName("goycpdkvlqfxlbba")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The policy group id of the Desktop.
     */
    @JvmName("nrtweftjjckeefef")
    public suspend fun policyGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyGroupId = mapped
    }

    /**
     * @param value The root disk size gib of the Desktop.
     */
    @JvmName("vccfjwwpujoknemd")
    public suspend fun rootDiskSizeGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDiskSizeGib = mapped
    }

    /**
     * @param value The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
     */
    @JvmName("oikhvjtqknqwjkoi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The stopped mode of the Desktop.
     */
    @JvmName("fgjwslrkrhkgveuf")
    public suspend fun stoppedMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stoppedMode = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("qokwjgascgkaugaa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("kvaqodgxrcyjbsxf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
     */
    @JvmName("xotfslnfbkvytuqd")
    public suspend fun userAssignMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignMode = mapped
    }

    /**
     * @param value The user disk size gib of the Desktop.
     */
    @JvmName("xvvtydrxklwllqxw")
    public suspend fun userDiskSizeGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDiskSizeGib = mapped
    }

    internal fun build(): DesktopArgs = DesktopArgs(
        amount = amount,
        autoPay = autoPay,
        autoRenew = autoRenew,
        bundleId = bundleId,
        desktopName = desktopName,
        desktopType = desktopType,
        endUserIds = endUserIds,
        hostName = hostName,
        officeSiteId = officeSiteId,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        policyGroupId = policyGroupId,
        rootDiskSizeGib = rootDiskSizeGib,
        status = status,
        stoppedMode = stoppedMode,
        tags = tags,
        userAssignMode = userAssignMode,
        userDiskSizeGib = userDiskSizeGib,
    )
}
