@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.kotlin.outputs.EcdPolicyGroupAuthorizeAccessPolicyRule
import com.pulumi.alicloud.eds.kotlin.outputs.EcdPolicyGroupAuthorizeSecurityPolicyRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.eds.kotlin.outputs.EcdPolicyGroupAuthorizeAccessPolicyRule.Companion.toKotlin as ecdPolicyGroupAuthorizeAccessPolicyRuleToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.EcdPolicyGroupAuthorizeSecurityPolicyRule.Companion.toKotlin as ecdPolicyGroupAuthorizeSecurityPolicyRuleToKotlin

/**
 * Builder for [EcdPolicyGroup].
 */
@PulumiTagMarker
public class EcdPolicyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EcdPolicyGroupArgs = EcdPolicyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EcdPolicyGroupArgsBuilder.() -> Unit) {
        val builder = EcdPolicyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EcdPolicyGroup {
        val builtJavaResource = com.pulumi.alicloud.eds.EcdPolicyGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EcdPolicyGroup(builtJavaResource)
    }
}

/**
 * Provides a Elastic Desktop Service (ECD) Policy Group resource.
 * For information about Elastic Desktop Service (ECD) Policy Group and how to use it, see [What is Policy Group](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createpolicygroup).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.eds.EcdPolicyGroup("default", {
 *     policyGroupName: "terraform-example",
 *     clipboard: "read",
 *     localDrive: "read",
 *     usbRedirect: "off",
 *     watermark: "off",
 *     authorizeAccessPolicyRules: [{
 *         description: "terraform-example",
 *         cidrIp: "1.2.3.45/24",
 *     }],
 *     authorizeSecurityPolicyRules: [{
 *         type: "inflow",
 *         policy: "accept",
 *         description: "terraform-example",
 *         portRange: "80/80",
 *         ipProtocol: "TCP",
 *         priority: "1",
 *         cidrIp: "1.2.3.4/24",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.eds.EcdPolicyGroup("default",
 *     policy_group_name="terraform-example",
 *     clipboard="read",
 *     local_drive="read",
 *     usb_redirect="off",
 *     watermark="off",
 *     authorize_access_policy_rules=[{
 *         "description": "terraform-example",
 *         "cidr_ip": "1.2.3.45/24",
 *     }],
 *     authorize_security_policy_rules=[{
 *         "type": "inflow",
 *         "policy": "accept",
 *         "description": "terraform-example",
 *         "port_range": "80/80",
 *         "ip_protocol": "TCP",
 *         "priority": "1",
 *         "cidr_ip": "1.2.3.4/24",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Eds.EcdPolicyGroup("default", new()
 *     {
 *         PolicyGroupName = "terraform-example",
 *         Clipboard = "read",
 *         LocalDrive = "read",
 *         UsbRedirect = "off",
 *         Watermark = "off",
 *         AuthorizeAccessPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
 *             {
 *                 Description = "terraform-example",
 *                 CidrIp = "1.2.3.45/24",
 *             },
 *         },
 *         AuthorizeSecurityPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
 *             {
 *                 Type = "inflow",
 *                 Policy = "accept",
 *                 Description = "terraform-example",
 *                 PortRange = "80/80",
 *                 IpProtocol = "TCP",
 *                 Priority = "1",
 *                 CidrIp = "1.2.3.4/24",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
 * 			PolicyGroupName: pulumi.String("terraform-example"),
 * 			Clipboard:       pulumi.String("read"),
 * 			LocalDrive:      pulumi.String("read"),
 * 			UsbRedirect:     pulumi.String("off"),
 * 			Watermark:       pulumi.String("off"),
 * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
 * 					Description: pulumi.String("terraform-example"),
 * 					CidrIp:      pulumi.String("1.2.3.45/24"),
 * 				},
 * 			},
 * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
 * 					Type:        pulumi.String("inflow"),
 * 					Policy:      pulumi.String("accept"),
 * 					Description: pulumi.String("terraform-example"),
 * 					PortRange:   pulumi.String("80/80"),
 * 					IpProtocol:  pulumi.String("TCP"),
 * 					Priority:    pulumi.String("1"),
 * 					CidrIp:      pulumi.String("1.2.3.4/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EcdPolicyGroup;
 * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcdPolicyGroup("default", EcdPolicyGroupArgs.builder()
 *             .policyGroupName("terraform-example")
 *             .clipboard("read")
 *             .localDrive("read")
 *             .usbRedirect("off")
 *             .watermark("off")
 *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
 *                 .description("terraform-example")
 *                 .cidrIp("1.2.3.45/24")
 *                 .build())
 *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
 *                 .type("inflow")
 *                 .policy("accept")
 *                 .description("terraform-example")
 *                 .portRange("80/80")
 *                 .ipProtocol("TCP")
 *                 .priority("1")
 *                 .cidrIp("1.2.3.4/24")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:eds:EcdPolicyGroup
 *     properties:
 *       policyGroupName: terraform-example
 *       clipboard: read
 *       localDrive: read
 *       usbRedirect: off
 *       watermark: off
 *       authorizeAccessPolicyRules:
 *         - description: terraform-example
 *           cidrIp: 1.2.3.45/24
 *       authorizeSecurityPolicyRules:
 *         - type: inflow
 *           policy: accept
 *           description: terraform-example
 *           portRange: 80/80
 *           ipProtocol: TCP
 *           priority: '1'
 *           cidrIp: 1.2.3.4/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Elastic Desktop Service (ECD) Policy Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/ecdPolicyGroup:EcdPolicyGroup example <id>
 * ```
 */
public class EcdPolicyGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.EcdPolicyGroup,
) : KotlinCustomResource(javaResource, EcdPolicyGroupMapper) {
    /**
     * The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    public val authorizeAccessPolicyRules: Output<List<EcdPolicyGroupAuthorizeAccessPolicyRule>>?
        get() = javaResource.authorizeAccessPolicyRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ecdPolicyGroupAuthorizeAccessPolicyRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The policy rule. See `authorize_security_policy_rules` below.
     */
    public val authorizeSecurityPolicyRules: Output<List<EcdPolicyGroupAuthorizeSecurityPolicyRule>>?
        get() = javaResource.authorizeSecurityPolicyRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ecdPolicyGroupAuthorizeSecurityPolicyRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Whether to enable local camera redirection. Valid values: `on`, `off`.
     */
    public val cameraRedirect: Output<String>
        get() = javaResource.cameraRedirect().applyValue({ args0 -> args0 })

    /**
     * The clipboard policy. Valid values: `off`, `read`, `readwrite`.
     */
    public val clipboard: Output<String>
        get() = javaResource.clipboard().applyValue({ args0 -> args0 })

    /**
     * The list of domain.
     */
    public val domainList: Output<String>?
        get() = javaResource.domainList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The access of html5. Valid values: `off`, `on`.
     */
    public val htmlAccess: Output<String>
        get() = javaResource.htmlAccess().applyValue({ args0 -> args0 })

    /**
     * The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
     */
    public val htmlFileTransfer: Output<String>
        get() = javaResource.htmlFileTransfer().applyValue({ args0 -> args0 })

    /**
     * Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
     */
    public val localDrive: Output<String>
        get() = javaResource.localDrive().applyValue({ args0 -> args0 })

    /**
     * The name of policy group.
     */
    public val policyGroupName: Output<String>?
        get() = javaResource.policyGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
     */
    public val recording: Output<String>
        get() = javaResource.recording().applyValue({ args0 -> args0 })

    /**
     * The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    public val recordingEndTime: Output<String>?
        get() = javaResource.recordingEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
     */
    public val recordingExpires: Output<Int>
        get() = javaResource.recordingExpires().applyValue({ args0 -> args0 })

    /**
     * The fps of recording. Valid values: `2`, `5`, `10`, `15`.
     */
    public val recordingFps: Output<Int>
        get() = javaResource.recordingFps().applyValue({ args0 -> args0 })

    /**
     * The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    public val recordingStartTime: Output<String>?
        get() = javaResource.recordingStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of policy.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The usb redirect policy. Valid values: `off`, `on`.
     */
    public val usbRedirect: Output<String>
        get() = javaResource.usbRedirect().applyValue({ args0 -> args0 })

    /**
     * The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
     */
    public val visualQuality: Output<String>
        get() = javaResource.visualQuality().applyValue({ args0 -> args0 })

    /**
     * The watermark policy. Valid values: `off`, `on`.
     */
    public val watermark: Output<String>
        get() = javaResource.watermark().applyValue({ args0 -> args0 })

    /**
     * The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
     */
    public val watermarkTransparency: Output<String>
        get() = javaResource.watermarkTransparency().applyValue({ args0 -> args0 })

    /**
     * The type of watemark. Valid values: `EndUserId`, `HostName`.
     */
    public val watermarkType: Output<String>
        get() = javaResource.watermarkType().applyValue({ args0 -> args0 })
}

public object EcdPolicyGroupMapper : ResourceMapper<EcdPolicyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.EcdPolicyGroup::class == javaResource::class

    override fun map(javaResource: Resource): EcdPolicyGroup = EcdPolicyGroup(
        javaResource as
            com.pulumi.alicloud.eds.EcdPolicyGroup,
    )
}

/**
 * @see [EcdPolicyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EcdPolicyGroup].
 */
public suspend fun ecdPolicyGroup(
    name: String,
    block: suspend EcdPolicyGroupResourceBuilder.() -> Unit,
): EcdPolicyGroup {
    val builder = EcdPolicyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EcdPolicyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ecdPolicyGroup(name: String): EcdPolicyGroup {
    val builder = EcdPolicyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
