@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.EcdPolicyGroupArgs.builder
import com.pulumi.alicloud.eds.kotlin.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
import com.pulumi.alicloud.eds.kotlin.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
import com.pulumi.alicloud.eds.kotlin.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Elastic Desktop Service (ECD) Policy Group resource.
 * For information about Elastic Desktop Service (ECD) Policy Group and how to use it, see [What is Policy Group](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createpolicygroup).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.eds.EcdPolicyGroup("default", {
 *     policyGroupName: "terraform-example",
 *     clipboard: "read",
 *     localDrive: "read",
 *     usbRedirect: "off",
 *     watermark: "off",
 *     authorizeAccessPolicyRules: [{
 *         description: "terraform-example",
 *         cidrIp: "1.2.3.45/24",
 *     }],
 *     authorizeSecurityPolicyRules: [{
 *         type: "inflow",
 *         policy: "accept",
 *         description: "terraform-example",
 *         portRange: "80/80",
 *         ipProtocol: "TCP",
 *         priority: "1",
 *         cidrIp: "1.2.3.4/24",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.eds.EcdPolicyGroup("default",
 *     policy_group_name="terraform-example",
 *     clipboard="read",
 *     local_drive="read",
 *     usb_redirect="off",
 *     watermark="off",
 *     authorize_access_policy_rules=[{
 *         "description": "terraform-example",
 *         "cidr_ip": "1.2.3.45/24",
 *     }],
 *     authorize_security_policy_rules=[{
 *         "type": "inflow",
 *         "policy": "accept",
 *         "description": "terraform-example",
 *         "port_range": "80/80",
 *         "ip_protocol": "TCP",
 *         "priority": "1",
 *         "cidr_ip": "1.2.3.4/24",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Eds.EcdPolicyGroup("default", new()
 *     {
 *         PolicyGroupName = "terraform-example",
 *         Clipboard = "read",
 *         LocalDrive = "read",
 *         UsbRedirect = "off",
 *         Watermark = "off",
 *         AuthorizeAccessPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
 *             {
 *                 Description = "terraform-example",
 *                 CidrIp = "1.2.3.45/24",
 *             },
 *         },
 *         AuthorizeSecurityPolicyRules = new[]
 *         {
 *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
 *             {
 *                 Type = "inflow",
 *                 Policy = "accept",
 *                 Description = "terraform-example",
 *                 PortRange = "80/80",
 *                 IpProtocol = "TCP",
 *                 Priority = "1",
 *                 CidrIp = "1.2.3.4/24",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
 * 			PolicyGroupName: pulumi.String("terraform-example"),
 * 			Clipboard:       pulumi.String("read"),
 * 			LocalDrive:      pulumi.String("read"),
 * 			UsbRedirect:     pulumi.String("off"),
 * 			Watermark:       pulumi.String("off"),
 * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
 * 					Description: pulumi.String("terraform-example"),
 * 					CidrIp:      pulumi.String("1.2.3.45/24"),
 * 				},
 * 			},
 * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
 * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
 * 					Type:        pulumi.String("inflow"),
 * 					Policy:      pulumi.String("accept"),
 * 					Description: pulumi.String("terraform-example"),
 * 					PortRange:   pulumi.String("80/80"),
 * 					IpProtocol:  pulumi.String("TCP"),
 * 					Priority:    pulumi.String("1"),
 * 					CidrIp:      pulumi.String("1.2.3.4/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EcdPolicyGroup;
 * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
 * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EcdPolicyGroup("default", EcdPolicyGroupArgs.builder()
 *             .policyGroupName("terraform-example")
 *             .clipboard("read")
 *             .localDrive("read")
 *             .usbRedirect("off")
 *             .watermark("off")
 *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
 *                 .description("terraform-example")
 *                 .cidrIp("1.2.3.45/24")
 *                 .build())
 *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
 *                 .type("inflow")
 *                 .policy("accept")
 *                 .description("terraform-example")
 *                 .portRange("80/80")
 *                 .ipProtocol("TCP")
 *                 .priority("1")
 *                 .cidrIp("1.2.3.4/24")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:eds:EcdPolicyGroup
 *     properties:
 *       policyGroupName: terraform-example
 *       clipboard: read
 *       localDrive: read
 *       usbRedirect: off
 *       watermark: off
 *       authorizeAccessPolicyRules:
 *         - description: terraform-example
 *           cidrIp: 1.2.3.45/24
 *       authorizeSecurityPolicyRules:
 *         - type: inflow
 *           policy: accept
 *           description: terraform-example
 *           portRange: 80/80
 *           ipProtocol: TCP
 *           priority: '1'
 *           cidrIp: 1.2.3.4/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Elastic Desktop Service (ECD) Policy Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/ecdPolicyGroup:EcdPolicyGroup example <id>
 * ```
 * @property authorizeAccessPolicyRules The rule of authorize access rule. See `authorize_access_policy_rules` below.
 * @property authorizeSecurityPolicyRules The policy rule. See `authorize_security_policy_rules` below.
 * @property cameraRedirect Whether to enable local camera redirection. Valid values: `on`, `off`.
 * @property clipboard The clipboard policy. Valid values: `off`, `read`, `readwrite`.
 * @property domainList The list of domain.
 * @property htmlAccess The access of html5. Valid values: `off`, `on`.
 * @property htmlFileTransfer The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
 * @property localDrive Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
 * @property policyGroupName The name of policy group.
 * @property recording Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
 * @property recordingEndTime The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
 * @property recordingExpires The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
 * @property recordingFps The fps of recording. Valid values: `2`, `5`, `10`, `15`.
 * @property recordingStartTime The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
 * @property usbRedirect The usb redirect policy. Valid values: `off`, `on`.
 * @property visualQuality The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
 * @property watermark The watermark policy. Valid values: `off`, `on`.
 * @property watermarkTransparency The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
 * @property watermarkType The type of watemark. Valid values: `EndUserId`, `HostName`.
 */
public data class EcdPolicyGroupArgs(
    public val authorizeAccessPolicyRules: Output<List<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>>? =
        null,
    public val authorizeSecurityPolicyRules: Output<List<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>>? = null,
    public val cameraRedirect: Output<String>? = null,
    public val clipboard: Output<String>? = null,
    public val domainList: Output<String>? = null,
    public val htmlAccess: Output<String>? = null,
    public val htmlFileTransfer: Output<String>? = null,
    public val localDrive: Output<String>? = null,
    public val policyGroupName: Output<String>? = null,
    public val recording: Output<String>? = null,
    public val recordingEndTime: Output<String>? = null,
    public val recordingExpires: Output<Int>? = null,
    public val recordingFps: Output<Int>? = null,
    public val recordingStartTime: Output<String>? = null,
    public val usbRedirect: Output<String>? = null,
    public val visualQuality: Output<String>? = null,
    public val watermark: Output<String>? = null,
    public val watermarkTransparency: Output<String>? = null,
    public val watermarkType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.EcdPolicyGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.EcdPolicyGroupArgs =
        com.pulumi.alicloud.eds.EcdPolicyGroupArgs.builder()
            .authorizeAccessPolicyRules(
                authorizeAccessPolicyRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .authorizeSecurityPolicyRules(
                authorizeSecurityPolicyRules?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .cameraRedirect(cameraRedirect?.applyValue({ args0 -> args0 }))
            .clipboard(clipboard?.applyValue({ args0 -> args0 }))
            .domainList(domainList?.applyValue({ args0 -> args0 }))
            .htmlAccess(htmlAccess?.applyValue({ args0 -> args0 }))
            .htmlFileTransfer(htmlFileTransfer?.applyValue({ args0 -> args0 }))
            .localDrive(localDrive?.applyValue({ args0 -> args0 }))
            .policyGroupName(policyGroupName?.applyValue({ args0 -> args0 }))
            .recording(recording?.applyValue({ args0 -> args0 }))
            .recordingEndTime(recordingEndTime?.applyValue({ args0 -> args0 }))
            .recordingExpires(recordingExpires?.applyValue({ args0 -> args0 }))
            .recordingFps(recordingFps?.applyValue({ args0 -> args0 }))
            .recordingStartTime(recordingStartTime?.applyValue({ args0 -> args0 }))
            .usbRedirect(usbRedirect?.applyValue({ args0 -> args0 }))
            .visualQuality(visualQuality?.applyValue({ args0 -> args0 }))
            .watermark(watermark?.applyValue({ args0 -> args0 }))
            .watermarkTransparency(watermarkTransparency?.applyValue({ args0 -> args0 }))
            .watermarkType(watermarkType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcdPolicyGroupArgs].
 */
@PulumiTagMarker
public class EcdPolicyGroupArgsBuilder internal constructor() {
    private var authorizeAccessPolicyRules: Output<List<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>>? =
        null

    private var authorizeSecurityPolicyRules:
        Output<List<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>>? = null

    private var cameraRedirect: Output<String>? = null

    private var clipboard: Output<String>? = null

    private var domainList: Output<String>? = null

    private var htmlAccess: Output<String>? = null

    private var htmlFileTransfer: Output<String>? = null

    private var localDrive: Output<String>? = null

    private var policyGroupName: Output<String>? = null

    private var recording: Output<String>? = null

    private var recordingEndTime: Output<String>? = null

    private var recordingExpires: Output<Int>? = null

    private var recordingFps: Output<Int>? = null

    private var recordingStartTime: Output<String>? = null

    private var usbRedirect: Output<String>? = null

    private var visualQuality: Output<String>? = null

    private var watermark: Output<String>? = null

    private var watermarkTransparency: Output<String>? = null

    private var watermarkType: Output<String>? = null

    /**
     * @param value The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("hbkmxlrbhpygthur")
    public suspend fun authorizeAccessPolicyRules(`value`: Output<List<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>>) {
        this.authorizeAccessPolicyRules = value
    }

    @JvmName("cuelnvewmwoxyxxt")
    public suspend fun authorizeAccessPolicyRules(vararg values: Output<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>) {
        this.authorizeAccessPolicyRules = Output.all(values.asList())
    }

    /**
     * @param values The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("ljwjgdmdklkxfwib")
    public suspend fun authorizeAccessPolicyRules(values: List<Output<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>>) {
        this.authorizeAccessPolicyRules = Output.all(values)
    }

    /**
     * @param value The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("eytxomapspcqinfn")
    public suspend fun authorizeSecurityPolicyRules(`value`: Output<List<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>>) {
        this.authorizeSecurityPolicyRules = value
    }

    @JvmName("jyjkdhewcjsupnkr")
    public suspend fun authorizeSecurityPolicyRules(vararg values: Output<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>) {
        this.authorizeSecurityPolicyRules = Output.all(values.asList())
    }

    /**
     * @param values The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("jqooaasomlkfkmfk")
    public suspend fun authorizeSecurityPolicyRules(values: List<Output<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>>) {
        this.authorizeSecurityPolicyRules = Output.all(values)
    }

    /**
     * @param value Whether to enable local camera redirection. Valid values: `on`, `off`.
     */
    @JvmName("ssgckaepwitnwxnb")
    public suspend fun cameraRedirect(`value`: Output<String>) {
        this.cameraRedirect = value
    }

    /**
     * @param value The clipboard policy. Valid values: `off`, `read`, `readwrite`.
     */
    @JvmName("fkeealexjtsrgrco")
    public suspend fun clipboard(`value`: Output<String>) {
        this.clipboard = value
    }

    /**
     * @param value The list of domain.
     */
    @JvmName("voomttiqtsxvijqb")
    public suspend fun domainList(`value`: Output<String>) {
        this.domainList = value
    }

    /**
     * @param value The access of html5. Valid values: `off`, `on`.
     */
    @JvmName("eaqjaadetfxxaitd")
    public suspend fun htmlAccess(`value`: Output<String>) {
        this.htmlAccess = value
    }

    /**
     * @param value The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
     */
    @JvmName("hertdamvfimcsvxm")
    public suspend fun htmlFileTransfer(`value`: Output<String>) {
        this.htmlFileTransfer = value
    }

    /**
     * @param value Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
     */
    @JvmName("uwkbbhriefsniuno")
    public suspend fun localDrive(`value`: Output<String>) {
        this.localDrive = value
    }

    /**
     * @param value The name of policy group.
     */
    @JvmName("kosakhtuilupdmrl")
    public suspend fun policyGroupName(`value`: Output<String>) {
        this.policyGroupName = value
    }

    /**
     * @param value Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
     */
    @JvmName("yqknhoxojwpuynsh")
    public suspend fun recording(`value`: Output<String>) {
        this.recording = value
    }

    /**
     * @param value The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    @JvmName("cvnhpclnpdsjkita")
    public suspend fun recordingEndTime(`value`: Output<String>) {
        this.recordingEndTime = value
    }

    /**
     * @param value The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
     */
    @JvmName("usvivtxoudlgmxjh")
    public suspend fun recordingExpires(`value`: Output<Int>) {
        this.recordingExpires = value
    }

    /**
     * @param value The fps of recording. Valid values: `2`, `5`, `10`, `15`.
     */
    @JvmName("skghifwsuuvjnncj")
    public suspend fun recordingFps(`value`: Output<Int>) {
        this.recordingFps = value
    }

    /**
     * @param value The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    @JvmName("phqqgkjsiknqafqy")
    public suspend fun recordingStartTime(`value`: Output<String>) {
        this.recordingStartTime = value
    }

    /**
     * @param value The usb redirect policy. Valid values: `off`, `on`.
     */
    @JvmName("gayxvyfcmpnjkroy")
    public suspend fun usbRedirect(`value`: Output<String>) {
        this.usbRedirect = value
    }

    /**
     * @param value The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
     */
    @JvmName("owqvvbudxobjfwis")
    public suspend fun visualQuality(`value`: Output<String>) {
        this.visualQuality = value
    }

    /**
     * @param value The watermark policy. Valid values: `off`, `on`.
     */
    @JvmName("jtvrxxfiunprfejw")
    public suspend fun watermark(`value`: Output<String>) {
        this.watermark = value
    }

    /**
     * @param value The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
     */
    @JvmName("alqgllmvabhcnxwi")
    public suspend fun watermarkTransparency(`value`: Output<String>) {
        this.watermarkTransparency = value
    }

    /**
     * @param value The type of watemark. Valid values: `EndUserId`, `HostName`.
     */
    @JvmName("aynlxaohocacgtrn")
    public suspend fun watermarkType(`value`: Output<String>) {
        this.watermarkType = value
    }

    /**
     * @param value The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("ckyhopcudngislra")
    public suspend fun authorizeAccessPolicyRules(`value`: List<EcdPolicyGroupAuthorizeAccessPolicyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizeAccessPolicyRules = mapped
    }

    /**
     * @param argument The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("rlubkcftifkybhqv")
    public suspend fun authorizeAccessPolicyRules(argument: List<suspend EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizeAccessPolicyRules = mapped
    }

    /**
     * @param argument The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("itmpptfxcucfnswj")
    public suspend fun authorizeAccessPolicyRules(vararg argument: suspend EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizeAccessPolicyRules = mapped
    }

    /**
     * @param argument The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("qlvvkqpiiylvvsbs")
    public suspend fun authorizeAccessPolicyRules(argument: suspend EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizeAccessPolicyRules = mapped
    }

    /**
     * @param values The rule of authorize access rule. See `authorize_access_policy_rules` below.
     */
    @JvmName("olwuvhedypxsbuvx")
    public suspend fun authorizeAccessPolicyRules(vararg values: EcdPolicyGroupAuthorizeAccessPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizeAccessPolicyRules = mapped
    }

    /**
     * @param value The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("fwcyleehbqbkokld")
    public suspend fun authorizeSecurityPolicyRules(`value`: List<EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizeSecurityPolicyRules = mapped
    }

    /**
     * @param argument The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("dgpdlioxiqmdpfyn")
    public suspend fun authorizeSecurityPolicyRules(argument: List<suspend EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizeSecurityPolicyRules = mapped
    }

    /**
     * @param argument The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("hymwtbtowjumrhdl")
    public suspend fun authorizeSecurityPolicyRules(vararg argument: suspend EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizeSecurityPolicyRules = mapped
    }

    /**
     * @param argument The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("oadaclesywrfamrj")
    public suspend fun authorizeSecurityPolicyRules(argument: suspend EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizeSecurityPolicyRules = mapped
    }

    /**
     * @param values The policy rule. See `authorize_security_policy_rules` below.
     */
    @JvmName("irpdkjkttosbpatt")
    public suspend fun authorizeSecurityPolicyRules(vararg values: EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizeSecurityPolicyRules = mapped
    }

    /**
     * @param value Whether to enable local camera redirection. Valid values: `on`, `off`.
     */
    @JvmName("fwanoasnmlpxntuu")
    public suspend fun cameraRedirect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cameraRedirect = mapped
    }

    /**
     * @param value The clipboard policy. Valid values: `off`, `read`, `readwrite`.
     */
    @JvmName("xqqqxwyahcobrcyi")
    public suspend fun clipboard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clipboard = mapped
    }

    /**
     * @param value The list of domain.
     */
    @JvmName("lgirpetruogqtmft")
    public suspend fun domainList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainList = mapped
    }

    /**
     * @param value The access of html5. Valid values: `off`, `on`.
     */
    @JvmName("xnrjtntytyonhgld")
    public suspend fun htmlAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.htmlAccess = mapped
    }

    /**
     * @param value The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
     */
    @JvmName("slmwqvqwmmueewge")
    public suspend fun htmlFileTransfer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.htmlFileTransfer = mapped
    }

    /**
     * @param value Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
     */
    @JvmName("bpvvxblnofgohyys")
    public suspend fun localDrive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localDrive = mapped
    }

    /**
     * @param value The name of policy group.
     */
    @JvmName("vmqojfjrsmodawgr")
    public suspend fun policyGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyGroupName = mapped
    }

    /**
     * @param value Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
     */
    @JvmName("dujhysiwmxiqtxwe")
    public suspend fun recording(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recording = mapped
    }

    /**
     * @param value The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    @JvmName("lcbhacgrtojkxggm")
    public suspend fun recordingEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingEndTime = mapped
    }

    /**
     * @param value The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
     */
    @JvmName("ivuvfndpbrusvbcy")
    public suspend fun recordingExpires(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingExpires = mapped
    }

    /**
     * @param value The fps of recording. Valid values: `2`, `5`, `10`, `15`.
     */
    @JvmName("kswtvqawvqlwpdhx")
    public suspend fun recordingFps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingFps = mapped
    }

    /**
     * @param value The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
     */
    @JvmName("kopevifdmugsifxc")
    public suspend fun recordingStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingStartTime = mapped
    }

    /**
     * @param value The usb redirect policy. Valid values: `off`, `on`.
     */
    @JvmName("vwtxjcwskifmgykd")
    public suspend fun usbRedirect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usbRedirect = mapped
    }

    /**
     * @param value The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
     */
    @JvmName("vqwibnrvwlwbqwsd")
    public suspend fun visualQuality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visualQuality = mapped
    }

    /**
     * @param value The watermark policy. Valid values: `off`, `on`.
     */
    @JvmName("xptjbslafetlihfs")
    public suspend fun watermark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watermark = mapped
    }

    /**
     * @param value The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
     */
    @JvmName("myiylexpbnaikcig")
    public suspend fun watermarkTransparency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watermarkTransparency = mapped
    }

    /**
     * @param value The type of watemark. Valid values: `EndUserId`, `HostName`.
     */
    @JvmName("fiepjioiojhrgknt")
    public suspend fun watermarkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watermarkType = mapped
    }

    internal fun build(): EcdPolicyGroupArgs = EcdPolicyGroupArgs(
        authorizeAccessPolicyRules = authorizeAccessPolicyRules,
        authorizeSecurityPolicyRules = authorizeSecurityPolicyRules,
        cameraRedirect = cameraRedirect,
        clipboard = clipboard,
        domainList = domainList,
        htmlAccess = htmlAccess,
        htmlFileTransfer = htmlFileTransfer,
        localDrive = localDrive,
        policyGroupName = policyGroupName,
        recording = recording,
        recordingEndTime = recordingEndTime,
        recordingExpires = recordingExpires,
        recordingFps = recordingFps,
        recordingStartTime = recordingStartTime,
        usbRedirect = usbRedirect,
        visualQuality = visualQuality,
        watermark = watermark,
        watermarkTransparency = watermarkTransparency,
        watermarkType = watermarkType,
    )
}
