@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.EdsFunctions.getAdConnectorDirectoriesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getAdConnectorOfficeSitesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getBundlesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getCommandsPlain
import com.pulumi.alicloud.eds.EdsFunctions.getCustomPropertiesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getDesktopTypesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getDesktopsPlain
import com.pulumi.alicloud.eds.EdsFunctions.getImagesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getNasFileSystemsPlain
import com.pulumi.alicloud.eds.EdsFunctions.getNetworkPackagesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getPolicyGroupsPlain
import com.pulumi.alicloud.eds.EdsFunctions.getRamDirectoriesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getSimpleOfficeSitesPlain
import com.pulumi.alicloud.eds.EdsFunctions.getSnapshotsPlain
import com.pulumi.alicloud.eds.EdsFunctions.getUsersPlain
import com.pulumi.alicloud.eds.EdsFunctions.getZonesPlain
import com.pulumi.alicloud.eds.kotlin.inputs.GetAdConnectorDirectoriesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetAdConnectorDirectoriesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetAdConnectorOfficeSitesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetAdConnectorOfficeSitesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetBundlesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetBundlesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetCommandsPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetCommandsPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetCustomPropertiesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetCustomPropertiesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetDesktopTypesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetDesktopTypesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetDesktopsPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetDesktopsPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetImagesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetImagesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetNasFileSystemsPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetNasFileSystemsPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetNetworkPackagesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetNetworkPackagesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetPolicyGroupsPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetPolicyGroupsPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetRamDirectoriesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetRamDirectoriesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetSimpleOfficeSitesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetSimpleOfficeSitesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetSnapshotsPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.eds.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorDirectoriesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorOfficeSitesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetBundlesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetCommandsResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetCustomPropertiesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopTypesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopsResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetImagesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetNasFileSystemsResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetNetworkPackagesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetPolicyGroupsResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetRamDirectoriesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetSimpleOfficeSitesResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetSnapshotsResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetUsersResult
import com.pulumi.alicloud.eds.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorDirectoriesResult.Companion.toKotlin as getAdConnectorDirectoriesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorOfficeSitesResult.Companion.toKotlin as getAdConnectorOfficeSitesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetBundlesResult.Companion.toKotlin as getBundlesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetCommandsResult.Companion.toKotlin as getCommandsResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetCustomPropertiesResult.Companion.toKotlin as getCustomPropertiesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopTypesResult.Companion.toKotlin as getDesktopTypesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopsResult.Companion.toKotlin as getDesktopsResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetImagesResult.Companion.toKotlin as getImagesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetNasFileSystemsResult.Companion.toKotlin as getNasFileSystemsResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetNetworkPackagesResult.Companion.toKotlin as getNetworkPackagesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetPolicyGroupsResult.Companion.toKotlin as getPolicyGroupsResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetRamDirectoriesResult.Companion.toKotlin as getRamDirectoriesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetSimpleOfficeSitesResult.Companion.toKotlin as getSimpleOfficeSitesResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetSnapshotsResult.Companion.toKotlin as getSnapshotsResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin
import com.pulumi.alicloud.eds.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object EdsFunctions {
    /**
     * This data source provides the Ecd Ad Connector Directories of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.174.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getAdConnectorDirectories({
     *     ids: ["example_id"],
     * });
     * export const ecdAdConnectorDirectoryId1 = ids.then(ids => ids.directories?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_ad_connector_directories(ids=["example_id"])
     * pulumi.export("ecdAdConnectorDirectoryId1", ids.directories[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetAdConnectorDirectories.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdAdConnectorDirectoryId1"] = ids&#46;Apply(getAdConnectorDirectoriesResult => getAdConnectorDirectoriesResult&#46;Directories[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetAdConnectorDirectories(ctx, &eds.GetAdConnectorDirectoriesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdAdConnectorDirectoryId1", ids.Directories[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetAdConnectorDirectoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getAdConnectorDirectories(GetAdConnectorDirectoriesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecdAdConnectorDirectoryId1", ids.applyValue(getAdConnectorDirectoriesResult -> getAdConnectorDirectoriesResult.directories()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getAdConnectorDirectories
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   ecdAdConnectorDirectoryId1: ${ids.directories[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAdConnectorDirectories.
     * @return A collection of values returned by getAdConnectorDirectories.
     */
    public suspend fun getAdConnectorDirectories(argument: GetAdConnectorDirectoriesPlainArgs): GetAdConnectorDirectoriesResult =
        getAdConnectorDirectoriesResultToKotlin(getAdConnectorDirectoriesPlain(argument.toJava()).await())

    /**
     * @see [getAdConnectorDirectories].
     * @param ids A list of Ad Connector Directory IDs.
     * @param nameRegex A regex string to filter results by Ad Connector Directory name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of directory. Valid values: `REGISTERING`, `REGISTERED`, `DEREGISTERING`, `NEEDCONFIGTRUST`, `CONFIGTRUSTFAILED`, `DEREGISTERED`, `ERROR`, `CONFIGTRUSTING`, `NEEDCONFIGUSER`.
     * @return A collection of values returned by getAdConnectorDirectories.
     */
    public suspend fun getAdConnectorDirectories(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAdConnectorDirectoriesResult {
        val argument = GetAdConnectorDirectoriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAdConnectorDirectoriesResultToKotlin(getAdConnectorDirectoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdConnectorDirectories].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetAdConnectorDirectoriesPlainArgs].
     * @return A collection of values returned by getAdConnectorDirectories.
     */
    public suspend fun getAdConnectorDirectories(argument: suspend GetAdConnectorDirectoriesPlainArgsBuilder.() -> Unit): GetAdConnectorDirectoriesResult {
        val builder = GetAdConnectorDirectoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdConnectorDirectoriesResultToKotlin(getAdConnectorDirectoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Ad Connector Office Sites of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.176.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getAdConnectorOfficeSites({});
     * export const ecdAdConnectorOfficeSiteId1 = ids.then(ids => ids.sites?.[0]?.id);
     * const nameRegex = alicloud.eds.getAdConnectorOfficeSites({
     *     nameRegex: "^my-AdConnectorOfficeSite",
     * });
     * export const ecdAdConnectorOfficeSiteId2 = nameRegex.then(nameRegex => nameRegex.sites?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_ad_connector_office_sites()
     * pulumi.export("ecdAdConnectorOfficeSiteId1", ids.sites[0].id)
     * name_regex = alicloud.eds.get_ad_connector_office_sites(name_regex="^my-AdConnectorOfficeSite")
     * pulumi.export("ecdAdConnectorOfficeSiteId2", name_regex.sites[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetAdConnectorOfficeSites.Invoke();
     *     var nameRegex = AliCloud.Eds.GetAdConnectorOfficeSites.Invoke(new()
     *     {
     *         NameRegex = "^my-AdConnectorOfficeSite",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdAdConnectorOfficeSiteId1"] = ids&#46;Apply(getAdConnectorOfficeSitesResult => getAdConnectorOfficeSitesResult&#46;Sites[0]?.Id),
     *         ["ecdAdConnectorOfficeSiteId2"] = nameRegex&#46;Apply(getAdConnectorOfficeSitesResult => getAdConnectorOfficeSitesResult&#46;Sites[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetAdConnectorOfficeSites(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdAdConnectorOfficeSiteId1", ids.Sites[0].Id)
     * 		nameRegex, err := eds.GetAdConnectorOfficeSites(ctx, &eds.GetAdConnectorOfficeSitesArgs{
     * 			NameRegex: pulumi.StringRef("^my-AdConnectorOfficeSite"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdAdConnectorOfficeSiteId2", nameRegex.Sites[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetAdConnectorOfficeSitesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getAdConnectorOfficeSites();
     *         ctx.export("ecdAdConnectorOfficeSiteId1", ids.applyValue(getAdConnectorOfficeSitesResult -> getAdConnectorOfficeSitesResult.sites()[0].id()));
     *         final var nameRegex = EdsFunctions.getAdConnectorOfficeSites(GetAdConnectorOfficeSitesArgs.builder()
     *             .nameRegex("^my-AdConnectorOfficeSite")
     *             .build());
     *         ctx.export("ecdAdConnectorOfficeSiteId2", nameRegex.applyValue(getAdConnectorOfficeSitesResult -> getAdConnectorOfficeSitesResult.sites()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getAdConnectorOfficeSites
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getAdConnectorOfficeSites
     *       Arguments:
     *         nameRegex: ^my-AdConnectorOfficeSite
     * outputs:
     *   ecdAdConnectorOfficeSiteId1: ${ids.sites[0].id}
     *   ecdAdConnectorOfficeSiteId2: ${nameRegex.sites[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAdConnectorOfficeSites.
     * @return A collection of values returned by getAdConnectorOfficeSites.
     */
    public suspend fun getAdConnectorOfficeSites(argument: GetAdConnectorOfficeSitesPlainArgs): GetAdConnectorOfficeSitesResult =
        getAdConnectorOfficeSitesResultToKotlin(getAdConnectorOfficeSitesPlain(argument.toJava()).await())

    /**
     * @see [getAdConnectorOfficeSites].
     * @param ids A list of Ad Connector Office Site IDs.
     * @param nameRegex A regex string to filter results by Ad Connector Office Site name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The workspace status. Valid values:
     * - `REGISTERING`: The workspace is being registered.
     * - `REGISTERED`: The workspace is registered.
     * - `DEREGISTERING`: The workspace is being deregistered.
     * - `DEREGISTERED`: The workspace is deregistered.
     * - `ERROR`: The configurations of the workspace are invalid.
     * - `NEEDCONFIGTRUST`: The trust relationship needs to be configured.
     * - `NEEDCONFIGUSER`: Users need to be configured.
     * - `CONFIGTRUSTING`: The trust relationship is being configured.
     * - `CONFIGTRUSTFAILED`: The trust relationship fails to be configured.
     * @return A collection of values returned by getAdConnectorOfficeSites.
     */
    public suspend fun getAdConnectorOfficeSites(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAdConnectorOfficeSitesResult {
        val argument = GetAdConnectorOfficeSitesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAdConnectorOfficeSitesResultToKotlin(getAdConnectorOfficeSitesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdConnectorOfficeSites].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetAdConnectorOfficeSitesPlainArgs].
     * @return A collection of values returned by getAdConnectorOfficeSites.
     */
    public suspend fun getAdConnectorOfficeSites(argument: suspend GetAdConnectorOfficeSitesPlainArgsBuilder.() -> Unit): GetAdConnectorOfficeSitesResult {
        val builder = GetAdConnectorOfficeSitesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdConnectorOfficeSitesResultToKotlin(getAdConnectorOfficeSitesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd bundles of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eds.getBundles({
     *     bundleType: "SYSTEM",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.get_bundles(bundle_type="SYSTEM")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eds.GetBundles.Invoke(new()
     *     {
     *         BundleType = "SYSTEM",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eds.GetBundles(ctx, &eds.GetBundlesArgs{
     * 			BundleType: pulumi.StringRef("SYSTEM"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetBundlesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EdsFunctions.getBundles(GetBundlesArgs.builder()
     *             .bundleType("SYSTEM")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getBundles
     *       Arguments:
     *         bundleType: SYSTEM
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBundles.
     * @return A collection of values returned by getBundles.
     */
    public suspend fun getBundles(argument: GetBundlesPlainArgs): GetBundlesResult =
        getBundlesResultToKotlin(getBundlesPlain(argument.toJava()).await())

    /**
     * @see [getBundles].
     * @param bundleIds
     * @param bundleType The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
     * @param ids A list of Bundle IDs.
     * @param nameRegex A regex string to filter results by Bundle name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBundles.
     */
    public suspend fun getBundles(
        bundleIds: List<String>? = null,
        bundleType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetBundlesResult {
        val argument = GetBundlesPlainArgs(
            bundleIds = bundleIds,
            bundleType = bundleType,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getBundlesResultToKotlin(getBundlesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBundles].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetBundlesPlainArgs].
     * @return A collection of values returned by getBundles.
     */
    public suspend fun getBundles(argument: suspend GetBundlesPlainArgsBuilder.() -> Unit): GetBundlesResult {
        val builder = GetBundlesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBundlesResultToKotlin(getBundlesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Commands of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
     *     cidrBlock: "172.16.0.0/12",
     *     desktopAccessType: "Internet",
     *     officeSiteName: "your_office_site_name",
     * });
     * const default = alicloud.eds.getBundles({
     *     bundleType: "SYSTEM",
     *     nameRegex: "windows",
     * });
     * const defaultEcdPolicyGroup = new alicloud.eds.EcdPolicyGroup("default", {
     *     policyGroupName: "your_policy_group_name",
     *     clipboard: "readwrite",
     *     localDrive: "read",
     *     authorizeAccessPolicyRules: [{
     *         description: "example_value",
     *         cidrIp: "1.2.3.4/24",
     *     }],
     *     authorizeSecurityPolicyRules: [{
     *         type: "inflow",
     *         policy: "accept",
     *         description: "example_value",
     *         portRange: "80/80",
     *         ipProtocol: "TCP",
     *         priority: "1",
     *         cidrIp: "0.0.0.0/0",
     *     }],
     * });
     * const defaultDesktop = new alicloud.eds.Desktop("default", {
     *     officeSiteId: defaultSimpleOfficeSite.id,
     *     policyGroupId: defaultEcdPolicyGroup.id,
     *     bundleId: _default.then(_default => _default.bundles?.[0]?.id),
     *     desktopName: name,
     * });
     * const defaultCommand = new alicloud.eds.Command("default", {
     *     commandContent: "ipconfig",
     *     commandType: "RunPowerShellScript",
     *     desktopId: defaultDesktop.id,
     * });
     * const ids = alicloud.eds.getCommands({});
     * export const ecdCommandId1 = ids.then(ids => ids.commands?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
     *     cidr_block="172.16.0.0/12",
     *     desktop_access_type="Internet",
     *     office_site_name="your_office_site_name")
     * default = alicloud.eds.get_bundles(bundle_type="SYSTEM",
     *     name_regex="windows")
     * default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("default",
     *     policy_group_name="your_policy_group_name",
     *     clipboard="readwrite",
     *     local_drive="read",
     *     authorize_access_policy_rules=[{
     *         "description": "example_value",
     *         "cidr_ip": "1.2.3.4/24",
     *     }],
     *     authorize_security_policy_rules=[{
     *         "type": "inflow",
     *         "policy": "accept",
     *         "description": "example_value",
     *         "port_range": "80/80",
     *         "ip_protocol": "TCP",
     *         "priority": "1",
     *         "cidr_ip": "0.0.0.0/0",
     *     }])
     * default_desktop = alicloud.eds.Desktop("default",
     *     office_site_id=default_simple_office_site.id,
     *     policy_group_id=default_ecd_policy_group.id,
     *     bundle_id=default.bundles[0].id,
     *     desktop_name=name)
     * default_command = alicloud.eds.Command("default",
     *     command_content="ipconfig",
     *     command_type="RunPowerShellScript",
     *     desktop_id=default_desktop.id)
     * ids = alicloud.eds.get_commands()
     * pulumi.export("ecdCommandId1", ids.commands[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         DesktopAccessType = "Internet",
     *         OfficeSiteName = "your_office_site_name",
     *     });
     *     var @default = AliCloud.Eds.GetBundles.Invoke(new()
     *     {
     *         BundleType = "SYSTEM",
     *         NameRegex = "windows",
     *     });
     *     var defaultEcdPolicyGroup = new AliCloud.Eds.EcdPolicyGroup("default", new()
     *     {
     *         PolicyGroupName = "your_policy_group_name",
     *         Clipboard = "readwrite",
     *         LocalDrive = "read",
     *         AuthorizeAccessPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
     *             {
     *                 Description = "example_value",
     *                 CidrIp = "1.2.3.4/24",
     *             },
     *         },
     *         AuthorizeSecurityPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
     *             {
     *                 Type = "inflow",
     *                 Policy = "accept",
     *                 Description = "example_value",
     *                 PortRange = "80/80",
     *                 IpProtocol = "TCP",
     *                 Priority = "1",
     *                 CidrIp = "0.0.0.0/0",
     *             },
     *         },
     *     });
     *     var defaultDesktop = new AliCloud.Eds.Desktop("default", new()
     *     {
     *         OfficeSiteId = defaultSimpleOfficeSite.Id,
     *         PolicyGroupId = defaultEcdPolicyGroup.Id,
     *         BundleId = @default.Apply(@default => @default.Apply(getBundlesResult => getBundlesResult.Bundles[0]?.Id)),
     *         DesktopName = name,
     *     });
     *     var defaultCommand = new AliCloud.Eds.Command("default", new()
     *     {
     *         CommandContent = "ipconfig",
     *         CommandType = "RunPowerShellScript",
     *         DesktopId = defaultDesktop.Id,
     *     });
     *     var ids = AliCloud.Eds.GetCommands.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdCommandId1"] = ids&#46;Apply(getCommandsResult => getCommandsResult&#46;Commands[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
     * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
     * 			DesktopAccessType: pulumi.String("Internet"),
     * 			OfficeSiteName:    pulumi.String("your_office_site_name"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_default, err := eds.GetBundles(ctx, &eds.GetBundlesArgs{
     * 			BundleType: pulumi.StringRef("SYSTEM"),
     * 			NameRegex:  pulumi.StringRef("windows"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEcdPolicyGroup, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
     * 			PolicyGroupName: pulumi.String("your_policy_group_name"),
     * 			Clipboard:       pulumi.String("readwrite"),
     * 			LocalDrive:      pulumi.String("read"),
     * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
     * 					Description: pulumi.String("example_value"),
     * 					CidrIp:      pulumi.String("1.2.3.4/24"),
     * 				},
     * 			},
     * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
     * 					Type:        pulumi.String("inflow"),
     * 					Policy:      pulumi.String("accept"),
     * 					Description: pulumi.String("example_value"),
     * 					PortRange:   pulumi.String("80/80"),
     * 					IpProtocol:  pulumi.String("TCP"),
     * 					Priority:    pulumi.String("1"),
     * 					CidrIp:      pulumi.String("0.0.0.0/0"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultDesktop, err := eds.NewDesktop(ctx, "default", &eds.DesktopArgs{
     * 			OfficeSiteId:  defaultSimpleOfficeSite.ID(),
     * 			PolicyGroupId: defaultEcdPolicyGroup.ID(),
     * 			BundleId:      pulumi.String(_default.Bundles[0].Id),
     * 			DesktopName:   pulumi.Any(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = eds.NewCommand(ctx, "default", &eds.CommandArgs{
     * 			CommandContent: pulumi.String("ipconfig"),
     * 			CommandType:    pulumi.String("RunPowerShellScript"),
     * 			DesktopId:      defaultDesktop.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := eds.GetCommands(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdCommandId1", ids.Commands[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.SimpleOfficeSite;
     * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetBundlesArgs;
     * import com.pulumi.alicloud.eds.EcdPolicyGroup;
     * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.Desktop;
     * import com.pulumi.alicloud.eds.DesktopArgs;
     * import com.pulumi.alicloud.eds.Command;
     * import com.pulumi.alicloud.eds.CommandArgs;
     * import com.pulumi.alicloud.eds.inputs.GetCommandsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .desktopAccessType("Internet")
     *             .officeSiteName("your_office_site_name")
     *             .build());
     *         final var default = EdsFunctions.getBundles(GetBundlesArgs.builder()
     *             .bundleType("SYSTEM")
     *             .nameRegex("windows")
     *             .build());
     *         var defaultEcdPolicyGroup = new EcdPolicyGroup("defaultEcdPolicyGroup", EcdPolicyGroupArgs.builder()
     *             .policyGroupName("your_policy_group_name")
     *             .clipboard("readwrite")
     *             .localDrive("read")
     *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
     *                 .description("example_value")
     *                 .cidrIp("1.2.3.4/24")
     *                 .build())
     *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
     *                 .type("inflow")
     *                 .policy("accept")
     *                 .description("example_value")
     *                 .portRange("80/80")
     *                 .ipProtocol("TCP")
     *                 .priority("1")
     *                 .cidrIp("0.0.0.0/0")
     *                 .build())
     *             .build());
     *         var defaultDesktop = new Desktop("defaultDesktop", DesktopArgs.builder()
     *             .officeSiteId(defaultSimpleOfficeSite.id())
     *             .policyGroupId(defaultEcdPolicyGroup.id())
     *             .bundleId(default_.bundles()[0].id())
     *             .desktopName(name)
     *             .build());
     *         var defaultCommand = new Command("defaultCommand", CommandArgs.builder()
     *             .commandContent("ipconfig")
     *             .commandType("RunPowerShellScript")
     *             .desktopId(defaultDesktop.id())
     *             .build());
     *         final var ids = EdsFunctions.getCommands();
     *         ctx.export("ecdCommandId1", ids.applyValue(getCommandsResult -> getCommandsResult.commands()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultSimpleOfficeSite:
     *     type: alicloud:eds:SimpleOfficeSite
     *     name: default
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       desktopAccessType: Internet
     *       officeSiteName: your_office_site_name
     *   defaultEcdPolicyGroup:
     *     type: alicloud:eds:EcdPolicyGroup
     *     name: default
     *     properties:
     *       policyGroupName: your_policy_group_name
     *       clipboard: readwrite
     *       localDrive: read
     *       authorizeAccessPolicyRules:
     *         - description: example_value
     *           cidrIp: 1.2.3.4/24
     *       authorizeSecurityPolicyRules:
     *         - type: inflow
     *           policy: accept
     *           description: example_value
     *           portRange: 80/80
     *           ipProtocol: TCP
     *           priority: '1'
     *           cidrIp: 0.0.0.0/0
     *   defaultDesktop:
     *     type: alicloud:eds:Desktop
     *     name: default
     *     properties:
     *       officeSiteId: ${defaultSimpleOfficeSite.id}
     *       policyGroupId: ${defaultEcdPolicyGroup.id}
     *       bundleId: ${default.bundles[0].id}
     *       desktopName: ${name}
     *   defaultCommand:
     *     type: alicloud:eds:Command
     *     name: default
     *     properties:
     *       commandContent: ipconfig
     *       commandType: RunPowerShellScript
     *       desktopId: ${defaultDesktop.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getBundles
     *       Arguments:
     *         bundleType: SYSTEM
     *         nameRegex: windows
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getCommands
     *       Arguments: {}
     * outputs:
     *   ecdCommandId1: ${ids.commands[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCommands.
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(argument: GetCommandsPlainArgs): GetCommandsResult =
        getCommandsResultToKotlin(getCommandsPlain(argument.toJava()).await())

    /**
     * @see [getCommands].
     * @param commandType The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
     * @param contentEncoding That Returns the Data Encoding Method. Valid values: `Base64`, `PlainText`.
     * @param desktopId The desktop id of the Desktop.
     * @param ids A list of Command IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(
        commandType: String? = null,
        contentEncoding: String? = null,
        desktopId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetCommandsResult {
        val argument = GetCommandsPlainArgs(
            commandType = commandType,
            contentEncoding = contentEncoding,
            desktopId = desktopId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getCommandsResultToKotlin(getCommandsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommands].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetCommandsPlainArgs].
     * @return A collection of values returned by getCommands.
     */
    public suspend fun getCommands(argument: suspend GetCommandsPlainArgsBuilder.() -> Unit): GetCommandsResult {
        val builder = GetCommandsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommandsResultToKotlin(getCommandsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Custom Properties of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.176.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getCustomProperties({
     *     ids: ["example_id"],
     * });
     * export const ecdCustomPropertyId1 = ids.then(ids => ids.properties?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_custom_properties(ids=["example_id"])
     * pulumi.export("ecdCustomPropertyId1", ids.properties[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetCustomProperties.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdCustomPropertyId1"] = ids&#46;Apply(getCustomPropertiesResult => getCustomPropertiesResult&#46;Properties[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetCustomProperties(ctx, &eds.GetCustomPropertiesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdCustomPropertyId1", ids.Properties[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetCustomPropertiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getCustomProperties(GetCustomPropertiesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecdCustomPropertyId1", ids.applyValue(getCustomPropertiesResult -> getCustomPropertiesResult.properties()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getCustomProperties
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   ecdCustomPropertyId1: ${ids.properties[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomProperties.
     * @return A collection of values returned by getCustomProperties.
     */
    public suspend fun getCustomProperties(argument: GetCustomPropertiesPlainArgs): GetCustomPropertiesResult =
        getCustomPropertiesResultToKotlin(getCustomPropertiesPlain(argument.toJava()).await())

    /**
     * @see [getCustomProperties].
     * @param ids A list of Custom Property IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getCustomProperties.
     */
    public suspend fun getCustomProperties(ids: List<String>? = null, outputFile: String? = null): GetCustomPropertiesResult {
        val argument = GetCustomPropertiesPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getCustomPropertiesResultToKotlin(getCustomPropertiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomProperties].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetCustomPropertiesPlainArgs].
     * @return A collection of values returned by getCustomProperties.
     */
    public suspend fun getCustomProperties(argument: suspend GetCustomPropertiesPlainArgsBuilder.() -> Unit): GetCustomPropertiesResult {
        val builder = GetCustomPropertiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomPropertiesResultToKotlin(getCustomPropertiesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Desktop Types of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.170.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getDesktopTypes({
     *     instanceTypeFamily: "eds.hf",
     * });
     * export const ecdDesktopTypeId1 = ids.then(ids => ids.types?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_desktop_types(instance_type_family="eds.hf")
     * pulumi.export("ecdDesktopTypeId1", ids.types[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetDesktopTypes.Invoke(new()
     *     {
     *         InstanceTypeFamily = "eds.hf",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdDesktopTypeId1"] = ids&#46;Apply(getDesktopTypesResult => getDesktopTypesResult&#46;Types[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetDesktopTypes(ctx, &eds.GetDesktopTypesArgs{
     * 			InstanceTypeFamily: pulumi.StringRef("eds.hf"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdDesktopTypeId1", ids.Types[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetDesktopTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getDesktopTypes(GetDesktopTypesArgs.builder()
     *             .instanceTypeFamily("eds.hf")
     *             .build());
     *         ctx.export("ecdDesktopTypeId1", ids.applyValue(getDesktopTypesResult -> getDesktopTypesResult.types()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getDesktopTypes
     *       Arguments:
     *         instanceTypeFamily: eds.hf
     * outputs:
     *   ecdDesktopTypeId1: ${ids.types[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDesktopTypes.
     * @return A collection of values returned by getDesktopTypes.
     */
    public suspend fun getDesktopTypes(argument: GetDesktopTypesPlainArgs): GetDesktopTypesResult =
        getDesktopTypesResultToKotlin(getDesktopTypesPlain(argument.toJava()).await())

    /**
     * @see [getDesktopTypes].
     * @param cpuCount The CPU cores.
     * @param gpuCount The GPU cores.
     * @param ids A list of Desktop Type IDs.
     * @param instanceTypeFamily The Specification family. Valid values: `eds.graphics`, `eds.hf`, `eds.general`, `ecd.graphics`, `ecd.performance`, `ecd.advanced`, `ecd.basic`.
     * @param memorySize The Memory size. Unit: MiB.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `SUFFICIENT`.
     * @return A collection of values returned by getDesktopTypes.
     */
    public suspend fun getDesktopTypes(
        cpuCount: Int? = null,
        gpuCount: Double? = null,
        ids: List<String>? = null,
        instanceTypeFamily: String? = null,
        memorySize: Int? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetDesktopTypesResult {
        val argument = GetDesktopTypesPlainArgs(
            cpuCount = cpuCount,
            gpuCount = gpuCount,
            ids = ids,
            instanceTypeFamily = instanceTypeFamily,
            memorySize = memorySize,
            outputFile = outputFile,
            status = status,
        )
        return getDesktopTypesResultToKotlin(getDesktopTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDesktopTypes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetDesktopTypesPlainArgs].
     * @return A collection of values returned by getDesktopTypes.
     */
    public suspend fun getDesktopTypes(argument: suspend GetDesktopTypesPlainArgsBuilder.() -> Unit): GetDesktopTypesResult {
        val builder = GetDesktopTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDesktopTypesResultToKotlin(getDesktopTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Desktops of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
     *     cidrBlock: "172.16.0.0/12",
     *     desktopAccessType: "Internet",
     *     officeSiteName: "your_office_site_name",
     * });
     * const default = alicloud.eds.getBundles({
     *     bundleType: "SYSTEM",
     * });
     * const defaultEcdPolicyGroup = new alicloud.eds.EcdPolicyGroup("default", {
     *     policyGroupName: "your_policy_group_name",
     *     clipboard: "readwrite",
     *     localDrive: "read",
     *     authorizeAccessPolicyRules: [{
     *         description: "example_value",
     *         cidrIp: "1.2.3.4/24",
     *     }],
     *     authorizeSecurityPolicyRules: [{
     *         type: "inflow",
     *         policy: "accept",
     *         description: "example_value",
     *         portRange: "80/80",
     *         ipProtocol: "TCP",
     *         priority: "1",
     *         cidrIp: "0.0.0.0/0",
     *     }],
     * });
     * const defaultUser = new alicloud.eds.User("default", {
     *     endUserId: "your_end_user_id",
     *     email: "your_email",
     *     phone: "your_phone",
     *     password: "your_password",
     * });
     * const defaultDesktop = new alicloud.eds.Desktop("default", {
     *     officeSiteId: defaultSimpleOfficeSite.id,
     *     policyGroupId: defaultEcdPolicyGroup.id,
     *     bundleId: _default.then(_default => _default.bundles?.[0]?.id),
     *     desktopName: "your_desktop_name",
     *     endUserIds: [defaultUser&#46;id],
     * });
     * const ids = alicloud.eds.getDesktopsOutput({
     *     ids: [defaultDesktop&#46;id],
     * });
     * export const ecdDesktopId1 = ids.apply(ids => ids.desktops?.[0]?.id);
     * const nameRegex = defaultDesktop.desktopName.apply(desktopName => alicloud.eds.getDesktopsOutput({
     *     nameRegex: desktopName,
     * }));
     * export const ecdDesktopId2 = nameRegex.apply(nameRegex => nameRegex.desktops?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
     *     cidr_block="172.16.0.0/12",
     *     desktop_access_type="Internet",
     *     office_site_name="your_office_site_name")
     * default = alicloud.eds.get_bundles(bundle_type="SYSTEM")
     * default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("default",
     *     policy_group_name="your_policy_group_name",
     *     clipboard="readwrite",
     *     local_drive="read",
     *     authorize_access_policy_rules=[{
     *         "description": "example_value",
     *         "cidr_ip": "1.2.3.4/24",
     *     }],
     *     authorize_security_policy_rules=[{
     *         "type": "inflow",
     *         "policy": "accept",
     *         "description": "example_value",
     *         "port_range": "80/80",
     *         "ip_protocol": "TCP",
     *         "priority": "1",
     *         "cidr_ip": "0.0.0.0/0",
     *     }])
     * default_user = alicloud.eds.User("default",
     *     end_user_id="your_end_user_id",
     *     email="your_email",
     *     phone="your_phone",
     *     password="your_password")
     * default_desktop = alicloud.eds.Desktop("default",
     *     office_site_id=default_simple_office_site.id,
     *     policy_group_id=default_ecd_policy_group.id,
     *     bundle_id=default.bundles[0].id,
     *     desktop_name="your_desktop_name",
     *     end_user_ids=[default_user&#46;id])
     * ids = alicloud.eds.get_desktops_output(ids=[default_desktop&#46;id])
     * pulumi.export("ecdDesktopId1", ids.desktops[0].id)
     * name_regex = default_desktop.desktop_name.apply(lambda desktop_name: alicloud.eds.get_desktops_output(name_regex=desktop_name))
     * pulumi.export("ecdDesktopId2", name_regex.desktops[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         DesktopAccessType = "Internet",
     *         OfficeSiteName = "your_office_site_name",
     *     });
     *     var @default = AliCloud.Eds.GetBundles.Invoke(new()
     *     {
     *         BundleType = "SYSTEM",
     *     });
     *     var defaultEcdPolicyGroup = new AliCloud.Eds.EcdPolicyGroup("default", new()
     *     {
     *         PolicyGroupName = "your_policy_group_name",
     *         Clipboard = "readwrite",
     *         LocalDrive = "read",
     *         AuthorizeAccessPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
     *             {
     *                 Description = "example_value",
     *                 CidrIp = "1.2.3.4/24",
     *             },
     *         },
     *         AuthorizeSecurityPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
     *             {
     *                 Type = "inflow",
     *                 Policy = "accept",
     *                 Description = "example_value",
     *                 PortRange = "80/80",
     *                 IpProtocol = "TCP",
     *                 Priority = "1",
     *                 CidrIp = "0.0.0.0/0",
     *             },
     *         },
     *     });
     *     var defaultUser = new AliCloud.Eds.User("default", new()
     *     {
     *         EndUserId = "your_end_user_id",
     *         Email = "your_email",
     *         Phone = "your_phone",
     *         Password = "your_password",
     *     });
     *     var defaultDesktop = new AliCloud.Eds.Desktop("default", new()
     *     {
     *         OfficeSiteId = defaultSimpleOfficeSite.Id,
     *         PolicyGroupId = defaultEcdPolicyGroup.Id,
     *         BundleId = @default.Apply(@default => @default.Apply(getBundlesResult => getBundlesResult.Bundles[0]?.Id)),
     *         DesktopName = "your_desktop_name",
     *         EndUserIds = new[]
     *         {
     *             defaultUser.Id,
     *         },
     *     });
     *     var ids = AliCloud.Eds.GetDesktops.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultDesktop.Id,
     *         },
     *     });
     *     var nameRegex = AliCloud.Eds.GetDesktops.Invoke(new()
     *     {
     *         NameRegex = defaultDesktop.DesktopName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdDesktopId1"] = ids&#46;Apply(getDesktopsResult => getDesktopsResult&#46;Desktops[0]?.Id),
     *         ["ecdDesktopId2"] = nameRegex&#46;Apply(getDesktopsResult => getDesktopsResult&#46;Desktops[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
     * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
     * 			DesktopAccessType: pulumi.String("Internet"),
     * 			OfficeSiteName:    pulumi.String("your_office_site_name"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_default, err := eds.GetBundles(ctx, &eds.GetBundlesArgs{
     * 			BundleType: pulumi.StringRef("SYSTEM"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEcdPolicyGroup, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
     * 			PolicyGroupName: pulumi.String("your_policy_group_name"),
     * 			Clipboard:       pulumi.String("readwrite"),
     * 			LocalDrive:      pulumi.String("read"),
     * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
     * 					Description: pulumi.String("example_value"),
     * 					CidrIp:      pulumi.String("1.2.3.4/24"),
     * 				},
     * 			},
     * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
     * 					Type:        pulumi.String("inflow"),
     * 					Policy:      pulumi.String("accept"),
     * 					Description: pulumi.String("example_value"),
     * 					PortRange:   pulumi.String("80/80"),
     * 					IpProtocol:  pulumi.String("TCP"),
     * 					Priority:    pulumi.String("1"),
     * 					CidrIp:      pulumi.String("0.0.0.0/0"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultUser, err := eds.NewUser(ctx, "default", &eds.UserArgs{
     * 			EndUserId: pulumi.String("your_end_user_id"),
     * 			Email:     pulumi.String("your_email"),
     * 			Phone:     pulumi.String("your_phone"),
     * 			Password:  pulumi.String("your_password"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultDesktop, err := eds.NewDesktop(ctx, "default", &eds.DesktopArgs{
     * 			OfficeSiteId:  defaultSimpleOfficeSite.ID(),
     * 			PolicyGroupId: defaultEcdPolicyGroup.ID(),
     * 			BundleId:      pulumi.String(_default.Bundles[0].Id),
     * 			DesktopName:   pulumi.String("your_desktop_name"),
     * 			EndUserIds: pulumi.StringArray{
     * 				defaultUser.ID(),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := eds.GetDesktopsOutput(ctx, eds.GetDesktopsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultDesktop.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("ecdDesktopId1", ids.ApplyT(func(ids eds.GetDesktopsResult) (*string, error) {
     * 			return &ids.Desktops[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		nameRegex := defaultDesktop.DesktopName.ApplyT(func(desktopName *string) (eds.GetDesktopsResult, error) {
     * 			return eds.GetDesktopsResult(interface{}(eds.GetDesktopsOutput(ctx, eds.GetDesktopsOutputArgs{
     * 				NameRegex: desktopName,
     * 			}, nil))), nil
     * 		}).(eds.GetDesktopsResultOutput)
     * 		ctx.Export("ecdDesktopId2", nameRegex.ApplyT(func(nameRegex eds.GetDesktopsResult) (*string, error) {
     * 			return &nameRegex.Desktops[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.SimpleOfficeSite;
     * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetBundlesArgs;
     * import com.pulumi.alicloud.eds.EcdPolicyGroup;
     * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.User;
     * import com.pulumi.alicloud.eds.UserArgs;
     * import com.pulumi.alicloud.eds.Desktop;
     * import com.pulumi.alicloud.eds.DesktopArgs;
     * import com.pulumi.alicloud.eds.inputs.GetDesktopsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .desktopAccessType("Internet")
     *             .officeSiteName("your_office_site_name")
     *             .build());
     *         final var default = EdsFunctions.getBundles(GetBundlesArgs.builder()
     *             .bundleType("SYSTEM")
     *             .build());
     *         var defaultEcdPolicyGroup = new EcdPolicyGroup("defaultEcdPolicyGroup", EcdPolicyGroupArgs.builder()
     *             .policyGroupName("your_policy_group_name")
     *             .clipboard("readwrite")
     *             .localDrive("read")
     *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
     *                 .description("example_value")
     *                 .cidrIp("1.2.3.4/24")
     *                 .build())
     *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
     *                 .type("inflow")
     *                 .policy("accept")
     *                 .description("example_value")
     *                 .portRange("80/80")
     *                 .ipProtocol("TCP")
     *                 .priority("1")
     *                 .cidrIp("0.0.0.0/0")
     *                 .build())
     *             .build());
     *         var defaultUser = new User("defaultUser", UserArgs.builder()
     *             .endUserId("your_end_user_id")
     *             .email("your_email")
     *             .phone("your_phone")
     *             .password("your_password")
     *             .build());
     *         var defaultDesktop = new Desktop("defaultDesktop", DesktopArgs.builder()
     *             .officeSiteId(defaultSimpleOfficeSite.id())
     *             .policyGroupId(defaultEcdPolicyGroup.id())
     *             .bundleId(default_.bundles()[0].id())
     *             .desktopName("your_desktop_name")
     *             .endUserIds(defaultUser.id())
     *             .build());
     *         final var ids = EdsFunctions.getDesktops(GetDesktopsArgs.builder()
     *             .ids(defaultDesktop.id())
     *             .build());
     *         ctx.export("ecdDesktopId1", ids.applyValue(getDesktopsResult -> getDesktopsResult).applyValue(ids -> ids.applyValue(getDesktopsResult -> getDesktopsResult.desktops()[0].id())));
     *         final var nameRegex = EdsFunctions.getDesktops(GetDesktopsArgs.builder()
     *             .nameRegex(defaultDesktop.desktopName())
     *             .build());
     *         ctx.export("ecdDesktopId2", nameRegex.applyValue(getDesktopsResult -> getDesktopsResult).applyValue(nameRegex -> nameRegex.applyValue(getDesktopsResult -> getDesktopsResult.desktops()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultSimpleOfficeSite:
     *     type: alicloud:eds:SimpleOfficeSite
     *     name: default
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       desktopAccessType: Internet
     *       officeSiteName: your_office_site_name
     *   defaultEcdPolicyGroup:
     *     type: alicloud:eds:EcdPolicyGroup
     *     name: default
     *     properties:
     *       policyGroupName: your_policy_group_name
     *       clipboard: readwrite
     *       localDrive: read
     *       authorizeAccessPolicyRules:
     *         - description: example_value
     *           cidrIp: 1.2.3.4/24
     *       authorizeSecurityPolicyRules:
     *         - type: inflow
     *           policy: accept
     *           description: example_value
     *           portRange: 80/80
     *           ipProtocol: TCP
     *           priority: '1'
     *           cidrIp: 0.0.0.0/0
     *   defaultDesktop:
     *     type: alicloud:eds:Desktop
     *     name: default
     *     properties:
     *       officeSiteId: ${defaultSimpleOfficeSite.id}
     *       policyGroupId: ${defaultEcdPolicyGroup.id}
     *       bundleId: ${default.bundles[0].id}
     *       desktopName: your_desktop_name
     *       endUserIds:
     *         - ${defaultUser.id}
     *   defaultUser:
     *     type: alicloud:eds:User
     *     name: default
     *     properties:
     *       endUserId: your_end_user_id
     *       email: your_email
     *       phone: your_phone
     *       password: your_password
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getBundles
     *       Arguments:
     *         bundleType: SYSTEM
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getDesktops
     *       Arguments:
     *         ids:
     *           - ${defaultDesktop.id}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getDesktops
     *       Arguments:
     *         nameRegex: ${defaultDesktop.desktopName}
     * outputs:
     *   ecdDesktopId1: ${ids.desktops[0].id}
     *   ecdDesktopId2: ${nameRegex.desktops[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDesktops.
     * @return A collection of values returned by getDesktops.
     */
    public suspend fun getDesktops(argument: GetDesktopsPlainArgs): GetDesktopsResult =
        getDesktopsResultToKotlin(getDesktopsPlain(argument.toJava()).await())

    /**
     * @see [getDesktops].
     * @param desktopName The desktop name.
     * @param endUserIds
     * @param ids A list of Desktop IDs.
     * @param nameRegex A regex string to filter results by Desktop name.
     * @param officeSiteId The ID of the Simple Office Site.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyGroupId The policy group id of the Desktop.
     * @param status The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
     * @return A collection of values returned by getDesktops.
     */
    public suspend fun getDesktops(
        desktopName: String? = null,
        endUserIds: List<String>? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        officeSiteId: String? = null,
        outputFile: String? = null,
        policyGroupId: String? = null,
        status: String? = null,
    ): GetDesktopsResult {
        val argument = GetDesktopsPlainArgs(
            desktopName = desktopName,
            endUserIds = endUserIds,
            ids = ids,
            nameRegex = nameRegex,
            officeSiteId = officeSiteId,
            outputFile = outputFile,
            policyGroupId = policyGroupId,
            status = status,
        )
        return getDesktopsResultToKotlin(getDesktopsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDesktops].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetDesktopsPlainArgs].
     * @return A collection of values returned by getDesktops.
     */
    public suspend fun getDesktops(argument: suspend GetDesktopsPlainArgsBuilder.() -> Unit): GetDesktopsResult {
        val builder = GetDesktopsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDesktopsResultToKotlin(getDesktopsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Images of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
     *     cidrBlock: "172.16.0.0/12",
     *     desktopAccessType: "Internet",
     *     officeSiteName: "your_simple_office_site_name",
     * });
     * const default = alicloud.eds.getBundles({
     *     bundleType: "SYSTEM",
     * });
     * const defaultEcdPolicyGroup = new alicloud.eds.EcdPolicyGroup("default", {
     *     policyGroupName: "your_policy_group_name",
     *     clipboard: "readwrite",
     *     localDrive: "read",
     *     authorizeAccessPolicyRules: [{
     *         description: "example_value",
     *         cidrIp: "1.2.3.4/24",
     *     }],
     *     authorizeSecurityPolicyRules: [{
     *         type: "inflow",
     *         policy: "accept",
     *         description: "example_value",
     *         portRange: "80/80",
     *         ipProtocol: "TCP",
     *         priority: "1",
     *         cidrIp: "0.0.0.0/0",
     *     }],
     * });
     * const defaultDesktop = new alicloud.eds.Desktop("default", {
     *     officeSiteId: defaultSimpleOfficeSite.id,
     *     policyGroupId: defaultEcdPolicyGroup.id,
     *     bundleId: _default.then(_default => _default.bundles?.[1]?.id),
     *     desktopName: "your_desktop_name",
     * });
     * const defaultImage = new alicloud.eds.Image("default", {
     *     imageName: "your_image_name",
     *     desktopId: defaultDesktop.id,
     *     description: "example_value",
     * });
     * const ids = alicloud.eds.getImagesOutput({
     *     ids: [defaultImage&#46;id],
     * });
     * export const ecdImageId1 = ids.apply(ids => ids.images?.[0]?.id);
     * const nameRegex = defaultImage.imageName.apply(imageName => alicloud.eds.getImagesOutput({
     *     nameRegex: imageName,
     * }));
     * export const ecdImageId2 = nameRegex.apply(nameRegex => nameRegex.images?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
     *     cidr_block="172.16.0.0/12",
     *     desktop_access_type="Internet",
     *     office_site_name="your_simple_office_site_name")
     * default = alicloud.eds.get_bundles(bundle_type="SYSTEM")
     * default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("default",
     *     policy_group_name="your_policy_group_name",
     *     clipboard="readwrite",
     *     local_drive="read",
     *     authorize_access_policy_rules=[{
     *         "description": "example_value",
     *         "cidr_ip": "1.2.3.4/24",
     *     }],
     *     authorize_security_policy_rules=[{
     *         "type": "inflow",
     *         "policy": "accept",
     *         "description": "example_value",
     *         "port_range": "80/80",
     *         "ip_protocol": "TCP",
     *         "priority": "1",
     *         "cidr_ip": "0.0.0.0/0",
     *     }])
     * default_desktop = alicloud.eds.Desktop("default",
     *     office_site_id=default_simple_office_site.id,
     *     policy_group_id=default_ecd_policy_group.id,
     *     bundle_id=default.bundles[1].id,
     *     desktop_name="your_desktop_name")
     * default_image = alicloud.eds.Image("default",
     *     image_name="your_image_name",
     *     desktop_id=default_desktop.id,
     *     description="example_value")
     * ids = alicloud.eds.get_images_output(ids=[default_image&#46;id])
     * pulumi.export("ecdImageId1", ids.images[0].id)
     * name_regex = default_image.image_name.apply(lambda image_name: alicloud.eds.get_images_output(name_regex=image_name))
     * pulumi.export("ecdImageId2", name_regex.images[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         DesktopAccessType = "Internet",
     *         OfficeSiteName = "your_simple_office_site_name",
     *     });
     *     var @default = AliCloud.Eds.GetBundles.Invoke(new()
     *     {
     *         BundleType = "SYSTEM",
     *     });
     *     var defaultEcdPolicyGroup = new AliCloud.Eds.EcdPolicyGroup("default", new()
     *     {
     *         PolicyGroupName = "your_policy_group_name",
     *         Clipboard = "readwrite",
     *         LocalDrive = "read",
     *         AuthorizeAccessPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
     *             {
     *                 Description = "example_value",
     *                 CidrIp = "1.2.3.4/24",
     *             },
     *         },
     *         AuthorizeSecurityPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
     *             {
     *                 Type = "inflow",
     *                 Policy = "accept",
     *                 Description = "example_value",
     *                 PortRange = "80/80",
     *                 IpProtocol = "TCP",
     *                 Priority = "1",
     *                 CidrIp = "0.0.0.0/0",
     *             },
     *         },
     *     });
     *     var defaultDesktop = new AliCloud.Eds.Desktop("default", new()
     *     {
     *         OfficeSiteId = defaultSimpleOfficeSite.Id,
     *         PolicyGroupId = defaultEcdPolicyGroup.Id,
     *         BundleId = @default.Apply(@default => @default.Apply(getBundlesResult => getBundlesResult.Bundles[1]?.Id)),
     *         DesktopName = "your_desktop_name",
     *     });
     *     var defaultImage = new AliCloud.Eds.Image("default", new()
     *     {
     *         ImageName = "your_image_name",
     *         DesktopId = defaultDesktop.Id,
     *         Description = "example_value",
     *     });
     *     var ids = AliCloud.Eds.GetImages.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultImage.Id,
     *         },
     *     });
     *     var nameRegex = AliCloud.Eds.GetImages.Invoke(new()
     *     {
     *         NameRegex = defaultImage.ImageName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdImageId1"] = ids&#46;Apply(getImagesResult => getImagesResult&#46;Images[0]?.Id),
     *         ["ecdImageId2"] = nameRegex&#46;Apply(getImagesResult => getImagesResult&#46;Images[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
     * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
     * 			DesktopAccessType: pulumi.String("Internet"),
     * 			OfficeSiteName:    pulumi.String("your_simple_office_site_name"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_default, err := eds.GetBundles(ctx, &eds.GetBundlesArgs{
     * 			BundleType: pulumi.StringRef("SYSTEM"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultEcdPolicyGroup, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
     * 			PolicyGroupName: pulumi.String("your_policy_group_name"),
     * 			Clipboard:       pulumi.String("readwrite"),
     * 			LocalDrive:      pulumi.String("read"),
     * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
     * 					Description: pulumi.String("example_value"),
     * 					CidrIp:      pulumi.String("1.2.3.4/24"),
     * 				},
     * 			},
     * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
     * 					Type:        pulumi.String("inflow"),
     * 					Policy:      pulumi.String("accept"),
     * 					Description: pulumi.String("example_value"),
     * 					PortRange:   pulumi.String("80/80"),
     * 					IpProtocol:  pulumi.String("TCP"),
     * 					Priority:    pulumi.String("1"),
     * 					CidrIp:      pulumi.String("0.0.0.0/0"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultDesktop, err := eds.NewDesktop(ctx, "default", &eds.DesktopArgs{
     * 			OfficeSiteId:  defaultSimpleOfficeSite.ID(),
     * 			PolicyGroupId: defaultEcdPolicyGroup.ID(),
     * 			BundleId:      pulumi.String(_default.Bundles[1].Id),
     * 			DesktopName:   pulumi.String("your_desktop_name"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultImage, err := eds.NewImage(ctx, "default", &eds.ImageArgs{
     * 			ImageName:   pulumi.String("your_image_name"),
     * 			DesktopId:   defaultDesktop.ID(),
     * 			Description: pulumi.String("example_value"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := eds.GetImagesOutput(ctx, eds.GetImagesOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultImage.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("ecdImageId1", ids.ApplyT(func(ids eds.GetImagesResult) (*string, error) {
     * 			return &ids.Images[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		nameRegex := defaultImage.ImageName.ApplyT(func(imageName *string) (eds.GetImagesResult, error) {
     * 			return eds.GetImagesResult(interface{}(eds.GetImagesOutput(ctx, eds.GetImagesOutputArgs{
     * 				NameRegex: imageName,
     * 			}, nil))), nil
     * 		}).(eds.GetImagesResultOutput)
     * 		ctx.Export("ecdImageId2", nameRegex.ApplyT(func(nameRegex eds.GetImagesResult) (*string, error) {
     * 			return &nameRegex.Images[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.SimpleOfficeSite;
     * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetBundlesArgs;
     * import com.pulumi.alicloud.eds.EcdPolicyGroup;
     * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.Desktop;
     * import com.pulumi.alicloud.eds.DesktopArgs;
     * import com.pulumi.alicloud.eds.Image;
     * import com.pulumi.alicloud.eds.ImageArgs;
     * import com.pulumi.alicloud.eds.inputs.GetImagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .desktopAccessType("Internet")
     *             .officeSiteName("your_simple_office_site_name")
     *             .build());
     *         final var default = EdsFunctions.getBundles(GetBundlesArgs.builder()
     *             .bundleType("SYSTEM")
     *             .build());
     *         var defaultEcdPolicyGroup = new EcdPolicyGroup("defaultEcdPolicyGroup", EcdPolicyGroupArgs.builder()
     *             .policyGroupName("your_policy_group_name")
     *             .clipboard("readwrite")
     *             .localDrive("read")
     *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
     *                 .description("example_value")
     *                 .cidrIp("1.2.3.4/24")
     *                 .build())
     *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
     *                 .type("inflow")
     *                 .policy("accept")
     *                 .description("example_value")
     *                 .portRange("80/80")
     *                 .ipProtocol("TCP")
     *                 .priority("1")
     *                 .cidrIp("0.0.0.0/0")
     *                 .build())
     *             .build());
     *         var defaultDesktop = new Desktop("defaultDesktop", DesktopArgs.builder()
     *             .officeSiteId(defaultSimpleOfficeSite.id())
     *             .policyGroupId(defaultEcdPolicyGroup.id())
     *             .bundleId(default_.bundles()[1].id())
     *             .desktopName("your_desktop_name")
     *             .build());
     *         var defaultImage = new Image("defaultImage", ImageArgs.builder()
     *             .imageName("your_image_name")
     *             .desktopId(defaultDesktop.id())
     *             .description("example_value")
     *             .build());
     *         final var ids = EdsFunctions.getImages(GetImagesArgs.builder()
     *             .ids(defaultImage.id())
     *             .build());
     *         ctx.export("ecdImageId1", ids.applyValue(getImagesResult -> getImagesResult).applyValue(ids -> ids.applyValue(getImagesResult -> getImagesResult.images()[0].id())));
     *         final var nameRegex = EdsFunctions.getImages(GetImagesArgs.builder()
     *             .nameRegex(defaultImage.imageName())
     *             .build());
     *         ctx.export("ecdImageId2", nameRegex.applyValue(getImagesResult -> getImagesResult).applyValue(nameRegex -> nameRegex.applyValue(getImagesResult -> getImagesResult.images()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultSimpleOfficeSite:
     *     type: alicloud:eds:SimpleOfficeSite
     *     name: default
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       desktopAccessType: Internet
     *       officeSiteName: your_simple_office_site_name
     *   defaultEcdPolicyGroup:
     *     type: alicloud:eds:EcdPolicyGroup
     *     name: default
     *     properties:
     *       policyGroupName: your_policy_group_name
     *       clipboard: readwrite
     *       localDrive: read
     *       authorizeAccessPolicyRules:
     *         - description: example_value
     *           cidrIp: 1.2.3.4/24
     *       authorizeSecurityPolicyRules:
     *         - type: inflow
     *           policy: accept
     *           description: example_value
     *           portRange: 80/80
     *           ipProtocol: TCP
     *           priority: '1'
     *           cidrIp: 0.0.0.0/0
     *   defaultDesktop:
     *     type: alicloud:eds:Desktop
     *     name: default
     *     properties:
     *       officeSiteId: ${defaultSimpleOfficeSite.id}
     *       policyGroupId: ${defaultEcdPolicyGroup.id}
     *       bundleId: ${default.bundles[1].id}
     *       desktopName: your_desktop_name
     *   defaultImage:
     *     type: alicloud:eds:Image
     *     name: default
     *     properties:
     *       imageName: your_image_name
     *       desktopId: ${defaultDesktop.id}
     *       description: example_value
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getBundles
     *       Arguments:
     *         bundleType: SYSTEM
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getImages
     *       Arguments:
     *         ids:
     *           - ${defaultImage.id}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getImages
     *       Arguments:
     *         nameRegex: ${defaultImage.imageName}
     * outputs:
     *   ecdImageId1: ${ids.images[0].id}
     *   ecdImageId2: ${nameRegex.images[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getImages.
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: GetImagesPlainArgs): GetImagesResult =
        getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())

    /**
     * @see [getImages].
     * @param desktopInstanceType The desktop type of the image.
     * @param ids A list of Image IDs.
     * @param imageType The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
     * @param nameRegex A regex string to filter results by Image name.
     * @param osType The operating system type of the image. Valid values: `Windows` and `Linux`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(
        desktopInstanceType: String? = null,
        ids: List<String>? = null,
        imageType: String? = null,
        nameRegex: String? = null,
        osType: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetImagesResult {
        val argument = GetImagesPlainArgs(
            desktopInstanceType = desktopInstanceType,
            ids = ids,
            imageType = imageType,
            nameRegex = nameRegex,
            osType = osType,
            outputFile = outputFile,
            status = status,
        )
        return getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetImagesPlainArgs].
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: suspend GetImagesPlainArgsBuilder.() -> Unit): GetImagesResult {
        val builder = GetImagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImagesResultToKotlin(getImagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Nas File Systems of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.141.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.eds.SimpleOfficeSite("default", {
     *     cidrBlock: "172.16.0.0/12",
     *     desktopAccessType: "Internet",
     *     officeSiteName: "your_office_site_name",
     *     enableInternetAccess: false,
     * });
     * const defaultNasFileSystem = new alicloud.eds.NasFileSystem("default", {
     *     description: "your_description",
     *     officeSiteId: _default.id,
     *     nasFileSystemName: "your_nas_file_system_name",
     * });
     * const ids = alicloud.eds.getNasFileSystems({});
     * export const ecdNasFileSystemId1 = ids.then(ids => ids.systems?.[0]?.id);
     * const nameRegex = defaultNasFileSystem.nasFileSystemName.apply(nasFileSystemName => alicloud.eds.getNasFileSystemsOutput({
     *     nameRegex: nasFileSystemName,
     * }));
     * export const ecdNasFileSystemId2 = nameRegex.apply(nameRegex => nameRegex.systems?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.SimpleOfficeSite("default",
     *     cidr_block="172.16.0.0/12",
     *     desktop_access_type="Internet",
     *     office_site_name="your_office_site_name",
     *     enable_internet_access=False)
     * default_nas_file_system = alicloud.eds.NasFileSystem("default",
     *     description="your_description",
     *     office_site_id=default.id,
     *     nas_file_system_name="your_nas_file_system_name")
     * ids = alicloud.eds.get_nas_file_systems()
     * pulumi.export("ecdNasFileSystemId1", ids.systems[0].id)
     * name_regex = default_nas_file_system.nas_file_system_name.apply(lambda nas_file_system_name: alicloud.eds.get_nas_file_systems_output(name_regex=nas_file_system_name))
     * pulumi.export("ecdNasFileSystemId2", name_regex.systems[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Eds.SimpleOfficeSite("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         DesktopAccessType = "Internet",
     *         OfficeSiteName = "your_office_site_name",
     *         EnableInternetAccess = false,
     *     });
     *     var defaultNasFileSystem = new AliCloud.Eds.NasFileSystem("default", new()
     *     {
     *         Description = "your_description",
     *         OfficeSiteId = @default.Id,
     *         NasFileSystemName = "your_nas_file_system_name",
     *     });
     *     var ids = AliCloud.Eds.GetNasFileSystems.Invoke();
     *     var nameRegex = AliCloud.Eds.GetNasFileSystems.Invoke(new()
     *     {
     *         NameRegex = defaultNasFileSystem.NasFileSystemName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdNasFileSystemId1"] = ids&#46;Apply(getNasFileSystemsResult => getNasFileSystemsResult&#46;Systems[0]?.Id),
     *         ["ecdNasFileSystemId2"] = nameRegex&#46;Apply(getNasFileSystemsResult => getNasFileSystemsResult&#46;Systems[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
     * 			CidrBlock:            pulumi.String("172.16.0.0/12"),
     * 			DesktopAccessType:    pulumi.String("Internet"),
     * 			OfficeSiteName:       pulumi.String("your_office_site_name"),
     * 			EnableInternetAccess: pulumi.Bool(false),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNasFileSystem, err := eds.NewNasFileSystem(ctx, "default", &eds.NasFileSystemArgs{
     * 			Description:       pulumi.String("your_description"),
     * 			OfficeSiteId:      _default.ID(),
     * 			NasFileSystemName: pulumi.String("your_nas_file_system_name"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := eds.GetNasFileSystems(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdNasFileSystemId1", ids.Systems[0].Id)
     * 		nameRegex := defaultNasFileSystem.NasFileSystemName.ApplyT(func(nasFileSystemName *string) (eds.GetNasFileSystemsResult, error) {
     * 			return eds.GetNasFileSystemsResult(interface{}(eds.GetNasFileSystemsOutput(ctx, eds.GetNasFileSystemsOutputArgs{
     * 				NameRegex: nasFileSystemName,
     * 			}, nil))), nil
     * 		}).(eds.GetNasFileSystemsResultOutput)
     * 		ctx.Export("ecdNasFileSystemId2", nameRegex.ApplyT(func(nameRegex eds.GetNasFileSystemsResult) (*string, error) {
     * 			return &nameRegex.Systems[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.SimpleOfficeSite;
     * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
     * import com.pulumi.alicloud.eds.NasFileSystem;
     * import com.pulumi.alicloud.eds.NasFileSystemArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetNasFileSystemsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new SimpleOfficeSite("default", SimpleOfficeSiteArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .desktopAccessType("Internet")
     *             .officeSiteName("your_office_site_name")
     *             .enableInternetAccess(false)
     *             .build());
     *         var defaultNasFileSystem = new NasFileSystem("defaultNasFileSystem", NasFileSystemArgs.builder()
     *             .description("your_description")
     *             .officeSiteId(default_.id())
     *             .nasFileSystemName("your_nas_file_system_name")
     *             .build());
     *         final var ids = EdsFunctions.getNasFileSystems();
     *         ctx.export("ecdNasFileSystemId1", ids.applyValue(getNasFileSystemsResult -> getNasFileSystemsResult.systems()[0].id()));
     *         final var nameRegex = EdsFunctions.getNasFileSystems(GetNasFileSystemsArgs.builder()
     *             .nameRegex(defaultNasFileSystem.nasFileSystemName())
     *             .build());
     *         ctx.export("ecdNasFileSystemId2", nameRegex.applyValue(getNasFileSystemsResult -> getNasFileSystemsResult).applyValue(nameRegex -> nameRegex.applyValue(getNasFileSystemsResult -> getNasFileSystemsResult.systems()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:eds:SimpleOfficeSite
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       desktopAccessType: Internet
     *       officeSiteName: your_office_site_name
     *       enableInternetAccess: false
     *   defaultNasFileSystem:
     *     type: alicloud:eds:NasFileSystem
     *     name: default
     *     properties:
     *       description: your_description
     *       officeSiteId: ${default.id}
     *       nasFileSystemName: your_nas_file_system_name
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getNasFileSystems
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getNasFileSystems
     *       Arguments:
     *         nameRegex: ${defaultNasFileSystem.nasFileSystemName}
     * outputs:
     *   ecdNasFileSystemId1: ${ids.systems[0].id}
     *   ecdNasFileSystemId2: ${nameRegex.systems[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNasFileSystems.
     * @return A collection of values returned by getNasFileSystems.
     */
    public suspend fun getNasFileSystems(argument: GetNasFileSystemsPlainArgs): GetNasFileSystemsResult =
        getNasFileSystemsResultToKotlin(getNasFileSystemsPlain(argument.toJava()).await())

    /**
     * @see [getNasFileSystems].
     * @param ids A list of Nas File System IDs.
     * @param nameRegex A regex string to filter results by Nas File System name.
     * @param officeSiteId The ID of office site.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
     * @return A collection of values returned by getNasFileSystems.
     */
    public suspend fun getNasFileSystems(
        ids: List<String>? = null,
        nameRegex: String? = null,
        officeSiteId: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetNasFileSystemsResult {
        val argument = GetNasFileSystemsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            officeSiteId = officeSiteId,
            outputFile = outputFile,
            status = status,
        )
        return getNasFileSystemsResultToKotlin(getNasFileSystemsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNasFileSystems].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetNasFileSystemsPlainArgs].
     * @return A collection of values returned by getNasFileSystems.
     */
    public suspend fun getNasFileSystems(argument: suspend GetNasFileSystemsPlainArgsBuilder.() -> Unit): GetNasFileSystemsResult {
        val builder = GetNasFileSystemsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNasFileSystemsResultToKotlin(getNasFileSystemsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Network Packages of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
     *     cidrBlock: "172.16.0.0/12",
     *     desktopAccessType: "Internet",
     *     officeSiteName: "example_value",
     * });
     * const defaultNetworkPackage = new alicloud.eds.NetworkPackage("default", {
     *     bandwidth: 10,
     *     officeSiteId: defaultSimpleOfficeSite.id,
     * });
     * const default = alicloud.eds.getNetworkPackagesOutput({
     *     ids: [defaultNetworkPackage&#46;id],
     * });
     * export const ecdNetworkPackageId1 = _default.apply(_default => _default.packages?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
     *     cidr_block="172.16.0.0/12",
     *     desktop_access_type="Internet",
     *     office_site_name="example_value")
     * default_network_package = alicloud.eds.NetworkPackage("default",
     *     bandwidth=10,
     *     office_site_id=default_simple_office_site.id)
     * default = alicloud.eds.get_network_packages_output(ids=[default_network_package&#46;id])
     * pulumi.export("ecdNetworkPackageId1", default.packages[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *         DesktopAccessType = "Internet",
     *         OfficeSiteName = "example_value",
     *     });
     *     var defaultNetworkPackage = new AliCloud.Eds.NetworkPackage("default", new()
     *     {
     *         Bandwidth = 10,
     *         OfficeSiteId = defaultSimpleOfficeSite.Id,
     *     });
     *     var @default = AliCloud.Eds.GetNetworkPackages.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultNetworkPackage.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdNetworkPackageId1"] = @default&#46;Apply(@default => @default&#46;Apply(getNetworkPackagesResult => getNetworkPackagesResult&#46;Packages[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
     * CidrBlock: pulumi.String("172.16.0.0/12"),
     * DesktopAccessType: pulumi.String("Internet"),
     * OfficeSiteName: pulumi.String("example_value"),
     * })
     * if err != nil {
     * return err
     * }
     * defaultNetworkPackage, err := eds.NewNetworkPackage(ctx, "default", &eds.NetworkPackageArgs{
     * Bandwidth: pulumi.Int(10),
     * OfficeSiteId: defaultSimpleOfficeSite.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * _default := eds.GetNetworkPackagesOutput(ctx, eds.GetNetworkPackagesOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultNetworkPackage.ID(),
     * },
     * }, nil);
     * ctx.Export("ecdNetworkPackageId1", _default.ApplyT(func(_default eds.GetNetworkPackagesResult) (*string, error) {
     * return &default.Packages[0].Id, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.SimpleOfficeSite;
     * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
     * import com.pulumi.alicloud.eds.NetworkPackage;
     * import com.pulumi.alicloud.eds.NetworkPackageArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetNetworkPackagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .desktopAccessType("Internet")
     *             .officeSiteName("example_value")
     *             .build());
     *         var defaultNetworkPackage = new NetworkPackage("defaultNetworkPackage", NetworkPackageArgs.builder()
     *             .bandwidth("10")
     *             .officeSiteId(defaultSimpleOfficeSite.id())
     *             .build());
     *         final var default = EdsFunctions.getNetworkPackages(GetNetworkPackagesArgs.builder()
     *             .ids(defaultNetworkPackage.id())
     *             .build());
     *         ctx.export("ecdNetworkPackageId1", default_.applyValue(default_ -> default_.packages()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultSimpleOfficeSite:
     *     type: alicloud:eds:SimpleOfficeSite
     *     name: default
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *       desktopAccessType: Internet
     *       officeSiteName: example_value
     *   defaultNetworkPackage:
     *     type: alicloud:eds:NetworkPackage
     *     name: default
     *     properties:
     *       bandwidth: '10'
     *       officeSiteId: ${defaultSimpleOfficeSite.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getNetworkPackages
     *       Arguments:
     *         ids:
     *           - ${defaultNetworkPackage.id}
     * outputs:
     *   ecdNetworkPackageId1: ${default.packages[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkPackages.
     * @return A collection of values returned by getNetworkPackages.
     */
    public suspend fun getNetworkPackages(argument: GetNetworkPackagesPlainArgs): GetNetworkPackagesResult =
        getNetworkPackagesResultToKotlin(getNetworkPackagesPlain(argument.toJava()).await())

    /**
     * @see [getNetworkPackages].
     * @param ids A list of Network Package IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
     * @return A collection of values returned by getNetworkPackages.
     */
    public suspend fun getNetworkPackages(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetNetworkPackagesResult {
        val argument = GetNetworkPackagesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getNetworkPackagesResultToKotlin(getNetworkPackagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkPackages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetNetworkPackagesPlainArgs].
     * @return A collection of values returned by getNetworkPackages.
     */
    public suspend fun getNetworkPackages(argument: suspend GetNetworkPackagesPlainArgsBuilder.() -> Unit): GetNetworkPackagesResult {
        val builder = GetNetworkPackagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkPackagesResultToKotlin(getNetworkPackagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Policy Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.130.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.eds.EcdPolicyGroup("default", {
     *     policyGroupName: "my-policy-group",
     *     clipboard: "read",
     *     localDrive: "read",
     *     usbRedirect: "off",
     *     watermark: "off",
     *     authorizeAccessPolicyRules: [{
     *         description: "my-description1",
     *         cidrIp: "1.2.3.45/24",
     *     }],
     *     authorizeSecurityPolicyRules: [{
     *         type: "inflow",
     *         policy: "accept",
     *         description: "my-description",
     *         portRange: "80/80",
     *         ipProtocol: "TCP",
     *         priority: "1",
     *         cidrIp: "1.2.3.4/24",
     *     }],
     * });
     * const nameRegex = alicloud.eds.getPolicyGroups({
     *     nameRegex: "^my-policy",
     * });
     * export const ecdPolicyGroupId = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.EcdPolicyGroup("default",
     *     policy_group_name="my-policy-group",
     *     clipboard="read",
     *     local_drive="read",
     *     usb_redirect="off",
     *     watermark="off",
     *     authorize_access_policy_rules=[{
     *         "description": "my-description1",
     *         "cidr_ip": "1.2.3.45/24",
     *     }],
     *     authorize_security_policy_rules=[{
     *         "type": "inflow",
     *         "policy": "accept",
     *         "description": "my-description",
     *         "port_range": "80/80",
     *         "ip_protocol": "TCP",
     *         "priority": "1",
     *         "cidr_ip": "1.2.3.4/24",
     *     }])
     * name_regex = alicloud.eds.get_policy_groups(name_regex="^my-policy")
     * pulumi.export("ecdPolicyGroupId", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Eds.EcdPolicyGroup("default", new()
     *     {
     *         PolicyGroupName = "my-policy-group",
     *         Clipboard = "read",
     *         LocalDrive = "read",
     *         UsbRedirect = "off",
     *         Watermark = "off",
     *         AuthorizeAccessPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs
     *             {
     *                 Description = "my-description1",
     *                 CidrIp = "1.2.3.45/24",
     *             },
     *         },
     *         AuthorizeSecurityPolicyRules = new[]
     *         {
     *             new AliCloud.Eds.Inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs
     *             {
     *                 Type = "inflow",
     *                 Policy = "accept",
     *                 Description = "my-description",
     *                 PortRange = "80/80",
     *                 IpProtocol = "TCP",
     *                 Priority = "1",
     *                 CidrIp = "1.2.3.4/24",
     *             },
     *         },
     *     });
     *     var nameRegex = AliCloud.Eds.GetPolicyGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-policy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdPolicyGroupId"] = nameRegex&#46;Apply(getPolicyGroupsResult => getPolicyGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eds.NewEcdPolicyGroup(ctx, "default", &eds.EcdPolicyGroupArgs{
     * 			PolicyGroupName: pulumi.String("my-policy-group"),
     * 			Clipboard:       pulumi.String("read"),
     * 			LocalDrive:      pulumi.String("read"),
     * 			UsbRedirect:     pulumi.String("off"),
     * 			Watermark:       pulumi.String("off"),
     * 			AuthorizeAccessPolicyRules: eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs{
     * 					Description: pulumi.String("my-description1"),
     * 					CidrIp:      pulumi.String("1.2.3.45/24"),
     * 				},
     * 			},
     * 			AuthorizeSecurityPolicyRules: eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArray{
     * 				&eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs{
     * 					Type:        pulumi.String("inflow"),
     * 					Policy:      pulumi.String("accept"),
     * 					Description: pulumi.String("my-description"),
     * 					PortRange:   pulumi.String("80/80"),
     * 					IpProtocol:  pulumi.String("TCP"),
     * 					Priority:    pulumi.String("1"),
     * 					CidrIp:      pulumi.String("1.2.3.4/24"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nameRegex, err := eds.GetPolicyGroups(ctx, &eds.GetPolicyGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-policy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdPolicyGroupId", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EcdPolicyGroup;
     * import com.pulumi.alicloud.eds.EcdPolicyGroupArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetPolicyGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new EcdPolicyGroup("default", EcdPolicyGroupArgs.builder()
     *             .policyGroupName("my-policy-group")
     *             .clipboard("read")
     *             .localDrive("read")
     *             .usbRedirect("off")
     *             .watermark("off")
     *             .authorizeAccessPolicyRules(EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
     *                 .description("my-description1")
     *                 .cidrIp("1.2.3.45/24")
     *                 .build())
     *             .authorizeSecurityPolicyRules(EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
     *                 .type("inflow")
     *                 .policy("accept")
     *                 .description("my-description")
     *                 .portRange("80/80")
     *                 .ipProtocol("TCP")
     *                 .priority("1")
     *                 .cidrIp("1.2.3.4/24")
     *                 .build())
     *             .build());
     *         final var nameRegex = EdsFunctions.getPolicyGroups(GetPolicyGroupsArgs.builder()
     *             .nameRegex("^my-policy")
     *             .build());
     *         ctx.export("ecdPolicyGroupId", nameRegex.applyValue(getPolicyGroupsResult -> getPolicyGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:eds:EcdPolicyGroup
     *     properties:
     *       policyGroupName: my-policy-group
     *       clipboard: read
     *       localDrive: read
     *       usbRedirect: off
     *       watermark: off
     *       authorizeAccessPolicyRules:
     *         - description: my-description1
     *           cidrIp: 1.2.3.45/24
     *       authorizeSecurityPolicyRules:
     *         - type: inflow
     *           policy: accept
     *           description: my-description
     *           portRange: 80/80
     *           ipProtocol: TCP
     *           priority: '1'
     *           cidrIp: 1.2.3.4/24
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getPolicyGroups
     *       Arguments:
     *         nameRegex: ^my-policy
     * outputs:
     *   ecdPolicyGroupId: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicyGroups.
     * @return A collection of values returned by getPolicyGroups.
     */
    public suspend fun getPolicyGroups(argument: GetPolicyGroupsPlainArgs): GetPolicyGroupsResult =
        getPolicyGroupsResultToKotlin(getPolicyGroupsPlain(argument.toJava()).await())

    /**
     * @see [getPolicyGroups].
     * @param ids A list of Policy Group IDs.
     * @param nameRegex A regex string to filter results by Policy Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of policy.
     * @return A collection of values returned by getPolicyGroups.
     */
    public suspend fun getPolicyGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetPolicyGroupsResult {
        val argument = GetPolicyGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getPolicyGroupsResultToKotlin(getPolicyGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetPolicyGroupsPlainArgs].
     * @return A collection of values returned by getPolicyGroups.
     */
    public suspend fun getPolicyGroups(argument: suspend GetPolicyGroupsPlainArgsBuilder.() -> Unit): GetPolicyGroupsResult {
        val builder = GetPolicyGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyGroupsResultToKotlin(getPolicyGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Ram Directories of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.174.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getRamDirectories({
     *     ids: ["example_id"],
     * });
     * export const ecdRamDirectoryId1 = ids.then(ids => ids.directories?.[0]?.id);
     * const nameRegex = alicloud.eds.getRamDirectories({
     *     nameRegex: "^my-RamDirectory",
     * });
     * export const ecdRamDirectoryId2 = nameRegex.then(nameRegex => nameRegex.directories?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_ram_directories(ids=["example_id"])
     * pulumi.export("ecdRamDirectoryId1", ids.directories[0].id)
     * name_regex = alicloud.eds.get_ram_directories(name_regex="^my-RamDirectory")
     * pulumi.export("ecdRamDirectoryId2", name_regex.directories[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetRamDirectories.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Eds.GetRamDirectories.Invoke(new()
     *     {
     *         NameRegex = "^my-RamDirectory",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdRamDirectoryId1"] = ids&#46;Apply(getRamDirectoriesResult => getRamDirectoriesResult&#46;Directories[0]?.Id),
     *         ["ecdRamDirectoryId2"] = nameRegex&#46;Apply(getRamDirectoriesResult => getRamDirectoriesResult&#46;Directories[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetRamDirectories(ctx, &eds.GetRamDirectoriesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdRamDirectoryId1", ids.Directories[0].Id)
     * 		nameRegex, err := eds.GetRamDirectories(ctx, &eds.GetRamDirectoriesArgs{
     * 			NameRegex: pulumi.StringRef("^my-RamDirectory"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdRamDirectoryId2", nameRegex.Directories[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetRamDirectoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getRamDirectories(GetRamDirectoriesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ecdRamDirectoryId1", ids.applyValue(getRamDirectoriesResult -> getRamDirectoriesResult.directories()[0].id()));
     *         final var nameRegex = EdsFunctions.getRamDirectories(GetRamDirectoriesArgs.builder()
     *             .nameRegex("^my-RamDirectory")
     *             .build());
     *         ctx.export("ecdRamDirectoryId2", nameRegex.applyValue(getRamDirectoriesResult -> getRamDirectoriesResult.directories()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getRamDirectories
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eds:getRamDirectories
     *       Arguments:
     *         nameRegex: ^my-RamDirectory
     * outputs:
     *   ecdRamDirectoryId1: ${ids.directories[0].id}
     *   ecdRamDirectoryId2: ${nameRegex.directories[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRamDirectories.
     * @return A collection of values returned by getRamDirectories.
     */
    public suspend fun getRamDirectories(argument: GetRamDirectoriesPlainArgs): GetRamDirectoriesResult =
        getRamDirectoriesResultToKotlin(getRamDirectoriesPlain(argument.toJava()).await())

    /**
     * @see [getRamDirectories].
     * @param ids A list of Ram Directory IDs.
     * @param nameRegex A regex string to filter results by Ram Directory name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of directory. Valid values: `REGISTERING`, `REGISTERED`, `DEREGISTERING`, `NEEDCONFIGTRUST`, `CONFIGTRUSTFAILED`, `DEREGISTERED`, `ERROR`, `CONFIGTRUSTING`, `NEEDCONFIGUSER`.
     * @return A collection of values returned by getRamDirectories.
     */
    public suspend fun getRamDirectories(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetRamDirectoriesResult {
        val argument = GetRamDirectoriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getRamDirectoriesResultToKotlin(getRamDirectoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRamDirectories].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetRamDirectoriesPlainArgs].
     * @return A collection of values returned by getRamDirectories.
     */
    public suspend fun getRamDirectories(argument: suspend GetRamDirectoriesPlainArgsBuilder.() -> Unit): GetRamDirectoriesResult {
        val builder = GetRamDirectoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRamDirectoriesResultToKotlin(getRamDirectoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Simple Office Sites of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eds.getSimpleOfficeSites({
     *     ids: ["example_id"],
     *     status: "REGISTERED",
     * });
     * export const desktopAccessType = _default.then(_default => _default.sites?.[0]?.desktopAccessType);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.get_simple_office_sites(ids=["example_id"],
     *     status="REGISTERED")
     * pulumi.export("desktopAccessType", default.sites[0].desktop_access_type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eds.GetSimpleOfficeSites.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = "REGISTERED",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["desktopAccessType"] = @default&#46;Apply(@default => @default&#46;Apply(getSimpleOfficeSitesResult => getSimpleOfficeSitesResult&#46;Sites[0]?.DesktopAccessType)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := eds.GetSimpleOfficeSites(ctx, &eds.GetSimpleOfficeSitesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.StringRef("REGISTERED"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("desktopAccessType", _default.Sites[0].DesktopAccessType)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetSimpleOfficeSitesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EdsFunctions.getSimpleOfficeSites(GetSimpleOfficeSitesArgs.builder()
     *             .ids("example_id")
     *             .status("REGISTERED")
     *             .build());
     *         ctx.export("desktopAccessType", default_.sites()[0].desktopAccessType());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getSimpleOfficeSites
     *       Arguments:
     *         ids:
     *           - example_id
     *         status: REGISTERED
     * outputs:
     *   desktopAccessType: ${default.sites[0].desktopAccessType}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSimpleOfficeSites.
     * @return A collection of values returned by getSimpleOfficeSites.
     */
    public suspend fun getSimpleOfficeSites(argument: GetSimpleOfficeSitesPlainArgs): GetSimpleOfficeSitesResult =
        getSimpleOfficeSitesResultToKotlin(getSimpleOfficeSitesPlain(argument.toJava()).await())

    /**
     * @see [getSimpleOfficeSites].
     * @param ids A list of Simple Office Site IDs.
     * @param nameRegex A regex string to filter results by Simple Office Site name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Workspace State. Valid values: `REGISTERED`,`REGISTERING`.
     * @return A collection of values returned by getSimpleOfficeSites.
     */
    public suspend fun getSimpleOfficeSites(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetSimpleOfficeSitesResult {
        val argument = GetSimpleOfficeSitesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getSimpleOfficeSitesResultToKotlin(getSimpleOfficeSitesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSimpleOfficeSites].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetSimpleOfficeSitesPlainArgs].
     * @return A collection of values returned by getSimpleOfficeSites.
     */
    public suspend fun getSimpleOfficeSites(argument: suspend GetSimpleOfficeSitesPlainArgsBuilder.() -> Unit): GetSimpleOfficeSitesResult {
        val builder = GetSimpleOfficeSitesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSimpleOfficeSitesResultToKotlin(getSimpleOfficeSitesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ecd Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.169.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eds.getSnapshots({});
     * export const ecdSnapshotId1 = ids.then(ids => ids.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eds.get_snapshots()
     * pulumi.export("ecdSnapshotId1", ids.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eds.GetSnapshots.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdSnapshotId1"] = ids&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eds.GetSnapshots(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdSnapshotId1", ids.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EdsFunctions.getSnapshots();
     *         ctx.export("ecdSnapshotId1", ids.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getSnapshots
     *       Arguments: {}
     * outputs:
     *   ecdSnapshotId1: ${ids.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshots.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: GetSnapshotsPlainArgs): GetSnapshotsResult =
        getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshots].
     * @param desktopId The ID of the Desktop.
     * @param ids A list of Snapshot IDs.
     * @param nameRegex A regex string to filter results by Snapshot name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param snapshotId The ID of the Snapshot.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(
        desktopId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        snapshotId: String? = null,
    ): GetSnapshotsResult {
        val argument = GetSnapshotsPlainArgs(
            desktopId = desktopId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            snapshotId = snapshotId,
        )
        return getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetSnapshotsPlainArgs].
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: suspend GetSnapshotsPlainArgsBuilder.() -> Unit): GetSnapshotsResult {
        val builder = GetSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotsResultToKotlin(getSnapshotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Elastic Desktop Service (ECD) Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.eds.User("default", {
     *     endUserId: "example_value",
     *     email: "your_email",
     *     phone: "your_phone",
     *     password: "your_password",
     * });
     * const ids = alicloud.eds.getUsers({});
     * export const ecdUserId1 = ids.then(ids => ids.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.User("default",
     *     end_user_id="example_value",
     *     email="your_email",
     *     phone="your_phone",
     *     password="your_password")
     * ids = alicloud.eds.get_users()
     * pulumi.export("ecdUserId1", ids.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Eds.User("default", new()
     *     {
     *         EndUserId = "example_value",
     *         Email = "your_email",
     *         Phone = "your_phone",
     *         Password = "your_password",
     *     });
     *     var ids = AliCloud.Eds.GetUsers.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["ecdUserId1"] = ids&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eds.NewUser(ctx, "default", &eds.UserArgs{
     * 			EndUserId: pulumi.String("example_value"),
     * 			Email:     pulumi.String("your_email"),
     * 			Phone:     pulumi.String("your_phone"),
     * 			Password:  pulumi.String("your_password"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := eds.GetUsers(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ecdUserId1", ids.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.User;
     * import com.pulumi.alicloud.eds.UserArgs;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new User("default", UserArgs.builder()
     *             .endUserId("example_value")
     *             .email("your_email")
     *             .phone("your_phone")
     *             .password("your_password")
     *             .build());
     *         final var ids = EdsFunctions.getUsers();
     *         ctx.export("ecdUserId1", ids.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:eds:User
     *     properties:
     *       endUserId: example_value
     *       email: your_email
     *       phone: your_phone
     *       password: your_password
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eds:getUsers
     *       Arguments: {}
     * outputs:
     *   ecdUserId1: ${ids.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param ids A list of User IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Unlocked`, `Locked`.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Elastic Desktop Service (ECD) of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.174.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eds.getZones({});
     * export const alicloudEcdZones = _default.then(_default => _default.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eds.get_zones()
     * pulumi.export("alicloudEcdZones", default.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eds.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEcdZones"] = @default&#46;Apply(@default => @default&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := eds.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudEcdZones", _default.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eds.EdsFunctions;
     * import com.pulumi.alicloud.eds.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EdsFunctions.getZones();
     *         ctx.export("alicloudEcdZones", default_.zones()[0].zoneId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eds:getZones
     *       Arguments: {}
     * outputs:
     *   alicloudEcdZones: ${default.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eds&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
