@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkPackage].
 */
@PulumiTagMarker
public class NetworkPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkPackageArgs = NetworkPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkPackageArgsBuilder.() -> Unit) {
        val builder = NetworkPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkPackage {
        val builtJavaResource = com.pulumi.alicloud.eds.NetworkPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkPackage(builtJavaResource)
    }
}

/**
 * Provides a ECD Network Package resource.
 * For information about ECD Network Package and how to use it, see [What is Network Package](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createnetworkpackage).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
 *     cidrBlock: "172.16.0.0/12",
 *     enableAdminAccess: true,
 *     desktopAccessType: "Internet",
 *     officeSiteName: `terraform-example-${_default.result}`,
 * });
 * const defaultNetworkPackage = new alicloud.eds.NetworkPackage("default", {
 *     bandwidth: 10,
 *     officeSiteId: defaultSimpleOfficeSite.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
 *     cidr_block="172.16.0.0/12",
 *     enable_admin_access=True,
 *     desktop_access_type="Internet",
 *     office_site_name=f"terraform-example-{default['result']}")
 * default_network_package = alicloud.eds.NetworkPackage("default",
 *     bandwidth=10,
 *     office_site_id=default_simple_office_site.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         EnableAdminAccess = true,
 *         DesktopAccessType = "Internet",
 *         OfficeSiteName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultNetworkPackage = new AliCloud.Eds.NetworkPackage("default", new()
 *     {
 *         Bandwidth = 10,
 *         OfficeSiteId = defaultSimpleOfficeSite.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
 * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			DesktopAccessType: pulumi.String("Internet"),
 * 			OfficeSiteName:    pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewNetworkPackage(ctx, "default", &eds.NetworkPackageArgs{
 * 			Bandwidth:    pulumi.Int(10),
 * 			OfficeSiteId: defaultSimpleOfficeSite.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.SimpleOfficeSite;
 * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
 * import com.pulumi.alicloud.eds.NetworkPackage;
 * import com.pulumi.alicloud.eds.NetworkPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .enableAdminAccess(true)
 *             .desktopAccessType("Internet")
 *             .officeSiteName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultNetworkPackage = new NetworkPackage("defaultNetworkPackage", NetworkPackageArgs.builder()
 *             .bandwidth(10)
 *             .officeSiteId(defaultSimpleOfficeSite.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSimpleOfficeSite:
 *     type: alicloud:eds:SimpleOfficeSite
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       enableAdminAccess: true
 *       desktopAccessType: Internet
 *       officeSiteName: terraform-example-${default.result}
 *   defaultNetworkPackage:
 *     type: alicloud:eds:NetworkPackage
 *     name: default
 *     properties:
 *       bandwidth: 10
 *       officeSiteId: ${defaultSimpleOfficeSite.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Network Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/networkPackage:NetworkPackage example <id>
 * ```
 */
public class NetworkPackage internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.NetworkPackage,
) : KotlinCustomResource(javaResource, NetworkPackageMapper) {
    /**
     * The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The internet charge type  of  package.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * The ID of office site.
     */
    public val officeSiteId: Output<String>
        get() = javaResource.officeSiteId().applyValue({ args0 -> args0 })

    /**
     * The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object NetworkPackageMapper : ResourceMapper<NetworkPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.NetworkPackage::class == javaResource::class

    override fun map(javaResource: Resource): NetworkPackage = NetworkPackage(
        javaResource as
            com.pulumi.alicloud.eds.NetworkPackage,
    )
}

/**
 * @see [NetworkPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkPackage].
 */
public suspend fun networkPackage(
    name: String,
    block: suspend NetworkPackageResourceBuilder.() -> Unit,
): NetworkPackage {
    val builder = NetworkPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkPackage(name: String): NetworkPackage {
    val builder = NetworkPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
