@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.NetworkPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECD Network Package resource.
 * For information about ECD Network Package and how to use it, see [What is Network Package](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createnetworkpackage).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
 *     cidrBlock: "172.16.0.0/12",
 *     enableAdminAccess: true,
 *     desktopAccessType: "Internet",
 *     officeSiteName: `terraform-example-${_default.result}`,
 * });
 * const defaultNetworkPackage = new alicloud.eds.NetworkPackage("default", {
 *     bandwidth: 10,
 *     officeSiteId: defaultSimpleOfficeSite.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
 *     cidr_block="172.16.0.0/12",
 *     enable_admin_access=True,
 *     desktop_access_type="Internet",
 *     office_site_name=f"terraform-example-{default['result']}")
 * default_network_package = alicloud.eds.NetworkPackage("default",
 *     bandwidth=10,
 *     office_site_id=default_simple_office_site.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         EnableAdminAccess = true,
 *         DesktopAccessType = "Internet",
 *         OfficeSiteName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultNetworkPackage = new AliCloud.Eds.NetworkPackage("default", new()
 *     {
 *         Bandwidth = 10,
 *         OfficeSiteId = defaultSimpleOfficeSite.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSimpleOfficeSite, err := eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
 * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			DesktopAccessType: pulumi.String("Internet"),
 * 			OfficeSiteName:    pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewNetworkPackage(ctx, "default", &eds.NetworkPackageArgs{
 * 			Bandwidth:    pulumi.Int(10),
 * 			OfficeSiteId: defaultSimpleOfficeSite.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.SimpleOfficeSite;
 * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
 * import com.pulumi.alicloud.eds.NetworkPackage;
 * import com.pulumi.alicloud.eds.NetworkPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .enableAdminAccess(true)
 *             .desktopAccessType("Internet")
 *             .officeSiteName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultNetworkPackage = new NetworkPackage("defaultNetworkPackage", NetworkPackageArgs.builder()
 *             .bandwidth(10)
 *             .officeSiteId(defaultSimpleOfficeSite.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSimpleOfficeSite:
 *     type: alicloud:eds:SimpleOfficeSite
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       enableAdminAccess: true
 *       desktopAccessType: Internet
 *       officeSiteName: terraform-example-${default.result}
 *   defaultNetworkPackage:
 *     type: alicloud:eds:NetworkPackage
 *     name: default
 *     properties:
 *       bandwidth: 10
 *       officeSiteId: ${defaultSimpleOfficeSite.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Network Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/networkPackage:NetworkPackage example <id>
 * ```
 * @property bandwidth The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
 * @property officeSiteId The ID of office site.
 */
public data class NetworkPackageArgs(
    public val bandwidth: Output<Int>? = null,
    public val officeSiteId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.NetworkPackageArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.NetworkPackageArgs =
        com.pulumi.alicloud.eds.NetworkPackageArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .officeSiteId(officeSiteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkPackageArgs].
 */
@PulumiTagMarker
public class NetworkPackageArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var officeSiteId: Output<String>? = null

    /**
     * @param value The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
     */
    @JvmName("vvgpcsydebypxwvi")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The ID of office site.
     */
    @JvmName("dukierdaatdhpiwt")
    public suspend fun officeSiteId(`value`: Output<String>) {
        this.officeSiteId = value
    }

    /**
     * @param value The bandwidth of package public network bandwidth peak. Valid values: 1~200. Unit:Mbps.
     */
    @JvmName("efjesumlhpupckmn")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The ID of office site.
     */
    @JvmName("sqtdehbkdsjnstgs")
    public suspend fun officeSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.officeSiteId = mapped
    }

    internal fun build(): NetworkPackageArgs = NetworkPackageArgs(
        bandwidth = bandwidth,
        officeSiteId = officeSiteId,
    )
}
