@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RamDirectory].
 */
@PulumiTagMarker
public class RamDirectoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RamDirectoryArgs = RamDirectoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RamDirectoryArgsBuilder.() -> Unit) {
        val builder = RamDirectoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RamDirectory {
        val builtJavaResource = com.pulumi.alicloud.eds.RamDirectory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RamDirectory(builtJavaResource)
    }
}

/**
 * Provides a ECD Ram Directory resource.
 * For information about ECD Ram Directory and how to use it, see [What is Ram Directory](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createramdirectory).
 * > **NOTE:** Available since v1.174.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.eds.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     vswitchName: name,
 * });
 * const defaultRamDirectory = new alicloud.eds.RamDirectory("default", {
 *     desktopAccessType: "INTERNET",
 *     enableAdminAccess: true,
 *     ramDirectoryName: name,
 *     vswitchIds: [defaultSwitch&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eds.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.ids[0],
 *     vswitch_name=name)
 * default_ram_directory = alicloud.eds.RamDirectory("default",
 *     desktop_access_type="INTERNET",
 *     enable_admin_access=True,
 *     ram_directory_name=name,
 *     vswitch_ids=[default_switch&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Eds.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         VswitchName = name,
 *     });
 *     var defaultRamDirectory = new AliCloud.Eds.RamDirectory("default", new()
 *     {
 *         DesktopAccessType = "INTERNET",
 *         EnableAdminAccess = true,
 *         RamDirectoryName = name,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eds.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Ids[0]),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewRamDirectory(ctx, "default", &eds.RamDirectoryArgs{
 * 			DesktopAccessType: pulumi.String("INTERNET"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			RamDirectoryName:  pulumi.String(name),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.eds.RamDirectory;
 * import com.pulumi.alicloud.eds.RamDirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = EdsFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.ids()[0])
 *             .vswitchName(name)
 *             .build());
 *         var defaultRamDirectory = new RamDirectory("defaultRamDirectory", RamDirectoryArgs.builder()
 *             .desktopAccessType("INTERNET")
 *             .enableAdminAccess(true)
 *             .ramDirectoryName(name)
 *             .vswitchIds(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.ids[0]}
 *       vswitchName: ${name}
 *   defaultRamDirectory:
 *     type: alicloud:eds:RamDirectory
 *     name: default
 *     properties:
 *       desktopAccessType: INTERNET
 *       enableAdminAccess: true
 *       ramDirectoryName: ${name}
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Ram Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/ramDirectory:RamDirectory example <id>
 * ```
 */
public class RamDirectory internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.RamDirectory,
) : KotlinCustomResource(javaResource, RamDirectoryMapper) {
    /**
     * The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
     */
    public val desktopAccessType: Output<String>
        get() = javaResource.desktopAccessType().applyValue({ args0 -> args0 })

    /**
     * Whether to enable public network access.
     */
    public val enableAdminAccess: Output<Boolean>
        get() = javaResource.enableAdminAccess().applyValue({ args0 -> args0 })

    /**
     * Whether to grant local administrator rights to users who use cloud desktops.
     */
    public val enableInternetAccess: Output<Boolean>
        get() = javaResource.enableInternetAccess().applyValue({ args0 -> args0 })

    /**
     * The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    public val ramDirectoryName: Output<String>
        get() = javaResource.ramDirectoryName().applyValue({ args0 -> args0 })

    /**
     * The status of directory.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * List of VSwitch IDs in the directory.
     */
    public val vswitchIds: Output<List<String>>
        get() = javaResource.vswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object RamDirectoryMapper : ResourceMapper<RamDirectory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.RamDirectory::class == javaResource::class

    override fun map(javaResource: Resource): RamDirectory = RamDirectory(
        javaResource as
            com.pulumi.alicloud.eds.RamDirectory,
    )
}

/**
 * @see [RamDirectory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RamDirectory].
 */
public suspend fun ramDirectory(
    name: String,
    block: suspend RamDirectoryResourceBuilder.() -> Unit,
): RamDirectory {
    val builder = RamDirectoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RamDirectory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ramDirectory(name: String): RamDirectory {
    val builder = RamDirectoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
