@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.RamDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ECD Ram Directory resource.
 * For information about ECD Ram Directory and how to use it, see [What is Ram Directory](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createramdirectory).
 * > **NOTE:** Available since v1.174.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.eds.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     vswitchName: name,
 * });
 * const defaultRamDirectory = new alicloud.eds.RamDirectory("default", {
 *     desktopAccessType: "INTERNET",
 *     enableAdminAccess: true,
 *     ramDirectoryName: name,
 *     vswitchIds: [defaultSwitch&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eds.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.ids[0],
 *     vswitch_name=name)
 * default_ram_directory = alicloud.eds.RamDirectory("default",
 *     desktop_access_type="INTERNET",
 *     enable_admin_access=True,
 *     ram_directory_name=name,
 *     vswitch_ids=[default_switch&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Eds.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         VswitchName = name,
 *     });
 *     var defaultRamDirectory = new AliCloud.Eds.RamDirectory("default", new()
 *     {
 *         DesktopAccessType = "INTERNET",
 *         EnableAdminAccess = true,
 *         RamDirectoryName = name,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eds.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Ids[0]),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewRamDirectory(ctx, "default", &eds.RamDirectoryArgs{
 * 			DesktopAccessType: pulumi.String("INTERNET"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			RamDirectoryName:  pulumi.String(name),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.EdsFunctions;
 * import com.pulumi.alicloud.eds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.eds.RamDirectory;
 * import com.pulumi.alicloud.eds.RamDirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = EdsFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.ids()[0])
 *             .vswitchName(name)
 *             .build());
 *         var defaultRamDirectory = new RamDirectory("defaultRamDirectory", RamDirectoryArgs.builder()
 *             .desktopAccessType("INTERNET")
 *             .enableAdminAccess(true)
 *             .ramDirectoryName(name)
 *             .vswitchIds(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.ids[0]}
 *       vswitchName: ${name}
 *   defaultRamDirectory:
 *     type: alicloud:eds:RamDirectory
 *     name: default
 *     properties:
 *       desktopAccessType: INTERNET
 *       enableAdminAccess: true
 *       ramDirectoryName: ${name}
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eds:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Ram Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/ramDirectory:RamDirectory example <id>
 * ```
 * @property desktopAccessType The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
 * @property enableAdminAccess Whether to enable public network access.
 * @property enableInternetAccess Whether to grant local administrator rights to users who use cloud desktops.
 * @property ramDirectoryName The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
 * @property vswitchIds List of VSwitch IDs in the directory.
 */
public data class RamDirectoryArgs(
    public val desktopAccessType: Output<String>? = null,
    public val enableAdminAccess: Output<Boolean>? = null,
    public val enableInternetAccess: Output<Boolean>? = null,
    public val ramDirectoryName: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.RamDirectoryArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.RamDirectoryArgs =
        com.pulumi.alicloud.eds.RamDirectoryArgs.builder()
            .desktopAccessType(desktopAccessType?.applyValue({ args0 -> args0 }))
            .enableAdminAccess(enableAdminAccess?.applyValue({ args0 -> args0 }))
            .enableInternetAccess(enableInternetAccess?.applyValue({ args0 -> args0 }))
            .ramDirectoryName(ramDirectoryName?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RamDirectoryArgs].
 */
@PulumiTagMarker
public class RamDirectoryArgsBuilder internal constructor() {
    private var desktopAccessType: Output<String>? = null

    private var enableAdminAccess: Output<Boolean>? = null

    private var enableInternetAccess: Output<Boolean>? = null

    private var ramDirectoryName: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
     */
    @JvmName("pqynprpiwtiitxdy")
    public suspend fun desktopAccessType(`value`: Output<String>) {
        this.desktopAccessType = value
    }

    /**
     * @param value Whether to enable public network access.
     */
    @JvmName("qvcyrjssdttwbbrk")
    public suspend fun enableAdminAccess(`value`: Output<Boolean>) {
        this.enableAdminAccess = value
    }

    /**
     * @param value Whether to grant local administrator rights to users who use cloud desktops.
     */
    @JvmName("knnmanjqtoflfjrb")
    public suspend fun enableInternetAccess(`value`: Output<Boolean>) {
        this.enableInternetAccess = value
    }

    /**
     * @param value The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("pxxhqkseneadbdxc")
    public suspend fun ramDirectoryName(`value`: Output<String>) {
        this.ramDirectoryName = value
    }

    /**
     * @param value List of VSwitch IDs in the directory.
     */
    @JvmName("cjaxtoloiivslfod")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("yvfqtwatvkcosbye")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values List of VSwitch IDs in the directory.
     */
    @JvmName("dspvkquixgabkxdi")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
     */
    @JvmName("qmuvarajduhyeaiu")
    public suspend fun desktopAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopAccessType = mapped
    }

    /**
     * @param value Whether to enable public network access.
     */
    @JvmName("cuychhhjiswsxqwf")
    public suspend fun enableAdminAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdminAccess = mapped
    }

    /**
     * @param value Whether to grant local administrator rights to users who use cloud desktops.
     */
    @JvmName("krimdtrlyjmtsiku")
    public suspend fun enableInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetAccess = mapped
    }

    /**
     * @param value The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("vkwohefweukybhwq")
    public suspend fun ramDirectoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramDirectoryName = mapped
    }

    /**
     * @param value List of VSwitch IDs in the directory.
     */
    @JvmName("fgxeeynyiqgorcgh")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values List of VSwitch IDs in the directory.
     */
    @JvmName("vnsfbwaaidilapys")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): RamDirectoryArgs = RamDirectoryArgs(
        desktopAccessType = desktopAccessType,
        enableAdminAccess = enableAdminAccess,
        enableInternetAccess = enableInternetAccess,
        ramDirectoryName = ramDirectoryName,
        vswitchIds = vswitchIds,
    )
}
