@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SimpleOfficeSite].
 */
@PulumiTagMarker
public class SimpleOfficeSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SimpleOfficeSiteArgs = SimpleOfficeSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SimpleOfficeSiteArgsBuilder.() -> Unit) {
        val builder = SimpleOfficeSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SimpleOfficeSite {
        val builtJavaResource = com.pulumi.alicloud.eds.SimpleOfficeSite(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SimpleOfficeSite(builtJavaResource)
    }
}

/**
 * Provides a ECD Simple Office Site resource.
 * For information about ECD Simple Office Site and how to use it, see [What is Simple Office Site](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createsimpleofficesite).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
 *     cidrBlock: "172.16.0.0/12",
 *     enableAdminAccess: true,
 *     desktopAccessType: "Internet",
 *     officeSiteName: `terraform-example-${_default.result}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
 *     cidr_block="172.16.0.0/12",
 *     enable_admin_access=True,
 *     desktop_access_type="Internet",
 *     office_site_name=f"terraform-example-{default['result']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         EnableAdminAccess = true,
 *         DesktopAccessType = "Internet",
 *         OfficeSiteName = $"terraform-example-{@default.Result}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
 * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			DesktopAccessType: pulumi.String("Internet"),
 * 			OfficeSiteName:    pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.SimpleOfficeSite;
 * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .enableAdminAccess(true)
 *             .desktopAccessType("Internet")
 *             .officeSiteName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSimpleOfficeSite:
 *     type: alicloud:eds:SimpleOfficeSite
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       enableAdminAccess: true
 *       desktopAccessType: Internet
 *       officeSiteName: terraform-example-${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Simple Office Site can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/simpleOfficeSite:SimpleOfficeSite example <id>
 * ```
 */
public class SimpleOfficeSite internal constructor(
    override val javaResource: com.pulumi.alicloud.eds.SimpleOfficeSite,
) : KotlinCustomResource(javaResource, SimpleOfficeSiteMapper) {
    /**
     * The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new resource alicloud_ecd_network_package.
     */
    @Deprecated(
        message = """
  Field 'bandwidth' has been deprecated from provider version 1.142.0.
  """,
    )
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Cloud Enterprise Network Instance ID.
     */
    public val cenId: Output<String>?
        get() = javaResource.cenId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The cen owner id.
     */
    public val cenOwnerId: Output<String>?
        get() = javaResource.cenOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Workspace Corresponds to the Security Office Network of IPv4 Segment.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * Connect to the Cloud Desktop Allows the Use of the Access Mode of. Valid values: `Any`, `Internet`, `VPC`.
     */
    public val desktopAccessType: Output<String>
        get() = javaResource.desktopAccessType().applyValue({ args0 -> args0 })

    /**
     * Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
     */
    public val enableAdminAccess: Output<Boolean>
        get() = javaResource.enableAdminAccess().applyValue({ args0 -> args0 })

    /**
     * Enable Cross-Desktop Access.
     */
    public val enableCrossDesktopAccess: Output<Boolean>
        get() = javaResource.enableCrossDesktopAccess().applyValue({ args0 -> args0 })

    /**
     * Whether the Open Internet Access Function.
     */
    @Deprecated(
        message = """
  Field 'enable_internet_access' has been deprecated from provider version 1.142.0.
  """,
    )
    public val enableInternetAccess: Output<Boolean>
        get() = javaResource.enableInternetAccess().applyValue({ args0 -> args0 })

    /**
     * Whether to Enable Multi-Factor Authentication MFA.
     */
    public val mfaEnabled: Output<Boolean>
        get() = javaResource.mfaEnabled().applyValue({ args0 -> args0 })

    /**
     * The office site name.
     */
    public val officeSiteName: Output<String>?
        get() = javaResource.officeSiteName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to Enable Single Sign-on (SSO) for User-Based SSO.
     */
    public val ssoEnabled: Output<Boolean>
        get() = javaResource.ssoEnabled().applyValue({ args0 -> args0 })

    /**
     * Workspace State. Valid Values: `REGISTERED`,`REGISTERING`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SimpleOfficeSiteMapper : ResourceMapper<SimpleOfficeSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eds.SimpleOfficeSite::class == javaResource::class

    override fun map(javaResource: Resource): SimpleOfficeSite = SimpleOfficeSite(
        javaResource as
            com.pulumi.alicloud.eds.SimpleOfficeSite,
    )
}

/**
 * @see [SimpleOfficeSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SimpleOfficeSite].
 */
public suspend fun simpleOfficeSite(
    name: String,
    block: suspend SimpleOfficeSiteResourceBuilder.() -> Unit,
): SimpleOfficeSite {
    val builder = SimpleOfficeSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SimpleOfficeSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun simpleOfficeSite(name: String): SimpleOfficeSite {
    val builder = SimpleOfficeSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
