@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECD Simple Office Site resource.
 * For information about ECD Simple Office Site and how to use it, see [What is Simple Office Site](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createsimpleofficesite).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultSimpleOfficeSite = new alicloud.eds.SimpleOfficeSite("default", {
 *     cidrBlock: "172.16.0.0/12",
 *     enableAdminAccess: true,
 *     desktopAccessType: "Internet",
 *     officeSiteName: `terraform-example-${_default.result}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
 *     cidr_block="172.16.0.0/12",
 *     enable_admin_access=True,
 *     desktop_access_type="Internet",
 *     office_site_name=f"terraform-example-{default['result']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultSimpleOfficeSite = new AliCloud.Eds.SimpleOfficeSite("default", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         EnableAdminAccess = true,
 *         DesktopAccessType = "Internet",
 *         OfficeSiteName = $"terraform-example-{@default.Result}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eds.NewSimpleOfficeSite(ctx, "default", &eds.SimpleOfficeSiteArgs{
 * 			CidrBlock:         pulumi.String("172.16.0.0/12"),
 * 			EnableAdminAccess: pulumi.Bool(true),
 * 			DesktopAccessType: pulumi.String("Internet"),
 * 			OfficeSiteName:    pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.eds.SimpleOfficeSite;
 * import com.pulumi.alicloud.eds.SimpleOfficeSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultSimpleOfficeSite = new SimpleOfficeSite("defaultSimpleOfficeSite", SimpleOfficeSiteArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .enableAdminAccess(true)
 *             .desktopAccessType("Internet")
 *             .officeSiteName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSimpleOfficeSite:
 *     type: alicloud:eds:SimpleOfficeSite
 *     name: default
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       enableAdminAccess: true
 *       desktopAccessType: Internet
 *       officeSiteName: terraform-example-${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD Simple Office Site can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/simpleOfficeSite:SimpleOfficeSite example <id>
 * ```
 * @property bandwidth The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new resource alicloud_ecd_network_package.
 * @property cenId Cloud Enterprise Network Instance ID.
 * @property cenOwnerId The cen owner id.
 * @property cidrBlock Workspace Corresponds to the Security Office Network of IPv4 Segment.
 * @property desktopAccessType Connect to the Cloud Desktop Allows the Use of the Access Mode of. Valid values: `Any`, `Internet`, `VPC`.
 * @property enableAdminAccess Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
 * @property enableCrossDesktopAccess Enable Cross-Desktop Access.
 * @property enableInternetAccess Whether the Open Internet Access Function.
 * @property mfaEnabled Whether to Enable Multi-Factor Authentication MFA.
 * @property officeSiteName The office site name.
 * @property ssoEnabled Whether to Enable Single Sign-on (SSO) for User-Based SSO.
 */
public data class SimpleOfficeSiteArgs(
    @Deprecated(
        message = """
  Field 'bandwidth' has been deprecated from provider version 1.142.0.
  """,
    )
    public val bandwidth: Output<Int>? = null,
    public val cenId: Output<String>? = null,
    public val cenOwnerId: Output<String>? = null,
    public val cidrBlock: Output<String>? = null,
    public val desktopAccessType: Output<String>? = null,
    public val enableAdminAccess: Output<Boolean>? = null,
    public val enableCrossDesktopAccess: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'enable_internet_access' has been deprecated from provider version 1.142.0.
  """,
    )
    public val enableInternetAccess: Output<Boolean>? = null,
    public val mfaEnabled: Output<Boolean>? = null,
    public val officeSiteName: Output<String>? = null,
    public val ssoEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.SimpleOfficeSiteArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.SimpleOfficeSiteArgs =
        com.pulumi.alicloud.eds.SimpleOfficeSiteArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .cenOwnerId(cenOwnerId?.applyValue({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .desktopAccessType(desktopAccessType?.applyValue({ args0 -> args0 }))
            .enableAdminAccess(enableAdminAccess?.applyValue({ args0 -> args0 }))
            .enableCrossDesktopAccess(enableCrossDesktopAccess?.applyValue({ args0 -> args0 }))
            .enableInternetAccess(enableInternetAccess?.applyValue({ args0 -> args0 }))
            .mfaEnabled(mfaEnabled?.applyValue({ args0 -> args0 }))
            .officeSiteName(officeSiteName?.applyValue({ args0 -> args0 }))
            .ssoEnabled(ssoEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimpleOfficeSiteArgs].
 */
@PulumiTagMarker
public class SimpleOfficeSiteArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var cenId: Output<String>? = null

    private var cenOwnerId: Output<String>? = null

    private var cidrBlock: Output<String>? = null

    private var desktopAccessType: Output<String>? = null

    private var enableAdminAccess: Output<Boolean>? = null

    private var enableCrossDesktopAccess: Output<Boolean>? = null

    private var enableInternetAccess: Output<Boolean>? = null

    private var mfaEnabled: Output<Boolean>? = null

    private var officeSiteName: Output<String>? = null

    private var ssoEnabled: Output<Boolean>? = null

    /**
     * @param value The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new resource alicloud_ecd_network_package.
     */
    @Deprecated(
        message = """
  Field 'bandwidth' has been deprecated from provider version 1.142.0.
  """,
    )
    @JvmName("vqxhojmxjyhsnmwj")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Cloud Enterprise Network Instance ID.
     */
    @JvmName("ngriipxfqvgvjhri")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The cen owner id.
     */
    @JvmName("wgerrwxkjetddmjo")
    public suspend fun cenOwnerId(`value`: Output<String>) {
        this.cenOwnerId = value
    }

    /**
     * @param value Workspace Corresponds to the Security Office Network of IPv4 Segment.
     */
    @JvmName("qichcgyrkkiwewkg")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value Connect to the Cloud Desktop Allows the Use of the Access Mode of. Valid values: `Any`, `Internet`, `VPC`.
     */
    @JvmName("ajrhuigdmbcjdmat")
    public suspend fun desktopAccessType(`value`: Output<String>) {
        this.desktopAccessType = value
    }

    /**
     * @param value Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
     */
    @JvmName("vswtatwuvomnioba")
    public suspend fun enableAdminAccess(`value`: Output<Boolean>) {
        this.enableAdminAccess = value
    }

    /**
     * @param value Enable Cross-Desktop Access.
     */
    @JvmName("wqikdqsimoctlptd")
    public suspend fun enableCrossDesktopAccess(`value`: Output<Boolean>) {
        this.enableCrossDesktopAccess = value
    }

    /**
     * @param value Whether the Open Internet Access Function.
     */
    @Deprecated(
        message = """
  Field 'enable_internet_access' has been deprecated from provider version 1.142.0.
  """,
    )
    @JvmName("ftfvkpggkpkastwo")
    public suspend fun enableInternetAccess(`value`: Output<Boolean>) {
        this.enableInternetAccess = value
    }

    /**
     * @param value Whether to Enable Multi-Factor Authentication MFA.
     */
    @JvmName("juxcqftplvllnhqc")
    public suspend fun mfaEnabled(`value`: Output<Boolean>) {
        this.mfaEnabled = value
    }

    /**
     * @param value The office site name.
     */
    @JvmName("tkkqxoqxrmoigbkk")
    public suspend fun officeSiteName(`value`: Output<String>) {
        this.officeSiteName = value
    }

    /**
     * @param value Whether to Enable Single Sign-on (SSO) for User-Based SSO.
     */
    @JvmName("ryjpxiatbqnafwuh")
    public suspend fun ssoEnabled(`value`: Output<Boolean>) {
        this.ssoEnabled = value
    }

    /**
     * @param value The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new resource alicloud_ecd_network_package.
     */
    @Deprecated(
        message = """
  Field 'bandwidth' has been deprecated from provider version 1.142.0.
  """,
    )
    @JvmName("kqpkvxmenopgrqon")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Cloud Enterprise Network Instance ID.
     */
    @JvmName("emfhxuxuhcedgjnx")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The cen owner id.
     */
    @JvmName("rawqjnnwfumenvmk")
    public suspend fun cenOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenOwnerId = mapped
    }

    /**
     * @param value Workspace Corresponds to the Security Office Network of IPv4 Segment.
     */
    @JvmName("iqvmygsqrcxbbilv")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value Connect to the Cloud Desktop Allows the Use of the Access Mode of. Valid values: `Any`, `Internet`, `VPC`.
     */
    @JvmName("tkyhacdpceatcukg")
    public suspend fun desktopAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desktopAccessType = mapped
    }

    /**
     * @param value Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
     */
    @JvmName("wlrgewhpsghjmuey")
    public suspend fun enableAdminAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdminAccess = mapped
    }

    /**
     * @param value Enable Cross-Desktop Access.
     */
    @JvmName("fflfblnsrhegmuhf")
    public suspend fun enableCrossDesktopAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCrossDesktopAccess = mapped
    }

    /**
     * @param value Whether the Open Internet Access Function.
     */
    @Deprecated(
        message = """
  Field 'enable_internet_access' has been deprecated from provider version 1.142.0.
  """,
    )
    @JvmName("tsyydemqfegwndvh")
    public suspend fun enableInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetAccess = mapped
    }

    /**
     * @param value Whether to Enable Multi-Factor Authentication MFA.
     */
    @JvmName("bfmdotauudlftxnl")
    public suspend fun mfaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaEnabled = mapped
    }

    /**
     * @param value The office site name.
     */
    @JvmName("pvqpnkvygnfyluru")
    public suspend fun officeSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.officeSiteName = mapped
    }

    /**
     * @param value Whether to Enable Single Sign-on (SSO) for User-Based SSO.
     */
    @JvmName("oabhplrywhksxpvi")
    public suspend fun ssoEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoEnabled = mapped
    }

    internal fun build(): SimpleOfficeSiteArgs = SimpleOfficeSiteArgs(
        bandwidth = bandwidth,
        cenId = cenId,
        cenOwnerId = cenOwnerId,
        cidrBlock = cidrBlock,
        desktopAccessType = desktopAccessType,
        enableAdminAccess = enableAdminAccess,
        enableCrossDesktopAccess = enableCrossDesktopAccess,
        enableInternetAccess = enableInternetAccess,
        mfaEnabled = mfaEnabled,
        officeSiteName = officeSiteName,
        ssoEnabled = ssoEnabled,
    )
}
