@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin

import com.pulumi.alicloud.eds.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Elastic Desktop Service (ECD) User resource.
 * For information about Elastic Desktop Service (ECD) User and how to use it, see [What is User](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-eds-user-2021-03-08-createusers-desktop).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.eds.User("default", {
 *     endUserId: "terraform_example123",
 *     email: "tf.example@abc.com",
 *     phone: "18888888888",
 *     password: "Example_123",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.eds.User("default",
 *     end_user_id="terraform_example123",
 *     email="tf.example@abc.com",
 *     phone="18888888888",
 *     password="Example_123")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Eds.User("default", new()
 *     {
 *         EndUserId = "terraform_example123",
 *         Email = "tf.example@abc.com",
 *         Phone = "18888888888",
 *         Password = "Example_123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eds.NewUser(ctx, "default", &eds.UserArgs{
 * 			EndUserId: pulumi.String("terraform_example123"),
 * 			Email:     pulumi.String("tf.example@abc.com"),
 * 			Phone:     pulumi.String("18888888888"),
 * 			Password:  pulumi.String("Example_123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eds.User;
 * import com.pulumi.alicloud.eds.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new User("default", UserArgs.builder()
 *             .endUserId("terraform_example123")
 *             .email("tf.example@abc.com")
 *             .phone("18888888888")
 *             .password("Example_123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:eds:User
 *     properties:
 *       endUserId: terraform_example123
 *       email: tf.example@abc.com
 *       phone: '18888888888'
 *       password: Example_123
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECD User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eds/user:User example <end_user_id>
 * ```
 * @property email The email of the user email.
 * @property endUserId The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
 * @property password The password of the user password.
 * @property phone The phone of the mobile phone number.
 * @property status The status of the resource. Valid values: `Unlocked`, `Locked`.
 */
public data class UserArgs(
    public val email: Output<String>? = null,
    public val endUserId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val phone: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.UserArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.UserArgs =
        com.pulumi.alicloud.eds.UserArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .endUserId(endUserId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .phone(phone?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var endUserId: Output<String>? = null

    private var password: Output<String>? = null

    private var phone: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The email of the user email.
     */
    @JvmName("mblkbjijgkkujgms")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
     */
    @JvmName("prbxgwdyoagbybap")
    public suspend fun endUserId(`value`: Output<String>) {
        this.endUserId = value
    }

    /**
     * @param value The password of the user password.
     */
    @JvmName("owhyrrlcwcfyqiau")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The phone of the mobile phone number.
     */
    @JvmName("lgmbfxafyfjjseop")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value The status of the resource. Valid values: `Unlocked`, `Locked`.
     */
    @JvmName("peerqnxjedlenhme")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The email of the user email.
     */
    @JvmName("mwfrdmgjtvnfyfxn")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
     */
    @JvmName("kaiqtpyoncbhajqb")
    public suspend fun endUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endUserId = mapped
    }

    /**
     * @param value The password of the user password.
     */
    @JvmName("vnuvhgvphmgtxmtp")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The phone of the mobile phone number.
     */
    @JvmName("gobrwprjxmghphbj")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Unlocked`, `Locked`.
     */
    @JvmName("eewdyinjuxbpdcpw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        email = email,
        endUserId = endUserId,
        password = password,
        phone = phone,
        status = status,
    )
}
