@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property propertyValue The value of an attribute.
 * @property propertyValueId The value of an attribute id.
 */
public data class CustomPropertyPropertyValueArgs(
    public val propertyValue: Output<String>? = null,
    public val propertyValueId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs =
        com.pulumi.alicloud.eds.inputs.CustomPropertyPropertyValueArgs.builder()
            .propertyValue(propertyValue?.applyValue({ args0 -> args0 }))
            .propertyValueId(propertyValueId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomPropertyPropertyValueArgs].
 */
@PulumiTagMarker
public class CustomPropertyPropertyValueArgsBuilder internal constructor() {
    private var propertyValue: Output<String>? = null

    private var propertyValueId: Output<String>? = null

    /**
     * @param value The value of an attribute.
     */
    @JvmName("muajtvlxcqjnkbay")
    public suspend fun propertyValue(`value`: Output<String>) {
        this.propertyValue = value
    }

    /**
     * @param value The value of an attribute id.
     */
    @JvmName("rgjtbxklgppstbnl")
    public suspend fun propertyValueId(`value`: Output<String>) {
        this.propertyValueId = value
    }

    /**
     * @param value The value of an attribute.
     */
    @JvmName("hrweypegcraniomj")
    public suspend fun propertyValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyValue = mapped
    }

    /**
     * @param value The value of an attribute id.
     */
    @JvmName("txocidulgpiawelp")
    public suspend fun propertyValueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyValueId = mapped
    }

    internal fun build(): CustomPropertyPropertyValueArgs = CustomPropertyPropertyValueArgs(
        propertyValue = propertyValue,
        propertyValueId = propertyValueId,
    )
}
