@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrIp The cidrip of authorize access rule.
 * @property description The description of authorize access rule.
 */
public data class EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
    public val cidrIp: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs = com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs.builder()
        .cidrIp(cidrIp?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcdPolicyGroupAuthorizeAccessPolicyRuleArgs].
 */
@PulumiTagMarker
public class EcdPolicyGroupAuthorizeAccessPolicyRuleArgsBuilder internal constructor() {
    private var cidrIp: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value The cidrip of authorize access rule.
     */
    @JvmName("vdqgbgibbeohvyka")
    public suspend fun cidrIp(`value`: Output<String>) {
        this.cidrIp = value
    }

    /**
     * @param value The description of authorize access rule.
     */
    @JvmName("tswiinffogsqgmrk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The cidrip of authorize access rule.
     */
    @JvmName("dehfeedqoafcqfaf")
    public suspend fun cidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIp = mapped
    }

    /**
     * @param value The description of authorize access rule.
     */
    @JvmName("ghrhamsfalywsauh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): EcdPolicyGroupAuthorizeAccessPolicyRuleArgs =
        EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
            cidrIp = cidrIp,
            description = description,
        )
}
