@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrIp The cidrip of security rules.
 * @property description The description of security rules.
 * @property ipProtocol The ip protocol of security rules.
 * @property policy The policy of security rules.
 * @property portRange The port range of security rules.
 * @property priority The priority of security rules.
 * @property type The type of security rules.
 */
public data class EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
    public val cidrIp: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ipProtocol: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val portRange: Output<String>? = null,
    public val priority: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs =
        com.pulumi.alicloud.eds.inputs.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs.builder()
            .cidrIp(cidrIp?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .portRange(portRange?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs].
 */
@PulumiTagMarker
public class EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsBuilder internal constructor() {
    private var cidrIp: Output<String>? = null

    private var description: Output<String>? = null

    private var ipProtocol: Output<String>? = null

    private var policy: Output<String>? = null

    private var portRange: Output<String>? = null

    private var priority: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The cidrip of security rules.
     */
    @JvmName("rgsquqbyolyobpnv")
    public suspend fun cidrIp(`value`: Output<String>) {
        this.cidrIp = value
    }

    /**
     * @param value The description of security rules.
     */
    @JvmName("yaisbbkaivmfsngx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ip protocol of security rules.
     */
    @JvmName("vecfyrebpaqrattj")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The policy of security rules.
     */
    @JvmName("ssamfklgpwpfkdwo")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The port range of security rules.
     */
    @JvmName("mseqjpecsvprjihr")
    public suspend fun portRange(`value`: Output<String>) {
        this.portRange = value
    }

    /**
     * @param value The priority of security rules.
     */
    @JvmName("tyweldxnnrckbpwo")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value The type of security rules.
     */
    @JvmName("prlqqtsmqpxbbfne")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The cidrip of security rules.
     */
    @JvmName("ppeyfggqityuydet")
    public suspend fun cidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIp = mapped
    }

    /**
     * @param value The description of security rules.
     */
    @JvmName("ydlvvporfccgklug")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ip protocol of security rules.
     */
    @JvmName("qrwimysqlljvfgbf")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The policy of security rules.
     */
    @JvmName("tfdkpckjxdlkakon")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The port range of security rules.
     */
    @JvmName("crwqpvintgemldcw")
    public suspend fun portRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRange = mapped
    }

    /**
     * @param value The priority of security rules.
     */
    @JvmName("iqqbrcpirpwscnsi")
    public suspend fun priority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of security rules.
     */
    @JvmName("ivojawfwcmpieiri")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs =
        EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
            cidrIp = cidrIp,
            description = description,
            ipProtocol = ipProtocol,
            policy = policy,
            portRange = portRange,
            priority = priority,
            type = type,
        )
}
