@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetAdConnectorOfficeSitesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAdConnectorOfficeSites.
 * @property ids A list of Ad Connector Office Site IDs.
 * @property nameRegex A regex string to filter results by Ad Connector Office Site name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The workspace status. Valid values:
 * - `REGISTERING`: The workspace is being registered.
 * - `REGISTERED`: The workspace is registered.
 * - `DEREGISTERING`: The workspace is being deregistered.
 * - `DEREGISTERED`: The workspace is deregistered.
 * - `ERROR`: The configurations of the workspace are invalid.
 * - `NEEDCONFIGTRUST`: The trust relationship needs to be configured.
 * - `NEEDCONFIGUSER`: Users need to be configured.
 * - `CONFIGTRUSTING`: The trust relationship is being configured.
 * - `CONFIGTRUSTFAILED`: The trust relationship fails to be configured.
 */
public data class GetAdConnectorOfficeSitesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetAdConnectorOfficeSitesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetAdConnectorOfficeSitesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetAdConnectorOfficeSitesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdConnectorOfficeSitesPlainArgs].
 */
@PulumiTagMarker
public class GetAdConnectorOfficeSitesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Ad Connector Office Site IDs.
     */
    @JvmName("wnvsrpcwkuekjtci")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ad Connector Office Site IDs.
     */
    @JvmName("wfnqeaqcalwntxgy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Ad Connector Office Site name.
     */
    @JvmName("xyahnsuryykgtpmk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("urersgwvelmrbyrk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The workspace status. Valid values:
     * - `REGISTERING`: The workspace is being registered.
     * - `REGISTERED`: The workspace is registered.
     * - `DEREGISTERING`: The workspace is being deregistered.
     * - `DEREGISTERED`: The workspace is deregistered.
     * - `ERROR`: The configurations of the workspace are invalid.
     * - `NEEDCONFIGTRUST`: The trust relationship needs to be configured.
     * - `NEEDCONFIGUSER`: Users need to be configured.
     * - `CONFIGTRUSTING`: The trust relationship is being configured.
     * - `CONFIGTRUSTFAILED`: The trust relationship fails to be configured.
     */
    @JvmName("mhikunlxuyemhtfi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAdConnectorOfficeSitesPlainArgs = GetAdConnectorOfficeSitesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
