@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetBundlesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBundles.
 * @property bundleIds
 * @property bundleType The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
 * @property ids A list of Bundle IDs.
 * @property nameRegex A regex string to filter results by Bundle name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBundlesPlainArgs(
    public val bundleIds: List<String>? = null,
    public val bundleType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetBundlesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetBundlesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetBundlesPlainArgs.builder()
            .bundleIds(bundleIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .bundleType(bundleType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBundlesPlainArgs].
 */
@PulumiTagMarker
public class GetBundlesPlainArgsBuilder internal constructor() {
    private var bundleIds: List<String>? = null

    private var bundleType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("lsjkdonpodehukfk")
    public suspend fun bundleIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bundleIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("qxuoqixusllktaks")
    public suspend fun bundleIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bundleIds = mapped
    }

    /**
     * @param value The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
     */
    @JvmName("uddbwohxyjjtfjjj")
    public suspend fun bundleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bundleType = mapped
    }

    /**
     * @param value A list of Bundle IDs.
     */
    @JvmName("xyxibdgyuiwmavtb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Bundle IDs.
     */
    @JvmName("yiqvnderwyeocokb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Bundle name.
     */
    @JvmName("daacyyysqkxalkqr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("otyisoyosenphlsx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBundlesPlainArgs = GetBundlesPlainArgs(
        bundleIds = bundleIds,
        bundleType = bundleType,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
