@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetCommandsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCommands.
 * @property commandType The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
 * @property contentEncoding That Returns the Data Encoding Method. Valid values: `Base64`, `PlainText`.
 * @property desktopId The desktop id of the Desktop.
 * @property ids A list of Command IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
 */
public data class GetCommandsPlainArgs(
    public val commandType: String? = null,
    public val contentEncoding: String? = null,
    public val desktopId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetCommandsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetCommandsPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetCommandsPlainArgs.builder()
            .commandType(commandType?.let({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.let({ args0 -> args0 }))
            .desktopId(desktopId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommandsPlainArgs].
 */
@PulumiTagMarker
public class GetCommandsPlainArgsBuilder internal constructor() {
    private var commandType: String? = null

    private var contentEncoding: String? = null

    private var desktopId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
     */
    @JvmName("jndrbyuvksyvsdgx")
    public suspend fun commandType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.commandType = mapped
    }

    /**
     * @param value That Returns the Data Encoding Method. Valid values: `Base64`, `PlainText`.
     */
    @JvmName("ulhutqvcuqpupkah")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentEncoding = mapped
    }

    /**
     * @param value The desktop id of the Desktop.
     */
    @JvmName("ickvvanvigrkfvwa")
    public suspend fun desktopId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.desktopId = mapped
    }

    /**
     * @param value A list of Command IDs.
     */
    @JvmName("tcxopthwokrpamkl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Command IDs.
     */
    @JvmName("bbcsvsflcxgebrhg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dwbkwhnjaxfnsbso")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
     */
    @JvmName("lbhwobqwsoslhgyo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetCommandsPlainArgs = GetCommandsPlainArgs(
        commandType = commandType,
        contentEncoding = contentEncoding,
        desktopId = desktopId,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
