@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetCustomPropertiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomProperties.
 * @property ids A list of Custom Property IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetCustomPropertiesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetCustomPropertiesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetCustomPropertiesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetCustomPropertiesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomPropertiesPlainArgs].
 */
@PulumiTagMarker
public class GetCustomPropertiesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Custom Property IDs.
     */
    @JvmName("gfeshrnragpyylke")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Custom Property IDs.
     */
    @JvmName("ohyoivjlwmunghol")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jbrwudoeuukmwaxd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCustomPropertiesPlainArgs = GetCustomPropertiesPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
