@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetDesktopTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDesktopTypes.
 * @property cpuCount The CPU cores.
 * @property gpuCount The GPU cores.
 * @property ids A list of Desktop Type IDs.
 * @property instanceTypeFamily The Specification family. Valid values: `eds.graphics`, `eds.hf`, `eds.general`, `ecd.graphics`, `ecd.performance`, `ecd.advanced`, `ecd.basic`.
 * @property memorySize The Memory size. Unit: MiB.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `SUFFICIENT`.
 */
public data class GetDesktopTypesPlainArgs(
    public val cpuCount: Int? = null,
    public val gpuCount: Double? = null,
    public val ids: List<String>? = null,
    public val instanceTypeFamily: String? = null,
    public val memorySize: Int? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetDesktopTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetDesktopTypesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetDesktopTypesPlainArgs.builder()
            .cpuCount(cpuCount?.let({ args0 -> args0 }))
            .gpuCount(gpuCount?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceTypeFamily(instanceTypeFamily?.let({ args0 -> args0 }))
            .memorySize(memorySize?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDesktopTypesPlainArgs].
 */
@PulumiTagMarker
public class GetDesktopTypesPlainArgsBuilder internal constructor() {
    private var cpuCount: Int? = null

    private var gpuCount: Double? = null

    private var ids: List<String>? = null

    private var instanceTypeFamily: String? = null

    private var memorySize: Int? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The CPU cores.
     */
    @JvmName("texixswlxcbtvqmn")
    public suspend fun cpuCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cpuCount = mapped
    }

    /**
     * @param value The GPU cores.
     */
    @JvmName("afptpdbqqwyqqriy")
    public suspend fun gpuCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gpuCount = mapped
    }

    /**
     * @param value A list of Desktop Type IDs.
     */
    @JvmName("qxfacxvsjwygypgs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Desktop Type IDs.
     */
    @JvmName("slbythuvvwcohwmv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Specification family. Valid values: `eds.graphics`, `eds.hf`, `eds.general`, `ecd.graphics`, `ecd.performance`, `ecd.advanced`, `ecd.basic`.
     */
    @JvmName("jalrnipsnmbeivqt")
    public suspend fun instanceTypeFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceTypeFamily = mapped
    }

    /**
     * @param value The Memory size. Unit: MiB.
     */
    @JvmName("pmyqxxoaptscxdic")
    public suspend fun memorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memorySize = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nymtdkswkywtwycf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `SUFFICIENT`.
     */
    @JvmName("tfmmkdiijjhkrjuu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDesktopTypesPlainArgs = GetDesktopTypesPlainArgs(
        cpuCount = cpuCount,
        gpuCount = gpuCount,
        ids = ids,
        instanceTypeFamily = instanceTypeFamily,
        memorySize = memorySize,
        outputFile = outputFile,
        status = status,
    )
}
