@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetDesktopsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDesktops.
 * @property desktopName The desktop name.
 * @property endUserIds
 * @property ids A list of Desktop IDs.
 * @property nameRegex A regex string to filter results by Desktop name.
 * @property officeSiteId The ID of the Simple Office Site.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyGroupId The policy group id of the Desktop.
 * @property status The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
 */
public data class GetDesktopsPlainArgs(
    public val desktopName: String? = null,
    public val endUserIds: List<String>? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val officeSiteId: String? = null,
    public val outputFile: String? = null,
    public val policyGroupId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetDesktopsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetDesktopsPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetDesktopsPlainArgs.builder()
            .desktopName(desktopName?.let({ args0 -> args0 }))
            .endUserIds(endUserIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .officeSiteId(officeSiteId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyGroupId(policyGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDesktopsPlainArgs].
 */
@PulumiTagMarker
public class GetDesktopsPlainArgsBuilder internal constructor() {
    private var desktopName: String? = null

    private var endUserIds: List<String>? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var officeSiteId: String? = null

    private var outputFile: String? = null

    private var policyGroupId: String? = null

    private var status: String? = null

    /**
     * @param value The desktop name.
     */
    @JvmName("woscxqaqngecycya")
    public suspend fun desktopName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.desktopName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bsetukbbdmdjhgfl")
    public suspend fun endUserIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endUserIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("oyxvhkslsenrrnqi")
    public suspend fun endUserIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endUserIds = mapped
    }

    /**
     * @param value A list of Desktop IDs.
     */
    @JvmName("mjcwddsmlfixcjgh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Desktop IDs.
     */
    @JvmName("oxijlskbaafkucsl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Desktop name.
     */
    @JvmName("eqaafyskdhwxgiyx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The ID of the Simple Office Site.
     */
    @JvmName("debtvmvlhxndkovb")
    public suspend fun officeSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.officeSiteId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rdxvjqtkmpnybvvo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The policy group id of the Desktop.
     */
    @JvmName("miwvjqkkbhgphjav")
    public suspend fun policyGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyGroupId = mapped
    }

    /**
     * @param value The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
     */
    @JvmName("dqontmrisjekwbew")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDesktopsPlainArgs = GetDesktopsPlainArgs(
        desktopName = desktopName,
        endUserIds = endUserIds,
        ids = ids,
        nameRegex = nameRegex,
        officeSiteId = officeSiteId,
        outputFile = outputFile,
        policyGroupId = policyGroupId,
        status = status,
    )
}
