@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetImagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImages.
 * @property desktopInstanceType The desktop type of the image.
 * @property ids A list of Image IDs.
 * @property imageType The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
 * @property nameRegex A regex string to filter results by Image name.
 * @property osType The operating system type of the image. Valid values: `Windows` and `Linux`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
 */
public data class GetImagesPlainArgs(
    public val desktopInstanceType: String? = null,
    public val ids: List<String>? = null,
    public val imageType: String? = null,
    public val nameRegex: String? = null,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetImagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetImagesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetImagesPlainArgs.builder()
            .desktopInstanceType(desktopInstanceType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .imageType(imageType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .osType(osType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagesPlainArgs].
 */
@PulumiTagMarker
public class GetImagesPlainArgsBuilder internal constructor() {
    private var desktopInstanceType: String? = null

    private var ids: List<String>? = null

    private var imageType: String? = null

    private var nameRegex: String? = null

    private var osType: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The desktop type of the image.
     */
    @JvmName("cyognfuegitecsud")
    public suspend fun desktopInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.desktopInstanceType = mapped
    }

    /**
     * @param value A list of Image IDs.
     */
    @JvmName("pvsfalwtpqvtglru")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Image IDs.
     */
    @JvmName("bwispclcurxmqwfj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
     */
    @JvmName("ixqaoukxdehmnvui")
    public suspend fun imageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageType = mapped
    }

    /**
     * @param value A regex string to filter results by Image name.
     */
    @JvmName("bmbcerrmtxyfvlyv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The operating system type of the image. Valid values: `Windows` and `Linux`.
     */
    @JvmName("rmvqnxetvpdqoxnn")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.osType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("blymuemohyxpbrtm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
     */
    @JvmName("jspvepdmhxafxmhx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetImagesPlainArgs = GetImagesPlainArgs(
        desktopInstanceType = desktopInstanceType,
        ids = ids,
        imageType = imageType,
        nameRegex = nameRegex,
        osType = osType,
        outputFile = outputFile,
        status = status,
    )
}
