@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetNasFileSystemsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNasFileSystems.
 * @property ids A list of Nas File System IDs.
 * @property nameRegex A regex string to filter results by Nas File System name.
 * @property officeSiteId The ID of office site.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
 */
public data class GetNasFileSystemsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val officeSiteId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetNasFileSystemsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetNasFileSystemsPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetNasFileSystemsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .officeSiteId(officeSiteId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNasFileSystemsPlainArgs].
 */
@PulumiTagMarker
public class GetNasFileSystemsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var officeSiteId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Nas File System IDs.
     */
    @JvmName("ummgcruejvssdgnw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Nas File System IDs.
     */
    @JvmName("gugaoyqexjxvujym")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Nas File System name.
     */
    @JvmName("rgnmyisldmapsnyp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The ID of office site.
     */
    @JvmName("qbwoftbrrveudwdg")
    public suspend fun officeSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.officeSiteId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rqouqjhpluouotqy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
     */
    @JvmName("ygsudgrurpxtvapm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetNasFileSystemsPlainArgs = GetNasFileSystemsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        officeSiteId = officeSiteId,
        outputFile = outputFile,
        status = status,
    )
}
