@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetNetworkPackagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkPackages.
 * @property ids A list of Network Package IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
 */
public data class GetNetworkPackagesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetNetworkPackagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetNetworkPackagesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetNetworkPackagesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkPackagesPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkPackagesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Network Package IDs.
     */
    @JvmName("bsunwyoargcemisd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Network Package IDs.
     */
    @JvmName("hqnkvdsgatbpjdae")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("erlfgpumginxbdfy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
     */
    @JvmName("rmriqywvdstkqtja")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetNetworkPackagesPlainArgs = GetNetworkPackagesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
