@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetSimpleOfficeSitesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSimpleOfficeSites.
 * @property ids A list of Simple Office Site IDs.
 * @property nameRegex A regex string to filter results by Simple Office Site name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Workspace State. Valid values: `REGISTERED`,`REGISTERING`.
 */
public data class GetSimpleOfficeSitesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetSimpleOfficeSitesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetSimpleOfficeSitesPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetSimpleOfficeSitesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSimpleOfficeSitesPlainArgs].
 */
@PulumiTagMarker
public class GetSimpleOfficeSitesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Simple Office Site IDs.
     */
    @JvmName("rbjbfkhacsyhskkg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Simple Office Site IDs.
     */
    @JvmName("hhbqohqduxobckdm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Simple Office Site name.
     */
    @JvmName("agagkgttwijeyows")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nkhvyjdiaqrwcqaf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Workspace State. Valid values: `REGISTERED`,`REGISTERING`.
     */
    @JvmName("jxfduodquneoddhx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSimpleOfficeSitesPlainArgs = GetSimpleOfficeSitesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
