@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.inputs

import com.pulumi.alicloud.eds.inputs.GetSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshots.
 * @property desktopId The ID of the Desktop.
 * @property ids A list of Snapshot IDs.
 * @property nameRegex A regex string to filter results by Snapshot name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property snapshotId The ID of the Snapshot.
 */
public data class GetSnapshotsPlainArgs(
    public val desktopId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val snapshotId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eds.inputs.GetSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eds.inputs.GetSnapshotsPlainArgs =
        com.pulumi.alicloud.eds.inputs.GetSnapshotsPlainArgs.builder()
            .desktopId(desktopId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .snapshotId(snapshotId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotsPlainArgsBuilder internal constructor() {
    private var desktopId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var snapshotId: String? = null

    /**
     * @param value The ID of the Desktop.
     */
    @JvmName("pdksojbykahvbgef")
    public suspend fun desktopId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.desktopId = mapped
    }

    /**
     * @param value A list of Snapshot IDs.
     */
    @JvmName("pbsocvrefrsbqusv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot IDs.
     */
    @JvmName("alyhtrucuunvfxna")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Snapshot name.
     */
    @JvmName("oxjctovmrykwhtsq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ulvwutndtjpcmqxc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Snapshot.
     */
    @JvmName("ytnwryjkyuxdfnvc")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotId = mapped
    }

    internal fun build(): GetSnapshotsPlainArgs = GetSnapshotsPlainArgs(
        desktopId = desktopId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        snapshotId = snapshotId,
    )
}
