@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrIp The cidrip of security rules.
 * @property description The description of security rules.
 * @property ipProtocol The ip protocol of security rules.
 * @property policy The policy of security rules.
 * @property portRange The port range of security rules.
 * @property priority The priority of security rules.
 * @property type The type of security rules.
 */
public data class EcdPolicyGroupAuthorizeSecurityPolicyRule(
    public val cidrIp: String? = null,
    public val description: String? = null,
    public val ipProtocol: String? = null,
    public val policy: String? = null,
    public val portRange: String? = null,
    public val priority: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.EcdPolicyGroupAuthorizeSecurityPolicyRule): EcdPolicyGroupAuthorizeSecurityPolicyRule = EcdPolicyGroupAuthorizeSecurityPolicyRule(
            cidrIp = javaType.cidrIp().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            ipProtocol = javaType.ipProtocol().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            portRange = javaType.portRange().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
