@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adConnectorDirectoryId The ID of the ad connector directory.
 * @property adConnectors The AD connectors.
 * @property createTime The CreateTime of resource.
 * @property customSecurityGroupId The ID of the security group.
 * @property directoryName The name of directory.
 * @property directoryType The name of the domain.
 * @property dnsAddresses The address of DNSAddress.
 * @property dnsUserName The username of DNS.
 * @property domainName The name of the domain.
 * @property domainUserName domain admin user name.
 * @property enableAdminAccess Whether to grant local administrator rights to users who use cloud desktops.
 * @property id The ID of the Ad Connector Directory.
 * @property mfaEnabled Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device.
 * @property status The status of directory.
 * @property subDnsAddresses The Enterprise already has the DNS address of the AD subdomain.
 * @property subDomainName The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
 * @property trustPassword The trust password.
 * @property vpcId The ID of the vpc.
 * @property vswitchIds List of vSwitch IDs in the directory.
 */
public data class GetAdConnectorDirectoriesDirectory(
    public val adConnectorDirectoryId: String,
    public val adConnectors: List<GetAdConnectorDirectoriesDirectoryAdConnector>,
    public val createTime: String,
    public val customSecurityGroupId: String,
    public val directoryName: String,
    public val directoryType: String,
    public val dnsAddresses: List<String>,
    public val dnsUserName: String,
    public val domainName: String,
    public val domainUserName: String,
    public val enableAdminAccess: Boolean,
    public val id: String,
    public val mfaEnabled: Boolean,
    public val status: String,
    public val subDnsAddresses: List<String>,
    public val subDomainName: String,
    public val trustPassword: String,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetAdConnectorDirectoriesDirectory): GetAdConnectorDirectoriesDirectory = GetAdConnectorDirectoriesDirectory(
            adConnectorDirectoryId = javaType.adConnectorDirectoryId(),
            adConnectors = javaType.adConnectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorDirectoriesDirectoryAdConnector.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            customSecurityGroupId = javaType.customSecurityGroupId(),
            directoryName = javaType.directoryName(),
            directoryType = javaType.directoryType(),
            dnsAddresses = javaType.dnsAddresses().map({ args0 -> args0 }),
            dnsUserName = javaType.dnsUserName(),
            domainName = javaType.domainName(),
            domainUserName = javaType.domainUserName(),
            enableAdminAccess = javaType.enableAdminAccess(),
            id = javaType.id(),
            mfaEnabled = javaType.mfaEnabled(),
            status = javaType.status(),
            subDnsAddresses = javaType.subDnsAddresses().map({ args0 -> args0 }),
            subDomainName = javaType.subDomainName(),
            trustPassword = javaType.trustPassword(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
