@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adConnectorOfficeSiteName The Name of the ad connector office site.
 * @property adConnectors AD Connector Collection of Information.
 * @property bandwidth The Internet Bandwidth Peak. Possible Values: 0~200. If This Field Is Set to 0, Indicates That There Is No Open Internet Access.
 * @property cenId Cloud Enterprise Network Instance Id.
 * @property cidrBlock Workspace Corresponds to the Security Office Network of IPv4 Segment.
 * @property createTime Workspace Creation Time.
 * @property customSecurityGroupId Security Group ID.
 * @property desktopAccessType The method that is used to connect the client to cloud desktops.
 * @property desktopVpcEndpoint The endpoint that is used to connect to cloud desktops over a VPC.
 * @property dnsAddresses Enterprise Ad Corresponding DNS Address.
 * @property dnsUserName The Easy-to-Use DNS Name.
 * @property domainName Enterprise of Ad Domain Name.
 * @property domainUserName The Domain Administrator's Username.
 * @property enableAdminAccess Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
 * @property enableCrossDesktopAccess Indicates whether the desktop communication feature is enabled for cloud desktops in the same workspace. After the feature is enabled, the cloud desktops in the same workspace can access each other.
 * @property enableInternetAccess Whether the Open Internet Access Function.
 * @property fileSystemIds NAS File System ID.
 * @property id The ID of the Ad Connector Office Site.
 * @property logs Registered Log Information.
 * @property mfaEnabled Whether to Enable Multi-Factor Authentication MFA.
 * @property networkPackageId The ID of the Internet Access.
 * @property officeSiteId The ID of the Workspace.
 * @property officeSiteType Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
 * @property ssoEnabled Whether to Enable Single Sign-on (SSO) for User-Based SSO.
 * @property status The workspace status.
 * @property subDomainDnsAddresses Sub-Domain DNS Address.
 * @property subDomainName The AD Domain DNS Name.
 * @property trustPassword The AD Trust Password.
 * @property vpcId Security Office VPC ID.
 * @property vswitchIds The vswitch ids.
 */
public data class GetAdConnectorOfficeSitesSite(
    public val adConnectorOfficeSiteName: String,
    public val adConnectors: List<GetAdConnectorOfficeSitesSiteAdConnector>,
    public val bandwidth: Int,
    public val cenId: String,
    public val cidrBlock: String,
    public val createTime: String,
    public val customSecurityGroupId: String,
    public val desktopAccessType: String,
    public val desktopVpcEndpoint: String,
    public val dnsAddresses: List<String>,
    public val dnsUserName: String,
    public val domainName: String,
    public val domainUserName: String,
    public val enableAdminAccess: Boolean,
    public val enableCrossDesktopAccess: Boolean,
    public val enableInternetAccess: Boolean,
    public val fileSystemIds: List<String>,
    public val id: String,
    public val logs: List<GetAdConnectorOfficeSitesSiteLog>,
    public val mfaEnabled: Boolean,
    public val networkPackageId: String,
    public val officeSiteId: String,
    public val officeSiteType: String,
    public val ssoEnabled: Boolean,
    public val status: String,
    public val subDomainDnsAddresses: List<String>,
    public val subDomainName: String,
    public val trustPassword: String,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetAdConnectorOfficeSitesSite): GetAdConnectorOfficeSitesSite = GetAdConnectorOfficeSitesSite(
            adConnectorOfficeSiteName = javaType.adConnectorOfficeSiteName(),
            adConnectors = javaType.adConnectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorOfficeSitesSiteAdConnector.Companion.toKotlin(args0)
                })
            }),
            bandwidth = javaType.bandwidth(),
            cenId = javaType.cenId(),
            cidrBlock = javaType.cidrBlock(),
            createTime = javaType.createTime(),
            customSecurityGroupId = javaType.customSecurityGroupId(),
            desktopAccessType = javaType.desktopAccessType(),
            desktopVpcEndpoint = javaType.desktopVpcEndpoint(),
            dnsAddresses = javaType.dnsAddresses().map({ args0 -> args0 }),
            dnsUserName = javaType.dnsUserName(),
            domainName = javaType.domainName(),
            domainUserName = javaType.domainUserName(),
            enableAdminAccess = javaType.enableAdminAccess(),
            enableCrossDesktopAccess = javaType.enableCrossDesktopAccess(),
            enableInternetAccess = javaType.enableInternetAccess(),
            fileSystemIds = javaType.fileSystemIds().map({ args0 -> args0 }),
            id = javaType.id(),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetAdConnectorOfficeSitesSiteLog.Companion.toKotlin(args0)
                })
            }),
            mfaEnabled = javaType.mfaEnabled(),
            networkPackageId = javaType.networkPackageId(),
            officeSiteId = javaType.officeSiteId(),
            officeSiteType = javaType.officeSiteType(),
            ssoEnabled = javaType.ssoEnabled(),
            status = javaType.status(),
            subDomainDnsAddresses = javaType.subDomainDnsAddresses().map({ args0 -> args0 }),
            subDomainName = javaType.subDomainName(),
            trustPassword = javaType.trustPassword(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
