@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adConnectorAddress AD Connector across Zones, Its Connection Addresses.
 * @property connectorStatus AD Connector of the State. Possible Values: Creating: in the Creation of. Connecting: Connection. Requires the User to Your Own Ad Configured on the Domain to Which. Running: Run. Expired: If You Are out-of-Date. CONNECT_ERROR: Connection Error.
 * @property networkInterfaceId AD Connector Mount of the Card ID.
 * @property vswitchId AD Connector in the Network Corresponding to the ID of the vSwitch in.
 */
public data class GetAdConnectorOfficeSitesSiteAdConnector(
    public val adConnectorAddress: String,
    public val connectorStatus: String,
    public val networkInterfaceId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetAdConnectorOfficeSitesSiteAdConnector): GetAdConnectorOfficeSitesSiteAdConnector = GetAdConnectorOfficeSitesSiteAdConnector(
            adConnectorAddress = javaType.adConnectorAddress(),
            connectorStatus = javaType.connectorStatus(),
            networkInterfaceId = javaType.networkInterfaceId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
