@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bundleId The bundle id of the bundle.
 * @property bundleName The name of the bundle.
 * @property bundleType The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
 * @property description The description of the bundle.
 * @property desktopType The desktop type of the bundle.
 * @property desktopTypeAttributes The desktop type attribute of the bundle.
 * @property disks The disks of the bundle.
 * @property id The ID of the bundle.
 * @property imageId The image id attribute of the bundle.
 * @property osType The os type attribute of the bundle.
 */
public data class GetBundlesBundle(
    public val bundleId: String,
    public val bundleName: String,
    public val bundleType: String,
    public val description: String,
    public val desktopType: String,
    public val desktopTypeAttributes: List<GetBundlesBundleDesktopTypeAttribute>,
    public val disks: List<GetBundlesBundleDisk>,
    public val id: String,
    public val imageId: String,
    public val osType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetBundlesBundle): GetBundlesBundle = GetBundlesBundle(
            bundleId = javaType.bundleId(),
            bundleName = javaType.bundleName(),
            bundleType = javaType.bundleType(),
            description = javaType.description(),
            desktopType = javaType.desktopType(),
            desktopTypeAttributes = javaType.desktopTypeAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetBundlesBundleDesktopTypeAttribute.Companion.toKotlin(args0)
                })
            }),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetBundlesBundleDisk.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            imageId = javaType.imageId(),
            osType = javaType.osType(),
        )
    }
}
