@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuCount The cpu count attribute of the bundle.
 * @property gpuCount The gpu count attribute of the bundle.
 * @property gpuSpec The gpu spec attribute of the bundle.
 * @property memorySize The memory size attribute of the bundle.
 */
public data class GetBundlesBundleDesktopTypeAttribute(
    public val cpuCount: Int,
    public val gpuCount: String,
    public val gpuSpec: String,
    public val memorySize: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetBundlesBundleDesktopTypeAttribute): GetBundlesBundleDesktopTypeAttribute = GetBundlesBundleDesktopTypeAttribute(
            cpuCount = javaType.cpuCount(),
            gpuCount = javaType.gpuCount(),
            gpuSpec = javaType.gpuSpec(),
            memorySize = javaType.memorySize(),
        )
    }
}
