@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commandContent The Contents of the Script to Base64 Encoded Transmission.
 * @property commandType The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
 * @property createTime The Task of Creation Time.
 * @property id The ID of the Command.
 * @property invokeDesktops The Implementation of the Target Cloud Desktop Collection.
 * @property invokeId The invoke id of the Command.
 * @property status Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
 */
public data class GetCommandsCommand(
    public val commandContent: String,
    public val commandType: String,
    public val createTime: String,
    public val id: String,
    public val invokeDesktops: List<GetCommandsCommandInvokeDesktop>,
    public val invokeId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetCommandsCommand): GetCommandsCommand = GetCommandsCommand(
            commandContent = javaType.commandContent(),
            commandType = javaType.commandType(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            invokeDesktops = javaType.invokeDesktops().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetCommandsCommandInvokeDesktop.Companion.toKotlin(args0)
                })
            }),
            invokeId = javaType.invokeId(),
            status = javaType.status(),
        )
    }
}
