@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property desktopId The desktop id of the Desktop.
 * @property dropped Output Field Text Length Exceeds 24 KB of Truncated Discarded Text Length.
 * @property errorCode Command of the Failure Or Perform the Reason for the Failure of the Code.
 * @property errorInfo Command of the Failure Or Perform the Reason for the Failure of the Details.
 * @property exitCode Command of the Failure Or Perform the Reason for the Failure of the Details.
 * @property finishTime The Script Process until the End of Time.
 * @property invocationStatus A Single Cloud Desktop Script Progress Status.
 * @property output Script the Output of the Process.
 * @property repeats Command in the Desktop Implementation.
 * @property startTime The Script Process on the Desktop, in the Start Timing of the Execution.
 * @property stopTime If You Use the invocation Indicates That the Call of the Time.
 */
public data class GetCommandsCommandInvokeDesktop(
    public val desktopId: String,
    public val dropped: Int,
    public val errorCode: String,
    public val errorInfo: String,
    public val exitCode: String,
    public val finishTime: String,
    public val invocationStatus: String,
    public val output: String,
    public val repeats: Int,
    public val startTime: String,
    public val stopTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetCommandsCommandInvokeDesktop): GetCommandsCommandInvokeDesktop = GetCommandsCommandInvokeDesktop(
            desktopId = javaType.desktopId(),
            dropped = javaType.dropped(),
            errorCode = javaType.errorCode(),
            errorInfo = javaType.errorInfo(),
            exitCode = javaType.exitCode(),
            finishTime = javaType.finishTime(),
            invocationStatus = javaType.invocationStatus(),
            output = javaType.output(),
            repeats = javaType.repeats(),
            startTime = javaType.startTime(),
            stopTime = javaType.stopTime(),
        )
    }
}
