@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCommands.
 * @property commandType
 * @property commands
 * @property contentEncoding
 * @property desktopId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 */
public data class GetCommandsResult(
    public val commandType: String? = null,
    public val commands: List<GetCommandsCommand>,
    public val contentEncoding: String? = null,
    public val desktopId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetCommandsResult): GetCommandsResult = GetCommandsResult(
            commandType = javaType.commandType().map({ args0 -> args0 }).orElse(null),
            commands = javaType.commands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetCommandsCommand.Companion.toKotlin(args0)
                })
            }),
            contentEncoding = javaType.contentEncoding().map({ args0 -> args0 }).orElse(null),
            desktopId = javaType.desktopId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
