@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customPropertyId The first ID of the resource.
 * @property id The ID of the Custom Property.
 * @property propertyKey The Custom attribute key.
 * @property propertyValues Custom attribute sets the value of.
 */
public data class GetCustomPropertiesProperty(
    public val customPropertyId: String,
    public val id: String,
    public val propertyKey: String,
    public val propertyValues: List<GetCustomPropertiesPropertyPropertyValue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetCustomPropertiesProperty): GetCustomPropertiesProperty = GetCustomPropertiesProperty(
            customPropertyId = javaType.customPropertyId(),
            id = javaType.id(),
            propertyKey = javaType.propertyKey(),
            propertyValues = javaType.propertyValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetCustomPropertiesPropertyPropertyValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
