@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomProperties.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property properties
 */
public data class GetCustomPropertiesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val properties: List<GetCustomPropertiesProperty>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetCustomPropertiesResult): GetCustomPropertiesResult = GetCustomPropertiesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetCustomPropertiesProperty.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
