@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDesktopTypes.
 * @property cpuCount
 * @property gpuCount
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceTypeFamily
 * @property memorySize
 * @property outputFile
 * @property status
 * @property types
 */
public data class GetDesktopTypesResult(
    public val cpuCount: Int? = null,
    public val gpuCount: Double? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceTypeFamily: String? = null,
    public val memorySize: Int? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val types: List<GetDesktopTypesType>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetDesktopTypesResult): GetDesktopTypesResult = GetDesktopTypesResult(
            cpuCount = javaType.cpuCount().map({ args0 -> args0 }).orElse(null),
            gpuCount = javaType.gpuCount().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceTypeFamily = javaType.instanceTypeFamily().map({ args0 -> args0 }).orElse(null),
            memorySize = javaType.memorySize().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            types = javaType.types().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopTypesType.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
