@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuCount The CPU cores.
 * @property dataDiskSize The size of the data disk. Unit: GiB.
 * @property desktopTypeId Specification ID.
 * @property gpuCount The GPU cores.
 * @property gpuSpec The GPU video memory.
 * @property id The ID of the Desktop Type.
 * @property instanceTypeFamily The Specification family.
 * @property memorySize The Memory size. Unit: MiB.
 * @property status The status of the resource.
 * @property systemDiskSize The size of the system disk. Unit: GiB.
 */
public data class GetDesktopTypesType(
    public val cpuCount: String,
    public val dataDiskSize: String,
    public val desktopTypeId: String,
    public val gpuCount: Double,
    public val gpuSpec: String,
    public val id: String,
    public val instanceTypeFamily: String,
    public val memorySize: String,
    public val status: String,
    public val systemDiskSize: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetDesktopTypesType): GetDesktopTypesType = GetDesktopTypesType(
            cpuCount = javaType.cpuCount(),
            dataDiskSize = javaType.dataDiskSize(),
            desktopTypeId = javaType.desktopTypeId(),
            gpuCount = javaType.gpuCount(),
            gpuSpec = javaType.gpuSpec(),
            id = javaType.id(),
            instanceTypeFamily = javaType.instanceTypeFamily(),
            memorySize = javaType.memorySize(),
            status = javaType.status(),
            systemDiskSize = javaType.systemDiskSize(),
        )
    }
}
