@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cpu The number of CPUs.
 * @property createTime The creation time of the Desktop.
 * @property desktopId The desktop id of the Desktop.
 * @property desktopName The desktop name of the Desktop.
 * @property desktopType The desktop type of the Desktop.
 * @property directoryId The directory id of the Desktop.
 * @property endUserIds The desktop end user id of the Desktop.
 * @property expiredTime The expired time of the Desktop.
 * @property id The ID of the Desktop.
 * @property imageId The image id of the Desktop.
 * @property memory The memory of the Desktop.
 * @property networkInterfaceId The network interface id of the Desktop.
 * @property paymentType The payment type of the Desktop.
 * @property policyGroupId The policy group id of the Desktop.
 * @property status The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
 * @property systemDiskSize The system disk size of the Desktop.
 */
public data class GetDesktopsDesktop(
    public val cpu: Int,
    public val createTime: String,
    public val desktopId: String,
    public val desktopName: String,
    public val desktopType: String,
    public val directoryId: String,
    public val endUserIds: List<String>,
    public val expiredTime: String,
    public val id: String,
    public val imageId: String,
    public val memory: String,
    public val networkInterfaceId: String,
    public val paymentType: String,
    public val policyGroupId: String,
    public val status: String,
    public val systemDiskSize: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetDesktopsDesktop): GetDesktopsDesktop = GetDesktopsDesktop(
            cpu = javaType.cpu(),
            createTime = javaType.createTime(),
            desktopId = javaType.desktopId(),
            desktopName = javaType.desktopName(),
            desktopType = javaType.desktopType(),
            directoryId = javaType.directoryId(),
            endUserIds = javaType.endUserIds().map({ args0 -> args0 }),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            memory = javaType.memory(),
            networkInterfaceId = javaType.networkInterfaceId(),
            paymentType = javaType.paymentType(),
            policyGroupId = javaType.policyGroupId(),
            status = javaType.status(),
            systemDiskSize = javaType.systemDiskSize(),
        )
    }
}
